package pbl.prezentation.sample;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

import android.app.Activity;
import android.content.res.Resources.NotFoundException;
import android.os.Bundle;
import android.view.KeyEvent;

public class Prezentation extends Activity {
	
	/**
	 * ݂̃y[Wԍ
	 */
	protected int currentPage = 1;
	/**
	 * ŏIy[W̔ԍ
	 */
	protected int lastPageNumber = 0;
	/**
	 * layoutpageprefix
	 */
	protected static String LAYOUT_PREFIX = "presentation_page_";
	/**
	 * y[Wԍƃy[WIDMap
	 */
	protected Map<Integer, Integer> pageMap = new HashMap<Integer, Integer>();
	
	
    /** Called when the activity is first created. */
    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        createPageList(LAYOUT_PREFIX);
        setContentView(R.layout.presentation_page_1);
    }
    
    /**
     * L[ꂽꍇ̓B
     * EL[L[ꂽꍇÃy[WցB
     * L[L[ꂽꍇÃy[WցB
     */
    @Override
    public boolean dispatchKeyEvent(KeyEvent event) {
        if (event.getAction() == KeyEvent.ACTION_UP) { // L[ꂽ
            switch (event.getKeyCode()) {
            case KeyEvent.KEYCODE_DPAD_CENTER: //^񒆃{^
            	startPage();
            case KeyEvent.KEYCODE_DPAD_LEFT: // \L[
                privPage();
                break;
            case KeyEvent.KEYCODE_DPAD_RIGHT: // \EL[
            	nextPage();
            	break;
            default:
            }
        }
        return super.dispatchKeyEvent(event);
    }

	/**
	 * ŏ̃y[W\
	 */
	public void startPage() {
		currentPage = 1;
		setContentView(pageMap.get(currentPage));		
	}
    
	/**
	 * ̃y[W\
	 */
	public void nextPage() {
		if(currentPage >= lastPageNumber) {
			return;
		}
		currentPage++;
		setContentView(pageMap.get(currentPage));
		
	}
	
	/**
	 * Õy[W\
	 */
	public void privPage() {
		if(currentPage <= 1) {
			currentPage = 1;
			return;
		}
		currentPage--;
		if(currentPage >= 1) {
			setContentView(pageMap.get(currentPage));
		}
	}

	/**
	 * Rt@CAy[Wɑlayoutt@C擾B
	 * 
	 * @param prefix layoutpageprefix
	 */
	protected void createPageList(String prefix) {
		try {
			Field[] fields = R.layout.class.getFields();
			List<Field> pageFields = new LinkedList<Field>();
			// prefixɃ}b`̂SĎ擾B(őy[W𓾂邽߁B)
			int prePageCount = 0;
			for (Field field : fields) {
				if (field.getName().startsWith(prefix)) {
					pageFields.add(field);
					prePageCount++;
				}
			}
			// y[Wԍƃy[WHashMap쐬B
			for(int i = 1; i <= prePageCount; i++) {
				for(Field field : pageFields) {
					if (field.getName().equals(prefix + i)) {
						Integer page = field.getInt(R.layout.class);
						pageMap.put(i, page);
						lastPageNumber++;
					}
				}
			}
		} catch (Exception e) {
			
		}
	}
    
}