package pbl.android.sample.draw;

import java.util.ArrayList;

import android.app.Activity;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.PointF;
import android.os.Bundle;
import android.view.Menu;
import android.view.MenuItem;
import android.view.MotionEvent;
import android.view.View;

public class DrawApp extends Activity {
	DrawView dv = null;
	
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        dv = new DrawView(this.getApplicationContext());
        setContentView(dv);
    }
    
    public boolean onCreateOptionsMenu(Menu menu) {
    	super.onCreateOptionsMenu(menu);
    	menu.add(0, Menu.FIRST, 0, "Clear");
    	return true;
    }
    
    public boolean onMenuItemSelected(int featureId, MenuItem item) {
    	switch(item.getItemId()) {
    	case Menu.FIRST:
    		dv.clear();
    		return true;
    	}
    	
    	return super.onMenuItemSelected(featureId, item);
    }
    
    class DrawView extends View {
	    private ArrayList<PointF> points;
    	
		public DrawView(Context context) {
			super(context);
	        setFocusable(true);
			points = new ArrayList<PointF>();
		}
    	
		protected void onDraw(Canvas c) {
	        c.drawColor(Color.WHITE);
	        if (points.size() <= 0) {
	        	return;
	        }
	       
	        Paint paint = new Paint();
	        paint.setColor(Color.BLUE);
	        PointF oldp = points.get(0);
	        PointF newp = null;
	        for (int i = 1; i < points.size(); i++) {
	            newp = points.get(i);
	            
	            if (oldp == null) {
	            	c.drawPoint(newp.x, newp.y, paint);
	            } else if (newp == null) {
	            	c.drawPoint(oldp.x, oldp.y, paint);	
	            } else {
		            c.drawLine(oldp.x, oldp.y, newp.x, newp.y, paint);
	            }
	            oldp = newp;
	        }
		}
		 
		public boolean onTouchEvent(MotionEvent e){
	        PointF p = new PointF();
			if ((e.getAction() == MotionEvent.ACTION_DOWN) || (e.getAction() == MotionEvent.ACTION_MOVE)) {
				float x = e.getX();
				float y = e.getY();
				p.set(x, y);
		        points.add(p);	
			} else if (e.getAction() == MotionEvent.ACTION_UP) {
				points.add(null);
			}
			
			this.invalidate();
			return true;
		}
		
		public void clear() {
			points = new ArrayList<PointF>();
			this.invalidate();
		}
    }
}