package pbl.android.sample.calc;

import android.app.Activity;
import android.graphics.Color;
import android.os.Bundle;
import android.view.View;
import android.widget.Button;
import android.widget.TextView;

public class CalcApp extends Activity {
	static final int NUM = 0;
	static final int EQ = 1;
	static final int SUM = 2;
	static final int SUB = 3;
	static final int MUL = 4;
	static final int DIV = 5;
	static final int SIN = 6;
	static final int COS = 7;
	static final int TAN = 8;
	
	static int op = NUM;
	static CharSequence text = "";
	static double num = 0.0;
	
	TextView tv;

	Button zero;
	Button one;
	Button two;
	Button three;
	Button four;
	Button five;
	Button six;
	Button seven;
	Button eight;
	Button nine;
	Button dot;
	
	
	Button eq;
	Button sum;
	Button sub;
	Button mul;
	Button div;
	
	Button sin;
	Button cos;
	Button tan;
	
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.main);
        
        tv = (TextView) this.findViewById(R.id.text);
        
        zero = (Button) this.findViewById(R.id.zero);
        zero.setOnClickListener(new View.OnClickListener() {
			public void onClick(View v) {
				addNum(0);
			}
        });
        one = (Button) this.findViewById(R.id.one);
        one.setOnClickListener(new View.OnClickListener() {
			public void onClick(View v) {
				addNum(1);
			}
        	
        });
    	two = (Button) this.findViewById(R.id.two);
    	two.setOnClickListener(new View.OnClickListener() {
			public void onClick(View v) {
				addNum(2);	
			}
        	
        });
    	three = (Button) this.findViewById(R.id.three);
    	three.setOnClickListener(new View.OnClickListener() {
			public void onClick(View v) {
				addNum(3);
			}
        	
        });
    	four = (Button) this.findViewById(R.id.four);
    	four.setOnClickListener(new View.OnClickListener() {
			public void onClick(View v) {
				addNum(4);
			}
        	
        });
    	five = (Button) this.findViewById(R.id.five);
    	five.setOnClickListener(new View.OnClickListener() {
			public void onClick(View v) {
				addNum(5);
			}
        	
        });
    	six = (Button) this.findViewById(R.id.six);
    	six.setOnClickListener(new View.OnClickListener() {
			public void onClick(View v) {
				addNum(6);
			}
        	
        });
    	seven = (Button) this.findViewById(R.id.seven);
    	seven.setOnClickListener(new View.OnClickListener() {
			public void onClick(View v) {
				addNum(7);
			}
        	
        });
    	eight = (Button) this.findViewById(R.id.eight);
    	eight.setOnClickListener(new View.OnClickListener() {
			public void onClick(View v) {
				addNum(8);
			}
        	
        });
    	nine = (Button) this.findViewById(R.id.nine);
    	nine.setOnClickListener(new View.OnClickListener() {
			public void onClick(View v) {
				addNum(9);
			}
        	
        });
    	
    	eq = (Button) this.findViewById(R.id.eq);
    	eq.setOnClickListener(new View.OnClickListener() {
			public void onClick(View v) {
				tv.setTextColor(Color.RED);
				calc(EQ);
			}
        	
        });
    	sum = (Button) this.findViewById(R.id.sum);
    	sum.setOnClickListener(new View.OnClickListener() {
			public void onClick(View v) {
				calc(SUM);
			}
        	
        });
    	sub = (Button) this.findViewById(R.id.sub);
    	sub.setOnClickListener(new View.OnClickListener() {
			public void onClick(View v) {
				calc(SUB);
			}
        	
        });
    	mul = (Button) this.findViewById(R.id.mul);
    	mul.setOnClickListener(new View.OnClickListener() {
			public void onClick(View v) {
				calc(MUL);
			}
        	
        });
    	div = (Button) this.findViewById(R.id.div);
    	div.setOnClickListener(new View.OnClickListener() {
			public void onClick(View v) {
				calc(DIV);
			}
        	
        });
    	
    	sin = (Button) this.findViewById(R.id.sin);
    	sin.setOnClickListener(new View.OnClickListener() {
			public void onClick(View v) {
				calc(SIN);
			}
        	
        });
    	cos = (Button) this.findViewById(R.id.cos);
    	cos.setOnClickListener(new View.OnClickListener() {
			public void onClick(View v) {
				calc(COS);
			}
        	
        });
    	tan = (Button) this.findViewById(R.id.tan);
    	tan.setOnClickListener(new View.OnClickListener() {
			public void onClick(View v) {
				calc(TAN);
			}
        	
        });
    }
    
    public void addNum(int num) {
    	if (op == EQ) {
    		tv.setTextColor(Color.BLACK);
    	}
    	text = text + String.valueOf(num);
		tv.setText(text);
		
    }
    
    public void calc(int mode) {
    	double n;
    	
    	if (tv.getText().equals("")) {
    		op = mode;
    		return;
    	}
    	
    	switch (op) {
    	case NUM:
    		n = Double.parseDouble(text.toString());
    		num = num + n;
    		op = mode;
    		break;
    	case EQ:
    		op = mode;
    		break;
    	case SUM:
    		n = Double.parseDouble(text.toString());
    		num = num + n;
    		op = mode;
    		break;
    	case SUB:
    		n = Double.parseDouble(text.toString());
    		num = num - n;
    		op = mode;
    		break;
    	case MUL:
    		n = Double.parseDouble(text.toString());
    		num = num * n;
    		op = mode;
    		break;
    	case DIV:
    		n = Double.parseDouble(text.toString());
    		num = num / n;
    		op = mode;
    		break;
    	default:
    		break;
    	}
    	
    	switch (mode) {
    	case SIN:
    		num = Math.sin(num);
    		op = NUM;
    		break;
    	case COS:
    		num = Math.cos(num);
    		op = NUM;
    		break;
    	case TAN:
    		num = Math.tan(num);
    		op = NUM;
    		break;
    	default:
    		break;
    	}
    	
    	if (Math.floor(num) == num) {
    		tv.setText(String.valueOf((int) num));
    	} else {
    		tv.setText(String.valueOf(num));
    	}

		text = "";
    }
}