/***
 * Copyright(C) 2009 Naoki Inaba and Hirofumi Fujiwara
 * Puzzle Project Room, Time Intermedia Corporation <puzzle@timedia.co.jp>
 * All rights reserved.
 * We make no gurantees that this code if fit for any purpose.
 * Visit http://puzzle.gr.jp/ for more information.
 ***/
package org.example.sudoku;

import android.graphics.Point;

public class MakeData {
    static int      board[][]       = new int[9][9];
    static boolean   hint[][]       = new boolean[9][9];
    static  boolean error[][]       = new boolean[9][9];
    static  int     errorCount;
    static  int     hintCount;
    static Point    currentPos  = new Point(0,0);
    
    static  int     level;
    
    static  int     point;
    
    static  boolean finished;
    
    static void setValue(int x, int y, int v) { board[x][y] = v;    }
    static int   getValue(int x, int y)         {   return board[x][y]; }
    static  int[][]     getBoard()              {   return board;       }
    static  boolean isHint(int x, int y)    {   return hint[x][y];  }
    static  boolean isHint()                {   return  hint[currentPos.x][currentPos.y];   }
    static  int     getHintCount()              {   return hintCount;       }
    
    static  String  getQuestionString() {
        String  question = "";
        for( int y=0; y<9; ++y )
            for( int x=0; x<9; ++x )
                question +=  hint[x][y] ? board[x][y] : 0;      
        
        return  question;
    }
    
    static  void    setBoard(int[][] bd) {
        for( int x=0; x<9; ++x )
            for( int y=0; y<9; ++y ) {
                board[x][y] = bd[x][y];
            }
    }
    
    static  void    setHint(boolean[][] ht) {
        for( int x=0; x<9; ++x )
            for( int y=0; y<9; ++y )
                hint[x][y] = ht[x][y];
        setupHintCount();
    }
    
    static  void    setupHintCount() {
        hintCount = 0;
        for( int x=0; x<9; ++x )
            for( int y=0; y<9; ++y )
                if( hint[x][y] )
                    ++hintCount;
    }
    
    static  void clearBoard() {
        for( int x=0; x<9; ++x )
            for( int y=0; y<9; ++y ) {
                board[x][y] = 0;
                hint[x][y]  = false;
            }
        setupHintCount();
    }
    static  void clearBoardHint() {
        for( int x=0; x<9; ++x )
            for( int y=0; y<9; ++y ) {
                hint[x][y]  = false;
            }
        setupHintCount();
    }   
    static  void clearBoardEnter() {
        for( int x=0; x<9; ++x )
            for( int y=0; y<9; ++y ) {
                if( !hint[x][y])
                    board[x][y] = 0;
            }       
    }    
    static  void clearBoardNumber() {
        for( int x=0; x<9; ++x )
            for( int y=0; y<9; ++y ) {
                board[x][y] = 0;
            }       
    }

    static  void    clearInputNumber() {
        for( int x=0; x<9; ++x )
            for( int y=0; y<9; ++y ) {
                if( !hint[x][y] )
                    board[x][y] = 0;
            }               
    }
    
    static void changeHint() {
        hint[currentPos.x][currentPos.y] = !hint[currentPos.x][currentPos.y];
        setupHintCount();
    }
    
    static void moveDeltaCurrent(Point p) {
        moveCurrent((currentPos.x + p.x + 9) % 9, (currentPos.y + p.y + 9) % 9);
    } 
    static void moveCurrent(int x, int y) {
        if( x<0 || x>=9 || y<0 || y>=9 )
            return;     
        currentPos = new Point(x,y);
    }
    
    static  void    checkError() {
        errorCount = 0;
        for( int x=0; x<9; ++x )
            for( int y=0; y<9; ++y ) {
                int val = board[x][y];
                boolean err = error[x][y] = false;
                if( val == 0 )
                    continue;
                for( int u=0; (!err) && u<9; ++u ) {
                    if( x == u )
                        continue;
                    int vu = board[u][y];
                    if( vu > 0 && vu==val )
                        err = true;
                }
                for( int v=0; !err && v<9; ++v ) {
                    if( y == v )
                        continue;
                    int vv = board[x][v];
                    if( vv > 0 && vv== val )
                        err = true;
                }
                int bx = (x/3)*3;
                int by = (y/3)*3;
                for( int xi=0; xi<3; ++xi )
                    for( int yi=0; yi<3; ++yi ) {
                        if( err )
                            break;
                        int xw = bx + xi;
                        int yw = by + yi;
                        if( x==xw && y==yw )
                            continue;
                        int vw = board[xw][yw];
                        if( vw > 0 && vw==val )
                            err = true;
                    }
                if( err ) {
                    error[x][y] = err;
                    ++errorCount;
                }
            }
    }
    
    static  void    checkFinish() {
        finished = false;
        int     bits;
        
        for( int x=0; x<9; ++x ) {
            bits = 0;
            for( int y=0; y<9; ++y) {
                bits |= 1<<board[x][y];
            }
            if( bits != 0x3fe)
                return;
        }
        for( int y=0; y<9; ++y ) {
            bits = 0;
            for( int x=0; x<9; ++x ) {
                bits |= 1<<board[x][y];
            }
            if( bits != 0x3fe)
                return;
        }
        for( int x=0; x<9; x+=3 )
            for( int y=0; y<9; y+=3 ) {
                bits = 0;
                for( int xi=0; xi<3; ++xi )
                    for( int yi=0; yi<3; ++yi ) {
                        bits |= 1<<board[x+xi][y+yi];
                    }
                if( bits != 0x3fe )
                    return;
            }
        
        finished = true;
    }
}
