/***
 * Copyright(C) 2009 Naoki Inaba and Hirofumi Fujiwara
 * Puzzle Project Room, Time Intermedia Corporation <puzzle@timedia.co.jp>
 * All rights reserved.
 * We make no gurantees that this code if fit for any purpose.
 * Visit http://puzzle.gr.jp/ for more information.
 ***/
package org.example.sudoku;

import jp.gr.puzzle.npgenerator.v1.Eval;
import jp.gr.puzzle.npgenerator.v1.Generator;
import jp.gr.puzzle.npgenerator.v1.Problem;

public class Make {
    private static  Generator   generator = new Generator();
    private     static  Pattern     pattern   = new Pattern();
    private static  Problem     problem   = new Problem();
    private static  Eval        eval      = new Eval();
    
    private static  boolean    isunique;
    private static  MakeThread  running;
    
    class MakeThread extends Thread {       
        @Override
        public void run() {
            do {    // 問題作成、完成するまで続ける
                MakeData.setHint(pattern.generateHint(MakeData.level)); 
            } while( !execution() );
            
            // できた問題をpost()
            Game.handler.post(Game.notifyProblemReady);
        }
    }
    
    public  String makePuzzle(int diff) {
        MakeData.level = diff;
        
        running = new MakeThread();
        running.start();
        
        return  "000000000000000000000000000" +
                 "000000000000000000000000000" +
                 "000000000000000000000000000";
    }
    
    private static  boolean execution() {
        MakeData.clearBoardNumber();
        isunique = false;
        int loopcount = 0;
        
        boolean limitcheck = false;
        
        while( (!isunique) || (!limitcheck) ) {
            if( ++loopcount > 2 )
                return false;
            problem = generator.make( MakeData.hint );
            isunique = problem.isUnique();          
            eval.solve(problem.getQuestion());
            MakeData.point = eval.getPoint();
            if(!isunique)
                MakeData.point = 0;
            
            if( !isunique )
                continue;

            limitcheck = true;
            switch(MakeData.level) {
            case Game.DIFFICULTY_EASY:
                limitcheck = MakeData.point <= 60;
                break;
            case Game.DIFFICULTY_MEDIUM:
                limitcheck = MakeData.point> 60 && 
                                    MakeData.point <= 100;
                break;
            case Game.DIFFICULTY_HARD:
                limitcheck = MakeData.point > 100;
            }
        }
        
        problem.getSolution(MakeData.board);
        MakeData.clearInputNumber();
        
        return  true;
    }
}
