package jp.gr.puzzle.npgenerator.v1;

import java.util.Random;

/*
 * Copyright 2007 Time Intermedia Corporation
 * Puzzle Project Room, Hirofumi Fujiwara and Naoki Inaba
 */

public class Calc {
   public static int zone( int p, int q ) {
      return (p/Const.bsize)*Const.bsize + (q/Const.bsize);
   }
   
   public static int area( int p, int q ) {
      return (p % Const.bsize)*Const.bsize + (q % Const.bsize);
   }
   
   public static int ztox( int i, int j ) {
      return (i / Const.bsize) * Const.bsize + j / Const.bsize;
   }
   
   public static int ztoy( int i, int j ) {
      return (i % Const.bsize) * Const.bsize + j % Const.bsize;
   } 
   
   public static void copyBoard( int[][] frombd, int[][] tobd ) {
      for( int i=0; i<Const.size; ++i )
         for( int j=0; j<Const.size; ++j )
            tobd[i][j] = frombd[i][j];
   }

   private static Random   random = new Random();
   
   public static void srand( long seed ) {
      // Javaのseed処理が悪いため、計算してから処理。
      seed = (seed <<32) + seed;
      random = new Random(seed);
   }
   
   public static double random() {
      return random.nextDouble();
   }
   
   public static int randomInt( int n ) {
      return random.nextInt(n);
   }
}
