package pbl.s3.is09.sample;

import android.widget.*;
import android.app.AlertDialog;
import android.content.*;
import android.graphics.Bitmap;
import android.graphics.BlurMaskFilter;
import android.graphics.Canvas;
import android.graphics.EmbossMaskFilter;
import android.graphics.MaskFilter;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.os.Bundle;
import android.view.KeyEvent;
import android.view.Menu;
import android.view.MenuItem;
import android.view.MotionEvent;
import android.view.View;
import java.awt.*;


public class FingerPaint extends GraphicsActivity
        implements ColorPickerDialog.OnColorChangedListener {    
	float x1,x2,x3,y1,y2,y3;
	int color,line,thick=6;
	
	private MyView mView;
	private EditText edit;
    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        mView = new MyView(this);
        setContentView(mView);

        mPaint = new Paint();
        mPaint.setAntiAlias(true);
        mPaint.setDither(true);
        mPaint.setColor(0xFFFF0000);
        mPaint.setStyle(Paint.Style.STROKE);
        mPaint.setStrokeJoin(Paint.Join.ROUND);
        mPaint.setStrokeCap(Paint.Cap.ROUND);
        mPaint.setStrokeWidth(6);
        
        mEmboss = new EmbossMaskFilter(new float[] { 1, 1, 1 },
                                       0.4f, 6, 3.5f);

        mBlur = new BlurMaskFilter(8, BlurMaskFilter.Blur.NORMAL);
    }
    
    private Paint       mPaint;
    private MaskFilter  mEmboss;
    private MaskFilter  mBlur;
    
    public void colorChanged(int color) {
        mPaint.setColor(color);
    }

    public class MyView extends View {
        
        private static final float MINP = 0.25f;
        private static final float MAXP = 0.75f;
        
        private Bitmap  mBitmap;
        private Canvas  mCanvas;
        private Path    mPath;
        private Paint   mBitmapPaint;
        
        
        public MyView(Context c) {
            super(c);
            
            mBitmap = Bitmap.createBitmap(320, 480, Bitmap.Config.ARGB_8888);
            mCanvas = new Canvas(mBitmap);
            mPath = new Path();
            mBitmapPaint = new Paint(Paint.DITHER_FLAG);
        }

        @Override
        protected void onSizeChanged(int w, int h, int oldw, int oldh) {
            super.onSizeChanged(w, h, oldw, oldh);
        }
        
        @Override
        protected void onDraw(Canvas canvas) {
            canvas.drawColor(0xFFAAAAAA);
            
            canvas.drawBitmap(mBitmap, 0, 0, mBitmapPaint);
            
            canvas.drawPath(mPath, mPaint);
        }
        
        private float mX, mY;
        private static final float TOUCH_TOLERANCE = 4;
        
        private void touch_start(float x, float y) {
            mPath.reset();
            mPath.moveTo(x, y);
            mX = x;
            mY = y;
        }
        private void touch_move(float x, float y) {
            float dx = Math.abs(x - mX);
            float dy = Math.abs(y - mY);
            if (dx >= TOUCH_TOLERANCE || dy >= TOUCH_TOLERANCE) {
                mPath.quadTo(mX, mY, (x + mX)/2, (y + mY)/2);
                mX = x;
                mY = y;
            }
        }
        private void touch_up() {
            mPath.lineTo(mX, mY);
            // commit the path to our offscreen
            mCanvas.drawPath(mPath, mPaint);
            // kill this so we don't double draw
            mPath.reset();
        }
        public void line(float a,float b,float x,float y){
        	mPaint.setColor(color);
        	mPaint.setStrokeWidth(thick);
        	mCanvas.drawLine(a,b,x,y,mPaint);
        	invalidate();
        }
        public void line2(float a,float b,float x,float y){
        	mPaint.setColor(0xFFAAAAAA);
        	mPaint.setStrokeWidth(thick*2);
        	mCanvas.drawLine(a,b,x,y,mPaint);
        	invalidate();
        }
        @Override
        public boolean onTouchEvent(MotionEvent event) {
        	float x = event.getX();
            float y = event.getY();
        	if (line>0){
        	switch (event.getAction()) {
        		case MotionEvent.ACTION_DOWN:
        			color=mPaint.getColor();
        			x1=x;
        			y1=y;
        			break;
        		case MotionEvent.ACTION_MOVE:
        			if(line==3)break;
        			x3=x2;
        			y3=y2;
        			x2=x;
        			y2=y;
        			if(line==1)line2(x1,y1,x3,y3);
        			line(x1,y1,x2,y2);
        			break;
        		case MotionEvent.ACTION_UP:
        			line(x1,y1,x,y);
        			break;
        		}
        	return true;
        	}
        	
        	else{
            switch (event.getAction()) {
                case MotionEvent.ACTION_DOWN:
                    touch_start(x, y);
                    invalidate();
                    break;
                case MotionEvent.ACTION_MOVE:
                    touch_move(x, y);
                    invalidate();
                    break;
                case MotionEvent.ACTION_UP:
                    touch_up();
                    invalidate();
                    break;
            }
            return true;
        	}
        }
        public void clear(){
        	mCanvas.drawColor(0xFFAAAAAA);
        	invalidate();
        }
        //A[g_CAO
    }
    
    private static final int COLOR_MENU_ID = Menu.FIRST;
    private static final int EMBOSS_MENU_ID = Menu.FIRST + 1;
    private static final int BLUR_MENU_ID = Menu.FIRST + 2;
    private static final int ERASE_MENU_ID = Menu.FIRST + 3;
    private static final int SRCATOP_MENU_ID = Menu.FIRST + 4;
    private static final int CLEAR_MENU_ID = Menu.FIRST+5;
    private static final int LINE_MENU_ID = Menu.FIRST+6;
    private static final int FLASH_MENU_ID = Menu.FIRST+7;
    private static final int THICK_MENU_ID = Menu.FIRST+8;
    @Override
    public boolean onCreateOptionsMenu(Menu menu) {
        super.onCreateOptionsMenu(menu);
        
        menu.add(0, COLOR_MENU_ID, 0, "Color").setShortcut('1', 'a');
        menu.add(0, EMBOSS_MENU_ID, 0, "Emboss").setShortcut('2', 's');
        menu.add(0, BLUR_MENU_ID, 0, "Blur").setShortcut('3', 'd');
        menu.add(0, ERASE_MENU_ID, 0, "Erase").setShortcut('4', 'f');
        menu.add(0, SRCATOP_MENU_ID, 0, "SrcATop").setShortcut('5', 'g');
        menu.add(0, CLEAR_MENU_ID, 0, "CLEAR").setShortcut('6', 'h');
        menu.add(0, LINE_MENU_ID, 0, "LINE").setShortcut('7', 'j');
        menu.add(0, FLASH_MENU_ID, 0, "FLASH").setShortcut('8', 'k');
        menu.add(0, THICK_MENU_ID, 0, "THICK").setShortcut('9', 'l');
        /****   Is this the mechanism to extend with filter effects?
        Intent intent = new Intent(null, getIntent().getData());
        intent.addCategory(Intent.CATEGORY_ALTERNATIVE);
        menu.addIntentOptions(
                              Menu.ALTERNATIVE, 0,
                              new ComponentName(this, NotesList.class),
                              null, intent, 0, null);
        *****/
        return true;
    }
    
    @Override
    public boolean onPrepareOptionsMenu(Menu menu) {
        super.onPrepareOptionsMenu(menu);
        return true;
    }
    
    @Override
    public boolean onOptionsItemSelected(MenuItem item) {
        mPaint.setXfermode(null);
        mPaint.setAlpha(0xFF);

        switch (item.getItemId()) {
            case COLOR_MENU_ID:
                new ColorPickerDialog(this, this, mPaint.getColor()).show();
                return true;
            case EMBOSS_MENU_ID:
                if (mPaint.getMaskFilter() != mEmboss) {
                    mPaint.setMaskFilter(mEmboss);
                } else {
                    mPaint.setMaskFilter(null);
                }
                return true;
            case BLUR_MENU_ID:
                if (mPaint.getMaskFilter() != mBlur) {
                    mPaint.setMaskFilter(mBlur);
                } else {
                    mPaint.setMaskFilter(null);
                }
                return true;
            case ERASE_MENU_ID:
                mPaint.setXfermode(new PorterDuffXfermode(
                                                        PorterDuff.Mode.CLEAR));
                return true;
            case SRCATOP_MENU_ID:
                mPaint.setXfermode(new PorterDuffXfermode(
                                                    PorterDuff.Mode.SRC_ATOP));
                mPaint.setAlpha(0x80);
                return true;
            case CLEAR_MENU_ID:
            	mView.clear();
            	return true;
            case LINE_MENU_ID:
            	if (line==0||line==2){
            		line=1;
            		return true;
            	}
            	else if (line==1){
            		line=3;
            		return true;
            	}
            	else {
            		line=1;
            		return true;
            	}
            case FLASH_MENU_ID:
            	if (line!=2){
            		line=2;
            		return true;
            	}
            	else {
            		line=0;
            		return true;
            	}
            case THICK_MENU_ID:
            	edit=new EditText(this);
            	edit.setWidth(50);
            	AlertDialog.Builder b = new AlertDialog.Builder(this);
            	b.setTitle("̑w肵Ăipixelj");
            	b.setView(edit);
            	b.setPositiveButton("OK",new DialogInterface.OnClickListener(){
            		public void onClick(DialogInterface dialog,int whichButton){
            		thick=Integer.parseInt(edit.getText().toString());
                    mPaint.setStrokeWidth(thick);
            		}
            	});
            	b.setNegativeButton("Cancel",new DialogInterface.OnClickListener(){
            		public void onClick(DialogInterface dialog,int whichButton){
            		}
            	});
            	b.show();
            	return true;
            	
        }
        return super.onOptionsItemSelected(item);
    }
}
