/*******************************************************************************
 * Copyright (c) 2007, 2008 Oracle. All rights reserved.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v1.0, which accompanies this distribution
 * and is available at http://www.eclipse.org/legal/epl-v10.html.
 * 
 * Contributors:
 *     Oracle - initial API and implementation
 ******************************************************************************/
package org.eclipse.jpt.ui.internal.platform.base;

import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.window.Window;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.jpt.core.JpaProject;
import org.eclipse.jpt.ui.internal.JptUiMessages;
import org.eclipse.jpt.ui.internal.wizards.gen.GenerateEntitiesFromSchemaWizard;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;

/**
 *  EntitiesGenerator
 */
public class EntitiesGenerator2 {
	private JpaProject project;
	private IStructuredSelection selection;

	public static void generate(JpaProject project, IStructuredSelection selection) {
		new EntitiesGenerator2(project, selection).generate();
	}
	
	private EntitiesGenerator2(JpaProject project, IStructuredSelection selection) {
		super();
		if (project == null) {
			throw new NullPointerException();
		}
		this.project = project;
		this.selection = selection;
	}


	// ********** generate **********

	/**
	 * prompt the user with a wizard;
	 * schedule a job to generate the entities;
	 * optionally schedule a job to synchronize persistence.xml to
	 * run afterwards
	 */
	protected void generate() {
		GenerateEntitiesFromSchemaWizard wizard = new GenerateEntitiesFromSchemaWizard(this.project, this.selection);
		WizardDialog dialog = new WizardDialog(this.getCurrentShell(), wizard);
		dialog.create();
		int returnCode = dialog.open();
		if (returnCode != Window.OK) {
			return;
		}
		//Entities generation happens in the GenerateEntitiesFromSchemaWizard.performFinish()
		//method
	}
	
	private Shell getCurrentShell() {
	    return Display.getCurrent().getActiveShell();
	}


}
