/*******************************************************************************
 * Copyright (c) 2008 Oracle. All rights reserved.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v1.0, which accompanies this distribution
 * and is available at http://www.eclipse.org/legal/epl-v10.html.
 * 
 * Contributors:
 *     Oracle - initial API and implementation
 ******************************************************************************/
package org.eclipse.jpt.core.context;

/**
 * 
 * 
 * Provisional API: This interface is part of an interim API that is still
 * under development and expected to change significantly before reaching
 * stability. It is available at this early stage to solicit feedback from
 * pioneering adopters on the understanding that any code that uses this API
 * will almost certainly be broken (repeatedly) as the API evolves.
 * 
 * @version 2.1
 * @since 2.1
 */
public interface Converter extends JpaContextNode
{
	/**
	 * Return a string that represents the type of converter.
	 * Possibilities are below, NO_CONVERTER, LOB_CONVERTER, ENUMERATED_CONVERTER, TEMPORAL_CONVERTER
	 */
	String getType();
	
	String NO_CONVERTER = "noConverter"; //$NON-NLS-1$
	String LOB_CONVERTER = "lobConverter"; //$NON-NLS-1$
	String ENUMERATED_CONVERTER = "enumeratedConverter"; //$NON-NLS-1$
	String TEMPORAL_CONVERTER = "temporalConverter"; //$NON-NLS-1$
	
	/**
	 * Remove the Converter from the resource model
	 */
	void removeFromResourceModel();
	
	/**
	 * Add the appropriate Converter to the resource model
	 */
	void addToResourceModel();
	
	
	//****** covariant overrides ******
	AttributeMapping getParent();

}