/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.eclipselink.ui.internal.mappings.details;

import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.jpt.eclipselink.core.context.ConversionValue;
import org.eclipse.jpt.eclipselink.core.context.ObjectTypeConverter;
import org.eclipse.jpt.eclipselink.ui.internal.mappings.EclipseLinkUiMappingsMessages;
import org.eclipse.jpt.eclipselink.ui.internal.mappings.details.ConversionValueStateObject;
import org.eclipse.jpt.ui.internal.widgets.DialogPane;
import org.eclipse.jpt.ui.internal.widgets.ValidatingDialog;
import org.eclipse.jpt.utility.internal.CollectionTools;
import org.eclipse.jpt.utility.internal.model.value.PropertyAspectAdapter;
import org.eclipse.jpt.utility.model.value.WritablePropertyValueModel;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConversionValueDialog
extends ValidatingDialog<ConversionValueStateObject> {
    private final ConversionValue conversionValue;
    private ObjectTypeConverter objectTypeConverter;

    public ConversionValueDialog(Shell parent, ObjectTypeConverter objectTypeConverter) {
        this(parent, objectTypeConverter, null);
    }

    public ConversionValueDialog(Shell parent, ObjectTypeConverter objectTypeConverter, ConversionValue conversionValue) {
        super(parent);
        this.objectTypeConverter = objectTypeConverter;
        this.conversionValue = conversionValue;
    }

    protected ConversionValueStateObject buildStateObject() {
        String dataValue = null;
        String objectValue = null;
        HashSet dataValues = CollectionTools.set((Iterator)this.objectTypeConverter.dataValues());
        if (this.isEditDialog()) {
            dataValue = this.conversionValue.getDataValue();
            objectValue = this.conversionValue.getObjectValue();
            dataValues.remove(dataValue);
        }
        return new ConversionValueStateObject(dataValue, objectValue, dataValues);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(this.getTitle());
    }

    protected String getTitle() {
        return this.isAddDialog() ? EclipseLinkUiMappingsMessages.ConversionValueDialog_addConversionValue : EclipseLinkUiMappingsMessages.ConversionValueDialog_editConversionValue;
    }

    protected String getDescriptionTitle() {
        return this.isAddDialog() ? EclipseLinkUiMappingsMessages.ConversionValueDialog_addConversionValueDescriptionTitle : EclipseLinkUiMappingsMessages.ConversionValueDialog_editConversionValueDescriptionTitle;
    }

    protected String getDescription() {
        return this.isAddDialog() ? EclipseLinkUiMappingsMessages.ConversionValueDialog_addConversionValueDescription : EclipseLinkUiMappingsMessages.ConversionValueDialog_editConversionValueDescription;
    }

    protected DialogPane<ConversionValueStateObject> buildLayout(Composite container) {
        return new ConversionValueDialogPane(container);
    }

    public void create() {
        super.create();
        ConversionValueDialogPane pane = (ConversionValueDialogPane)this.getPane();
        pane.selectAll();
        this.getButton(0).setEnabled(false);
    }

    protected boolean isAddDialog() {
        return this.conversionValue == null;
    }

    protected boolean isEditDialog() {
        return !this.isAddDialog();
    }

    public String getDataValue() {
        return ((ConversionValueStateObject)this.getSubject()).getDataValue();
    }

    public String getObjectValue() {
        return ((ConversionValueStateObject)this.getSubject()).getObjectValue();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ConversionValueDialogPane
    extends DialogPane<ConversionValueStateObject> {
        private Text dataValueText;
        private Text objectValueText;

        ConversionValueDialogPane(Composite parent) {
            super(ConversionValueDialog.this.getSubjectHolder(), parent);
        }

        protected void initializeLayout(Composite container) {
            this.dataValueText = this.addLabeledText(container, EclipseLinkUiMappingsMessages.ConversionValueDialog_dataValue, this.buildDataValueHolder());
            this.objectValueText = this.addLabeledText(container, EclipseLinkUiMappingsMessages.ConversionValueDialog_objectValue, this.buildObjectValueHolder());
        }

        private WritablePropertyValueModel<String> buildDataValueHolder() {
            return new PropertyAspectAdapter<ConversionValueStateObject, String>(this.getSubjectHolder(), new String[]{"dataValue"}){

                protected String buildValue_() {
                    return ((ConversionValueStateObject)((Object)this.subject)).getDataValue();
                }

                protected void setValue_(String value) {
                    ((ConversionValueStateObject)((Object)this.subject)).setDataValue(value);
                }
            };
        }

        private WritablePropertyValueModel<String> buildObjectValueHolder() {
            return new PropertyAspectAdapter<ConversionValueStateObject, String>(this.getSubjectHolder(), new String[]{"objectValue"}){

                protected String buildValue_() {
                    return ((ConversionValueStateObject)((Object)this.subject)).getObjectValue();
                }

                protected void setValue_(String value) {
                    ((ConversionValueStateObject)((Object)this.subject)).setObjectValue(value);
                }
            };
        }

        void selectAll() {
            this.dataValueText.selectAll();
            this.objectValueText.selectAll();
        }
    }
}

