/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.common.jdt.internal.integration;

import java.util.Set;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jst.common.jdt.internal.integration.WorkingCopyManager;
import org.eclipse.jst.common.jdt.internal.integration.WorkingCopyManagerFactory;
import org.eclipse.jst.common.jdt.internal.integration.WorkingCopyProvider;
import org.eclipse.wst.common.componentcore.internal.ArtifactEditModel;
import org.eclipse.wst.common.frameworks.internal.SaveFailedException;
import org.eclipse.wst.common.internal.emf.resource.ReferencedResource;
import org.eclipse.wst.common.internal.emf.resource.TranslatorResource;
import org.eclipse.wst.common.internal.emfworkbench.EMFWorkbenchContext;

public class JavaArtifactEditModel
extends ArtifactEditModel
implements WorkingCopyProvider {
    private WorkingCopyManager workingCopyManager = null;

    public JavaArtifactEditModel(String anEditModelId, EMFWorkbenchContext context, boolean toMakeReadOnly, boolean toAccessUnknownResourcesAsReadOnly, URI moduleURI, URI rootURI, String rootContentType) {
        super(anEditModelId, context, toMakeReadOnly, toAccessUnknownResourcesAsReadOnly, moduleURI, rootURI, rootContentType);
    }

    public JavaArtifactEditModel(String editModelID, EMFWorkbenchContext context, boolean toMakeReadOnly, URI moduleURI, URI rootURI, String rootContentType) {
        super(editModelID, context, toMakeReadOnly, moduleURI, rootURI, rootContentType);
    }

    public JavaArtifactEditModel(String anEditModelId, EMFWorkbenchContext aContext, boolean toMakeReadOnly, boolean toAccessUnknownResourcesAsReadOnly, URI aModuleURI) {
        super(anEditModelId, aContext, toMakeReadOnly, toAccessUnknownResourcesAsReadOnly, aModuleURI);
    }

    public JavaArtifactEditModel(String anEditModelId, EMFWorkbenchContext aContext, boolean toMakeReadOnly, URI aModuleURI) {
        super(anEditModelId, aContext, toMakeReadOnly, aModuleURI);
    }

    public void delete(ICompilationUnit cu, IProgressMonitor monitor) {
        this.getWorkingCopyManager().delete(cu, monitor);
    }

    protected void doDispose() {
        super.doDispose();
        this.resetWorkingCopyManager();
    }

    public Set getAffectedFiles() {
        Set affected = super.getAffectedFiles();
        if (this.getWorkingCopyManager() != null) {
            affected.addAll(this.getWorkingCopyManager().getAffectedFiles());
        }
        return affected;
    }

    public ICompilationUnit getExistingWorkingCopy(ICompilationUnit cu) throws CoreException {
        return this.getWorkingCopyManager().getExistingWorkingCopy(cu);
    }

    public ICompilationUnit getWorkingCopy(ICompilationUnit cu, boolean forNewCU) throws CoreException {
        return this.getWorkingCopyManager().getWorkingCopy(cu, forNewCU);
    }

    protected void handleSaveIfNecessaryDidNotSave(IProgressMonitor monitor) {
        this.getWorkingCopyManager().saveOnlyNewCompilationUnits(monitor);
    }

    public boolean isDirty() {
        boolean dirtyBool = super.isDirty();
        if (!dirtyBool && this.getWorkingCopyManager() != null) {
            dirtyBool = this.getWorkingCopyManager().hasWorkingCopies();
        }
        return dirtyBool;
    }

    public void primSave(IProgressMonitor monitor) {
        this.saveCompilationUnits(monitor);
        if (monitor == null || !monitor.isCanceled()) {
            super.primSave(monitor);
        }
    }

    protected void runSaveOperation(IWorkspaceRunnable runnable, IProgressMonitor monitor) throws SaveFailedException {
        try {
            ResourcesPlugin.getWorkspace().run(runnable, null, 1, monitor);
        }
        catch (CoreException e) {
            throw new SaveFailedException((Exception)((Object)e));
        }
    }

    public void processResource(Resource aResource) {
        if (aResource != null && !this.getResources().contains(aResource)) {
            if (aResource instanceof ReferencedResource) {
                this.access((ReferencedResource)aResource);
                ((ReferencedResource)aResource).setFormat(1);
            } else if (!this.isReadOnly()) {
                aResource.setTrackingModification(true);
            }
            this.addResource(aResource);
        }
    }

    protected void release(Resource aResource) {
        this.removeResource(aResource);
        if (aResource != null) {
            boolean isRefRes = aResource instanceof ReferencedResource;
            if (isRefRes) {
                this.release((ReferencedResource)aResource);
            }
            if (!this.isDisposing()) {
                this.resetWorkingCopyManager();
            }
        }
    }

    protected void resourceIsLoadedChanged(Resource aResource, boolean oldValue, boolean newValue) {
        if (!this.isReverting && !this.disposing && !this.isReadOnly() && oldValue && !newValue && aResource instanceof TranslatorResource) {
            this.resetWorkingCopyManager();
        }
        super.resourceIsLoadedChanged(aResource, oldValue, newValue);
    }

    protected void reverted(ReferencedResource revertedResource) {
        if (this.getWorkingCopyManager() != null) {
            this.getWorkingCopyManager().revert();
        }
        this.revertAllResources();
    }

    public void saveCompilationUnits(IProgressMonitor monitor) {
        this.getWorkingCopyManager().saveCompilationUnits(monitor);
    }

    public WorkingCopyManager getWorkingCopyManager() {
        if (this.workingCopyManager == null) {
            this.workingCopyManager = WorkingCopyManagerFactory.newRegisteredInstance();
        }
        return this.workingCopyManager;
    }

    protected void resetWorkingCopyManager() {
        if (this.workingCopyManager != null) {
            this.workingCopyManager.dispose();
            this.workingCopyManager = null;
        }
    }
}

