/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.server.ui.internal.wizard.page;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ui.help.IWorkbenchHelpSystem;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IModuleType;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IRuntimeType;
import org.eclipse.wst.server.core.IRuntimeWorkingCopy;
import org.eclipse.wst.server.core.IServerAttributes;
import org.eclipse.wst.server.core.IServerType;
import org.eclipse.wst.server.core.IServerWorkingCopy;
import org.eclipse.wst.server.core.ServerUtil;
import org.eclipse.wst.server.core.TaskModel;
import org.eclipse.wst.server.core.internal.ServerWorkingCopy;
import org.eclipse.wst.server.core.util.SocketUtil;
import org.eclipse.wst.server.ui.internal.ImageResource;
import org.eclipse.wst.server.ui.internal.Messages;
import org.eclipse.wst.server.ui.internal.SWTUtil;
import org.eclipse.wst.server.ui.internal.ServerUIPlugin;
import org.eclipse.wst.server.ui.internal.Trace;
import org.eclipse.wst.server.ui.internal.viewers.ServerTypeComposite;
import org.eclipse.wst.server.ui.internal.wizard.TaskWizard;
import org.eclipse.wst.server.ui.internal.wizard.WizardTaskUtil;
import org.eclipse.wst.server.ui.internal.wizard.page.NewServerComposite;
import org.eclipse.wst.server.ui.internal.wizard.page.ServerCreationCache;
import org.eclipse.wst.server.ui.wizard.WizardFragment;

public class NewManualServerComposite
extends Composite {
    protected IWizardHandle2 wizard;
    protected ServerTypeComposite serverTypeComposite;
    protected Label runtimeLabel;
    protected Combo runtimeCombo;
    protected Link configureRuntimes;
    protected Link addRuntime;
    protected IRuntime[] runtimes;
    protected IRuntime newRuntime;
    protected Text serverName;
    protected String defaultServerName;
    protected boolean serverNameModified;
    protected boolean updatingServerName;
    protected ToolBarManager serverNameToolBar;
    protected IRuntime runtime;
    protected IServerWorkingCopy server;
    protected ServerSelectionListener listener;
    protected String host;
    protected IModuleType moduleType;
    protected IModule module;
    protected String serverTypeId;
    protected boolean includeIncompatible;
    protected ServerCreationCache cache = new ServerCreationCache();

    public NewManualServerComposite(Composite parent, IWizardHandle2 wizard, IModuleType moduleType, IModule module, String serverTypeId, boolean includeIncompatible, ServerSelectionListener listener) {
        super(parent, 0);
        this.wizard = wizard;
        this.listener = listener;
        this.moduleType = moduleType;
        this.module = module;
        this.serverTypeId = serverTypeId;
        this.includeIncompatible = includeIncompatible;
        this.createControl();
        wizard.setMessage("", 3);
    }

    protected void createControl() {
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        layout.horizontalSpacing = SWTUtil.convertHorizontalDLUsToPixels(this, 4);
        layout.verticalSpacing = SWTUtil.convertVerticalDLUsToPixels(this, 4);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        this.setLayout((Layout)layout);
        this.setFont(this.getParent().getFont());
        IWorkbenchHelpSystem whs = PlatformUI.getWorkbench().getHelpSystem();
        whs.setHelp((Control)this, "org.eclipse.wst.server.ui.swns0000");
        this.serverTypeComposite = new ServerTypeComposite(this, this.moduleType, this.serverTypeId, new ServerTypeComposite.ServerTypeSelectionListener(){

            public void serverTypeSelected(IServerType type2) {
                NewManualServerComposite.this.handleTypeSelection(type2);
            }
        });
        this.serverTypeComposite.setIncludeIncompatibleVersions(this.includeIncompatible);
        GridData data = new GridData(1808);
        data.horizontalSpan = 3;
        this.serverTypeComposite.setLayoutData(data);
        whs.setHelp((Control)this.serverTypeComposite, "org.eclipse.wst.server.ui.swns0006");
        Label serverNameLabel = new Label((Composite)this, 0);
        serverNameLabel.setText(Messages.serverName);
        this.serverName = new Text((Composite)this, 2308);
        data = new GridData(256);
        if ((this.serverName.getStyle() & 0x100) != 0) {
            data.horizontalSpan = 2;
        }
        this.serverName.setLayoutData((Object)data);
        if (this.server != null) {
            this.serverName.setText(this.server.getName());
        }
        this.serverName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (NewManualServerComposite.this.updatingServerName) {
                    return;
                }
                String name = NewManualServerComposite.this.serverName.getText();
                if (NewManualServerComposite.this.server != null) {
                    NewManualServerComposite.this.server.setName(name);
                    IRuntime runtime2 = NewManualServerComposite.this.server.getRuntime();
                    if (runtime2 != null && runtime2 instanceof IRuntimeWorkingCopy) {
                        IRuntimeWorkingCopy rwc = (IRuntimeWorkingCopy)runtime2;
                        rwc.setName(name);
                    }
                }
                if (NewManualServerComposite.this.serverNameModified) {
                    return;
                }
                NewManualServerComposite.this.serverNameModified = true;
                if (NewManualServerComposite.this.serverNameToolBar != null) {
                    NewManualServerComposite.this.serverNameToolBar.getControl().setVisible(true);
                }
            }
        });
        if ((this.serverName.getStyle() & 0x100) == 0) {
            this.serverNameToolBar = new ToolBarManager(0x800100);
            this.serverNameToolBar.createControl((Composite)this);
            Action resetDefaultAction = new Action("", 1){

                public void run() {
                    ((ServerWorkingCopy)NewManualServerComposite.this.server).setDefaults(null);
                    NewManualServerComposite.this.serverName.setText(NewManualServerComposite.this.server.getName());
                    NewManualServerComposite.this.serverNameModified = false;
                    if (NewManualServerComposite.this.serverNameToolBar != null) {
                        NewManualServerComposite.this.serverNameToolBar.getControl().setVisible(false);
                    }
                }
            };
            resetDefaultAction.setToolTipText(Messages.serverNameDefault);
            resetDefaultAction.setImageDescriptor(ImageResource.getImageDescriptor("IMG_ETOOL_RESET_DEFAULT"));
            resetDefaultAction.setDisabledImageDescriptor(ImageResource.getImageDescriptor("IMG_DTOOL_RESET_DEFAULT"));
            this.serverNameToolBar.add((IAction)resetDefaultAction);
            this.serverNameToolBar.update(false);
            this.serverNameToolBar.getControl().setVisible(false);
        }
        this.runtimeLabel = new Label((Composite)this, 0);
        this.runtimeLabel.setText(Messages.wizNewServerRuntime);
        this.runtimeCombo = new Combo((Composite)this, 8);
        this.runtimeCombo.setLayoutData((Object)new GridData(768));
        this.runtimeCombo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    NewManualServerComposite.this.setRuntime(NewManualServerComposite.this.runtimes[NewManualServerComposite.this.runtimeCombo.getSelectionIndex()]);
                }
                catch (Exception exception) {}
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.addRuntime = new Link((Composite)this, 0);
        this.addRuntime.setText("<a>" + Messages.addRuntime + "</a>");
        this.addRuntime.setLayoutData((Object)new GridData(128));
        this.addRuntime.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IServerType serverType = NewManualServerComposite.this.serverTypeComposite.getSelectedServerType();
                NewManualServerComposite.this.showRuntimeWizard(serverType);
            }
        });
        this.configureRuntimes = new Link((Composite)this, 0);
        this.configureRuntimes.setText("<a>" + Messages.configureRuntimes + "</a>");
        data = new GridData(128);
        data.horizontalSpan = 3;
        this.configureRuntimes.setLayoutData((Object)data);
        this.configureRuntimes.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (NewManualServerComposite.this.showPreferencePage()) {
                    NewManualServerComposite.this.runtime = null;
                    IServerType serverType = NewManualServerComposite.this.serverTypeComposite.getSelectedServerType();
                    NewManualServerComposite.this.updateRuntimeCombo(serverType);
                }
            }
        });
        Dialog.applyDialogFont((Control)this);
    }

    protected boolean showPreferencePage() {
        String id = "org.eclipse.wst.server.ui.preferencePage";
        String id2 = "org.eclipse.wst.server.ui.runtime.preferencePage";
        PreferenceDialog dialog = PreferencesUtil.createPreferenceDialogOn((Shell)this.getShell(), (String)id2, (String[])new String[]{id, id2}, null);
        return dialog.open() == 0;
    }

    protected int showRuntimeWizard(IServerType serverType) {
        WizardFragment fragment = null;
        TaskModel taskModel = new TaskModel();
        IRuntimeType runtimeType = serverType.getRuntimeType();
        final WizardFragment fragment2 = ServerUIPlugin.getWizardFragment(runtimeType.getId());
        if (fragment2 == null) {
            return 1;
        }
        try {
            IRuntimeWorkingCopy runtimeWorkingCopy = runtimeType.createRuntime(null, null);
            taskModel.putObject("runtime", (Object)runtimeWorkingCopy);
        }
        catch (CoreException ce) {
            Trace.trace((byte)3, "Error creating runtime", ce);
            return 1;
        }
        fragment = new WizardFragment(){

            @Override
            protected void createChildFragments(List<WizardFragment> list) {
                list.add(fragment2);
                list.add(WizardTaskUtil.SaveRuntimeFragment);
            }
        };
        TaskWizard wizard2 = new TaskWizard(Messages.wizNewRuntimeWizardTitle, fragment, taskModel);
        wizard2.setForcePreviousAndNextButtons(true);
        WizardDialog dialog = new WizardDialog(this.getShell(), (IWizard)wizard2);
        int returnValue = dialog.open();
        if (returnValue != 1) {
            this.updateRuntimeCombo(serverType);
            IRuntime rt = (IRuntime)taskModel.getObject("runtime");
            if (rt != null && rt.getName() != null && this.runtimeCombo.indexOf(rt.getName()) != -1) {
                this.setRuntime(rt);
                this.runtimeCombo.select(this.runtimeCombo.indexOf(rt.getName()));
            }
        }
        return returnValue;
    }

    public void setHost(String host) {
        this.host = host;
        if (this.serverTypeComposite == null) {
            return;
        }
        boolean changed = false;
        changed = host == null ? this.serverTypeComposite.setHost(true) : (SocketUtil.isLocalhost((String)host) ? this.serverTypeComposite.setHost(true) : this.serverTypeComposite.setHost(false));
        if (changed) {
            this.handleTypeSelection(this.serverTypeComposite.getSelectedServerType());
        } else if (this.server != null) {
            this.server.setHost(host);
            if (!this.serverNameModified) {
                this.updatingServerName = true;
                ((ServerWorkingCopy)this.server).setDefaults(null);
                this.serverName.setText(this.server.getName());
                this.updatingServerName = false;
            }
        }
    }

    protected void loadServerImpl(IServerType serverType) {
        this.server = null;
        if (serverType == null) {
            return;
        }
        boolean isLocalhost = SocketUtil.isLocalhost((String)this.host);
        this.server = this.cache.getCachedServer(serverType, isLocalhost);
        if (this.server != null) {
            this.server.setHost(this.host);
            ((ServerWorkingCopy)this.server).setDefaults(null);
            this.runtime = this.server.getRuntime();
            this.listener.runtimeSelected(this.runtime);
            return;
        }
        try {
            IRuntime run = null;
            if (serverType.hasRuntime()) {
                this.runtime = null;
                this.updateRuntimes(serverType, isLocalhost);
                run = this.getDefaultRuntime();
            }
            this.server = this.cache.createServer(serverType, run, isLocalhost, null);
            if (this.server != null) {
                this.server.setHost(this.host);
                if (serverType.hasRuntime() && this.server.getRuntime() == null) {
                    this.runtime = null;
                    this.updateRuntimes(serverType, isLocalhost);
                    this.setRuntime(this.getDefaultRuntime());
                    if (this.server.getServerType() != null && this.server.getServerType().hasServerConfiguration() && !this.runtime.getLocation().isEmpty()) {
                        ((ServerWorkingCopy)this.server).importRuntimeConfiguration(this.runtime, null);
                    }
                }
                ((ServerWorkingCopy)this.server).setDefaults(null);
            }
        }
        catch (CoreException ce) {
            Trace.trace((byte)3, "Error creating server", ce);
            this.server = null;
            this.runtime = null;
            this.wizard.setMessage(ce.getLocalizedMessage(), 3);
        }
        if (this.server == null) {
            this.wizard.setMessage(Messages.wizErrorServerCreationError, 3);
        }
    }

    protected IRuntime getDefaultRuntime() {
        if (this.runtimes == null || this.runtimes.length == 0) {
            return null;
        }
        if (this.runtimes != null) {
            int size = this.runtimes.length;
            int i = 0;
            while (i < size) {
                if (!this.runtimes[i].isStub()) {
                    return this.runtimes[i];
                }
                ++i;
            }
        }
        return this.runtimes[0];
    }

    protected void updateRuntimes(IServerType serverType, boolean isLocalhost) {
        if (serverType == null) {
            return;
        }
        IRuntimeType runtimeType = serverType.getRuntimeType();
        this.runtimes = ServerUIPlugin.getRuntimes(runtimeType);
        this.newRuntime = null;
        if (this.runtimes != null) {
            ArrayList<IRuntime> runtimes2 = new ArrayList<IRuntime>();
            int size = this.runtimes.length;
            int i = 0;
            while (i < size) {
                IRuntime runtime2 = this.runtimes[i];
                if (isLocalhost || !runtime2.isStub()) {
                    runtimes2.add(runtime2);
                }
                ++i;
            }
            this.runtimes = new IRuntime[runtimes2.size()];
            runtimes2.toArray(this.runtimes);
            if (this.runtimes.length > 0) {
                return;
            }
        }
        try {
            IRuntimeWorkingCopy runtimeWC = runtimeType.createRuntime(null, null);
            this.runtimes = new IRuntime[1];
            this.runtimes[0] = runtimeWC;
            this.newRuntime = runtimeWC;
        }
        catch (Exception e) {
            Trace.trace((byte)3, "Couldn't create runtime", e);
        }
    }

    protected void updateRuntimeCombo(IServerType serverType) {
        if (serverType == null || !serverType.hasRuntime() || this.server == null) {
            if (this.runtimeLabel != null) {
                this.runtimeLabel.setEnabled(false);
                this.runtimeCombo.setItems(new String[0]);
                this.runtimeCombo.setEnabled(false);
                this.runtimeLabel.setVisible(false);
                this.runtimeCombo.setVisible(false);
                this.configureRuntimes.setEnabled(false);
                this.configureRuntimes.setVisible(false);
                this.addRuntime.setEnabled(false);
                this.addRuntime.setVisible(false);
            }
            this.runtimes = new IRuntime[0];
            this.setRuntime(null);
            return;
        }
        this.updateRuntimes(serverType, !SocketUtil.isLocalhost((String)this.server.getHost()));
        int size = this.runtimes.length;
        String[] items = new String[size];
        int i = 0;
        while (i < size) {
            items[i] = this.runtimes[i].equals(this.newRuntime) ? Messages.wizNewServerRuntimeCreate : this.runtimes[i].getName();
            ++i;
        }
        if (this.runtime == null) {
            this.setRuntime(this.getDefaultRuntime());
        }
        if (this.runtimeCombo != null) {
            IRuntimeType runtimeType;
            this.runtimeCombo.setItems(items);
            if (this.runtimes.length > 0) {
                int sel = -1;
                int i2 = 0;
                while (i2 < size) {
                    if (this.runtimes[i2].equals(this.runtime)) {
                        sel = i2;
                    }
                    ++i2;
                }
                if (sel < 0) {
                    sel = 0;
                }
                this.runtimeCombo.select(sel);
                this.setRuntime(this.runtimes[0]);
            }
            boolean showRuntime = ServerUIPlugin.getRuntimes(runtimeType = serverType.getRuntimeType()).length >= 1;
            this.runtimeCombo.setEnabled(showRuntime);
            this.runtimeLabel.setEnabled(showRuntime);
            this.configureRuntimes.setEnabled(showRuntime);
            this.addRuntime.setEnabled(showRuntime);
            this.runtimeLabel.setVisible(showRuntime);
            this.runtimeCombo.setVisible(showRuntime);
            this.configureRuntimes.setVisible(showRuntime);
            this.addRuntime.setVisible(showRuntime);
        }
    }

    protected void setRuntime(IRuntime runtime2) {
        this.runtime = runtime2;
        if (this.server != null) {
            this.server.setRuntime(this.runtime);
            ((ServerWorkingCopy)this.server).setDefaults(null);
            if (!this.serverNameModified) {
                this.updatingServerName = true;
                this.serverName.setText(this.server.getName());
                this.updatingServerName = false;
            }
        }
        this.listener.runtimeSelected(this.runtime);
    }

    protected void handleTypeSelection(IServerType serverType) {
        IRuntimeType runtimeType;
        boolean wrong = false;
        if (serverType != null && this.moduleType != null && !ServerUtil.isSupportedModule((IModuleType[])(runtimeType = serverType.getRuntimeType()).getModuleTypes(), (IModuleType)this.moduleType)) {
            serverType = null;
            wrong = true;
        }
        if (wrong) {
            this.server = null;
            this.runtime = null;
            this.wizard.setMessage(NLS.bind((String)Messages.errorVersionLevel, (Object[])new Object[]{this.moduleType.getName(), this.moduleType.getVersion()}), 3);
        } else if (serverType == null) {
            this.server = null;
            this.runtime = null;
            this.wizard.setMessage("", 3);
        } else {
            IStatus status;
            this.wizard.setMessage(null, 0);
            this.loadServerImpl(serverType);
            if (this.server != null && this.module != null && (status = NewServerComposite.isSupportedModule((IServerAttributes)this.server, this.module)) != null) {
                if (status.getSeverity() == 4) {
                    this.wizard.setMessage(status.getMessage(), 3);
                } else if (status.getSeverity() == 2) {
                    this.wizard.setMessage(status.getMessage(), 2);
                } else if (status.getSeverity() == 1) {
                    this.wizard.setMessage(status.getMessage(), 1);
                }
                this.server = null;
            }
        }
        if (this.serverName != null && !this.serverNameModified) {
            this.updatingServerName = true;
            if (this.server == null) {
                this.serverName.setText("");
            } else {
                this.serverName.setText(this.server.getName());
            }
            this.updatingServerName = false;
        }
        this.updateRuntimeCombo(serverType);
        if (this.serverName != null) {
            if (this.server == null) {
                this.serverName.setEditable(false);
                this.serverNameToolBar.getControl().setVisible(false);
            } else {
                this.serverName.setEditable(true);
                this.serverNameToolBar.getControl().setVisible(this.serverNameModified);
            }
        }
        this.listener.serverSelected((IServerAttributes)this.server);
        this.wizard.update();
    }

    public void setVisible(boolean visible) {
        Control[] c;
        super.setVisible(visible);
        if (visible) {
            this.handleTypeSelection(null);
        }
        if ((c = this.getChildren()) != null) {
            int size = c.length;
            int i = 0;
            while (i < size) {
                if (c[i] != null && c[i] instanceof ServerTypeComposite) {
                    c[i].setVisible(visible);
                }
                ++i;
            }
        }
        if (visible) {
            this.handleTypeSelection(this.serverTypeComposite.getSelectedServerType());
        }
    }

    public void refresh() {
        this.serverTypeComposite.refresh();
    }

    public IRuntime getRuntime() {
        return this.runtime;
    }

    public IServerWorkingCopy getServer() {
        return this.server;
    }

    public static interface IWizardHandle2 {
        public void run(boolean var1, boolean var2, IRunnableWithProgress var3) throws InterruptedException, InvocationTargetException;

        public void update();

        public void setMessage(String var1, int var2);
    }

    public static interface ServerSelectionListener {
        public void serverSelected(IServerAttributes var1);

        public void runtimeSelected(IRuntime var1);
    }
}

