/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.server.ui.internal.cnf;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.wst.server.ui.internal.ImageResource;
import org.eclipse.wst.server.ui.internal.Messages;
import org.eclipse.wst.server.ui.internal.provisional.UIDecorator;

public class CNFManagedUIDecorator
extends UIDecorator {
    private static final String[] serverStateUnmanaged = new String[]{"", Messages.viewStatusStarting4, Messages.viewStatusStarted2, Messages.viewStatusStopping4, Messages.viewStatusStopped2};
    private static final Image[] startingImages = new Image[]{ImageResource.getImage("stateStarting1"), ImageResource.getImage("stateStarting2"), ImageResource.getImage("stateStarting3")};
    private static final ImageDescriptor[] startingImagesDescriptor = new ImageDescriptor[]{ImageResource.getImageDescriptor("stateStarting1"), ImageResource.getImageDescriptor("stateStarting2"), ImageResource.getImageDescriptor("stateStarting3")};
    private static final Image[] stoppingImages = new Image[]{ImageResource.getImage("stateStopping1"), ImageResource.getImage("stateStopping2"), ImageResource.getImage("stateStopping2")};
    private static final ImageDescriptor[] stoppingImagesDescriptor = new ImageDescriptor[]{ImageResource.getImageDescriptor("stateStopping1"), ImageResource.getImageDescriptor("stateStopping2"), ImageResource.getImageDescriptor("stateStopping3")};

    public String getStateLabel(int state, String mode, int count) {
        if (state == 0) {
            return "";
        }
        if (state == 1) {
            return Messages.viewStatusStarting;
        }
        if (state == 3) {
            return Messages.viewStatusStopping;
        }
        if (state == 2) {
            if ("debug".equals(mode)) {
                return Messages.viewStatusStartedDebug;
            }
            if ("profile".equals(mode)) {
                return Messages.viewStatusStartedProfile;
            }
            return Messages.viewStatusStarted;
        }
        if (state == 4) {
            return Messages.viewStatusStopped;
        }
        return serverStateUnmanaged[state];
    }

    public Image getStateImage(int state, String mode, int count) {
        if (state == 0) {
            return null;
        }
        if (state == 1) {
            return startingImages[count];
        }
        if (state == 3) {
            return stoppingImages[count];
        }
        if (state == 4) {
            return ImageResource.getImage("stateStopped");
        }
        if ("debug".equals(mode)) {
            return ImageResource.getImage("stateStartedDebug");
        }
        if ("profile".equals(mode)) {
            return ImageResource.getImage("stateStartedProfile");
        }
        return ImageResource.getImage("stateStarted");
    }

    public ImageDescriptor getStateImageDescriptor(int state, String mode, int count) {
        if (state == 0) {
            return null;
        }
        if (state == 1) {
            return startingImagesDescriptor[count];
        }
        if (state == 3) {
            return stoppingImagesDescriptor[count];
        }
        if (state == 4) {
            return ImageResource.getImageDescriptor("stateStopped");
        }
        if ("debug".equals(mode)) {
            return ImageResource.getImageDescriptor("stateStartedDebug");
        }
        if ("profile".equals(mode)) {
            return ImageResource.getImageDescriptor("stateStartedProfile");
        }
        return ImageResource.getImageDescriptor("stateStarted");
    }

    public String getModuleName() {
        return "module";
    }

    public boolean canRestart() {
        return true;
    }
}

