/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.ui.internal.wizards.gen;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jpt.core.EntityGeneratorDatabaseAnnotationNameBuilder;
import org.eclipse.jpt.core.JpaPlatform;
import org.eclipse.jpt.core.JpaProject;
import org.eclipse.jpt.core.JptCorePlugin;
import org.eclipse.jpt.core.context.persistence.PersistenceXml;
import org.eclipse.jpt.core.internal.synch.SynchronizeClassesJob;
import org.eclipse.jpt.db.Column;
import org.eclipse.jpt.db.ConnectionProfile;
import org.eclipse.jpt.db.ForeignKey;
import org.eclipse.jpt.db.Schema;
import org.eclipse.jpt.db.Table;
import org.eclipse.jpt.gen.internal2.BaseEntityGenCustomizer;
import org.eclipse.jpt.gen.internal2.DatabaseAnnotationNameBuilder;
import org.eclipse.jpt.gen.internal2.ORMGenCustomizer;
import org.eclipse.jpt.gen.internal2.PackageGenerator2;
import org.eclipse.jpt.ui.JptUiPlugin;
import org.eclipse.jpt.ui.internal.JptUiMessages;
import org.eclipse.jpt.ui.internal.wizards.gen.DefaultTableGenerationWizardPage;
import org.eclipse.jpt.ui.internal.wizards.gen.JptUiEntityGenMessages;
import org.eclipse.jpt.ui.internal.wizards.gen.PromptJPAProjectWizardPage;
import org.eclipse.jpt.ui.internal.wizards.gen.TableAssociationsWizardPage;
import org.eclipse.jpt.ui.internal.wizards.gen.TablesAndColumnsCustomizationWizardPage;
import org.eclipse.jpt.ui.internal.wizards.gen.TablesSelectorWizardPage;
import org.eclipse.jpt.utility.internal.CollectionTools;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenerateEntitiesFromSchemaWizard
extends Wizard
implements INewWizard {
    public static final String HELP_CONTEXT_ID = "org.eclipse.jpt.ui.GenerateEntitiesFromSchemaWizard";
    private static final String DONT_SHOW_OVERWRITE_WARNING_DIALOG = "DONT_SHOW_OVERWRITE_WARNING_DIALOG";
    private JpaProject jpaProject;
    private IStructuredSelection selection;
    private ORMGenCustomizer customizer = null;
    private boolean synchronizePersistenceXml;
    private PromptJPAProjectWizardPage projectPage;
    private TablesSelectorWizardPage tablesSelectorPage;
    private TableAssociationsWizardPage tableAssociationsPage;
    private DefaultTableGenerationWizardPage defaultTableGenerationPage;
    private TablesAndColumnsCustomizationWizardPage tablesAndColumnsCustomizationPage;

    public GenerateEntitiesFromSchemaWizard() {
        this.setWindowTitle(JptUiEntityGenMessages.GenerateEntitiesWizard_generateEntities);
    }

    public GenerateEntitiesFromSchemaWizard(JpaProject jpaProject, IStructuredSelection selection) {
        this.jpaProject = jpaProject;
        this.selection = selection;
        this.setWindowTitle(JptUiEntityGenMessages.GenerateEntitiesWizard_generateEntities);
    }

    public Image getDefaultPageImage() {
        return JptUiPlugin.getImage("full/wizban/new_entity_wizban");
    }

    public void addPages() {
        super.addPages();
        this.setForcePreviousAndNextButtons(true);
        if (this.jpaProject == null) {
            this.projectPage = new PromptJPAProjectWizardPage(HELP_CONTEXT_ID);
            this.addPage((IWizardPage)this.projectPage);
            return;
        }
        this.addMainPages();
    }

    private void addMainPages() {
        this.tablesSelectorPage = new TablesSelectorWizardPage(this.jpaProject);
        this.addPage((IWizardPage)this.tablesSelectorPage);
        this.tableAssociationsPage = new TableAssociationsWizardPage(this.jpaProject);
        this.addPage((IWizardPage)this.tableAssociationsPage);
        this.defaultTableGenerationPage = new DefaultTableGenerationWizardPage(this.jpaProject);
        this.addPage((IWizardPage)this.defaultTableGenerationPage);
        this.defaultTableGenerationPage.init(this.selection);
        this.tablesAndColumnsCustomizationPage = new TablesAndColumnsCustomizationWizardPage(this.jpaProject);
        this.addPage((IWizardPage)this.tablesAndColumnsCustomizationPage);
        this.tablesAndColumnsCustomizationPage.init(this.selection);
    }

    public ORMGenCustomizer getORMGenCustomizer() {
        return this.customizer;
    }

    public ORMGenCustomizer createORMGenCustomizer(Schema schema) {
        JpaPlatform jpaPlatform = this.jpaProject.getJpaPlatform();
        Object obj = Platform.getAdapterManager().getAdapter((Object)jpaPlatform, ORMGenCustomizer.class);
        if (obj != null && obj instanceof ORMGenCustomizer) {
            this.customizer = (ORMGenCustomizer)obj;
            this.customizer.init(this.getCustomizationFile(), schema);
        } else {
            this.customizer = new BaseEntityGenCustomizer();
            this.customizer.init(this.getCustomizationFile(), schema);
        }
        return this.customizer;
    }

    protected String getCustomizationFileName() {
        ConnectionProfile profile = this.getProjectConnectionProfile();
        String connection = profile == null ? "" : profile.getName();
        String name = "org.eclipse.jpt.entitygen." + (connection == null ? "" : connection.replace(' ', '-'));
        Schema schema = this.getDefaultSchema();
        if (schema != null) {
            name = String.valueOf(name) + "." + schema.getName();
        }
        return name.toLowerCase();
    }

    private File getCustomizationFile() {
        String projectPath = this.jpaProject.getProject().getLocation().toPortableString();
        File genDir = new File(String.valueOf(projectPath) + "/.settings");
        genDir.mkdirs();
        return new File(genDir, this.getCustomizationFileName());
    }

    public boolean performFinish() {
        PersistenceXml persistenceXml;
        if (this.jpaProject == null) {
            return true;
        }
        try {
            this.customizer.setDatabaseAnnotationNameBuilder(this.buildDatabaseAnnotationNameBuilder());
            this.customizer.save();
        }
        catch (IOException e) {
            JptUiPlugin.log(e);
        }
        this.synchronizePersistenceXml = this.tablesSelectorPage.synchronizePersistenceXml();
        if (GenerateEntitiesFromSchemaWizard.shouldShowOverwriteWarning()) {
            PackageGenerator2.setOverwriteConfirmer((org.eclipse.jpt.gen.internal2.OverwriteConfirmer)new OverwriteConfirmer());
        }
        GenerateEntitiesJob genEntitiesJob = new GenerateEntitiesJob(this.jpaProject, this.getCustomizer());
        SynchronizeClassesJob synchClassesJob = null;
        if (this.synchronizePersistenceXml() && (persistenceXml = this.jpaProject.getRootContextNode().getPersistenceXml()) != null) {
            synchClassesJob = new SynchronizeClassesJob((IFile)persistenceXml.getResource());
        }
        genEntitiesJob.schedule();
        if (synchClassesJob != null) {
            synchClassesJob.schedule();
        }
        return true;
    }

    public static boolean shouldShowOverwriteWarning() {
        IEclipsePreferences pref = new InstanceScope().getNode("org.eclipse.jpt.ui");
        boolean ret = !pref.getBoolean(DONT_SHOW_OVERWRITE_WARNING_DIALOG, false);
        return ret;
    }

    private DatabaseAnnotationNameBuilder buildDatabaseAnnotationNameBuilder() {
        return new LocalDatabaseAnnotationNameBuilder(this.jpaProject.getJpaPlatform().getEntityGeneratorDatabaseAnnotationNameBuilder());
    }

    public IWizardPage getStartingPage() {
        if (this.projectPage != null) {
            if (this.tablesSelectorPage != null) {
                return this.tablesSelectorPage;
            }
            return this.projectPage;
        }
        return super.getStartingPage();
    }

    public ORMGenCustomizer getCustomizer() {
        return this.customizer;
    }

    Collection<Table> getPossibleTables() {
        ArrayList<Table> tables = new ArrayList();
        if (this.tablesSelectorPage != null) {
            tables = this.tablesSelectorPage.getTables();
        }
        tables = this.projectDefaultSchemaExists() ? CollectionTools.collection((Iterator)this.getDefaultSchema().tables()) : Collections.emptyList();
        return this.filterEmptyTables(tables);
    }

    private Collection<Table> filterEmptyTables(Collection<Table> tables) {
        ArrayList<Table> nonEmptyTables = new ArrayList<Table>();
        for (Table candidateTable : tables) {
            if (candidateTable.columnsSize() <= 0) continue;
            nonEmptyTables.add(candidateTable);
        }
        return nonEmptyTables;
    }

    public ConnectionProfile getProjectConnectionProfile() {
        return this.jpaProject.getConnectionProfile();
    }

    public JpaProject getJpaProject() {
        return this.jpaProject;
    }

    public void setJpaProject(JpaProject jpaProject) {
        if (this.jpaProject == null) {
            this.jpaProject = jpaProject;
            IWizardPage currentPage = this.getContainer().getCurrentPage();
            if (this.projectPage != null && currentPage.equals((Object)this.projectPage)) {
                this.addMainPages();
            }
        }
    }

    public Schema getDefaultSchema() {
        return this.getJpaProject().getDefaultDbSchema();
    }

    private boolean projectDefaultSchemaExists() {
        return this.getDefaultSchema() != null;
    }

    public boolean synchronizePersistenceXml() {
        return this.synchronizePersistenceXml;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        Object sel = selection.getFirstElement();
        if (sel instanceof IResource) {
            JpaProject jpaProj;
            IProject proj = ((IResource)sel).getProject();
            this.jpaProject = jpaProj = JptCorePlugin.getJpaProject((IProject)proj);
        } else if (sel instanceof IPackageFragmentRoot) {
            JpaProject jpaProj;
            IPackageFragmentRoot root = (IPackageFragmentRoot)sel;
            IProject proj = root.getJavaProject().getProject();
            this.jpaProject = jpaProj = JptCorePlugin.getJpaProject((IProject)proj);
        } else if (sel instanceof IPackageFragment) {
            JpaProject jpaProj;
            IPackageFragment frag = (IPackageFragment)sel;
            IProject proj = frag.getJavaProject().getProject();
            this.jpaProject = jpaProj = JptCorePlugin.getJpaProject((IProject)proj);
        }
        this.selection = selection;
        this.setWindowTitle(JptUiEntityGenMessages.GenerateEntitiesWizard_generateEntities);
    }

    static class GenerateEntitiesJob
    extends WorkspaceJob {
        JpaProject jpaProject;
        ORMGenCustomizer customizer;

        GenerateEntitiesJob(JpaProject jpaProject, ORMGenCustomizer customizer) {
            super(JptUiMessages.EntitiesGenerator_jobName);
            this.customizer = customizer;
            this.jpaProject = jpaProject;
            this.setRule((ISchedulingRule)jpaProject.getProject());
        }

        public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
            try {
                PackageGenerator2.generate((IJavaProject)this.jpaProject.getJavaProject(), (ORMGenCustomizer)this.customizer, (IProgressMonitor)monitor);
            }
            catch (OperationCanceledException operationCanceledException) {}
            return Status.OK_STATUS;
        }
    }

    static class LocalDatabaseAnnotationNameBuilder
    implements DatabaseAnnotationNameBuilder {
        private EntityGeneratorDatabaseAnnotationNameBuilder builder;

        LocalDatabaseAnnotationNameBuilder(EntityGeneratorDatabaseAnnotationNameBuilder builder) {
            this.builder = builder;
        }

        public String buildTableAnnotationName(String entityName, Table table) {
            return this.builder.buildTableAnnotationName(entityName, table);
        }

        public String buildColumnAnnotationName(String attributeName, Column column) {
            return this.builder.buildColumnAnnotationName(attributeName, column);
        }

        public String buildJoinColumnAnnotationName(String attributeName, ForeignKey foreignKey) {
            return this.builder.buildJoinColumnAnnotationName(attributeName, foreignKey);
        }

        public String buildJoinColumnAnnotationName(Column column) {
            return this.builder.buildJoinColumnAnnotationName(column);
        }

        public String buildJoinTableAnnotationName(Table table) {
            return this.builder.buildJoinTableAnnotationName(table);
        }
    }

    static class OverwriteConfirmer
    implements org.eclipse.jpt.gen.internal2.OverwriteConfirmer {
        private boolean overwriteAll = false;
        private boolean skipAll = false;

        OverwriteConfirmer() {
        }

        public boolean overwrite(String className) {
            if (this.overwriteAll) {
                return true;
            }
            if (this.skipAll) {
                return false;
            }
            return this.promptUser(className);
        }

        private boolean promptUser(final String className) {
            final boolean[] ret = new boolean[1];
            Display.getDefault().syncExec(new Runnable(){

                public void run() {
                    OverwriteConfirmerDialog dialog = new OverwriteConfirmerDialog(Display.getCurrent().getActiveShell(), className);
                    dialog.open();
                    if (dialog.getReturnCode() == 1) {
                        OverwriteConfirmer.this.skipAll = true;
                        ret[0] = false;
                        return;
                    }
                    if (dialog.yes()) {
                        ret[0] = true;
                    }
                    if (dialog.yesToAll()) {
                        OverwriteConfirmer.this.overwriteAll = true;
                        ret[0] = true;
                    }
                    if (dialog.no()) {
                        ret[0] = false;
                    }
                    if (dialog.noToAll()) {
                        OverwriteConfirmer.this.skipAll = true;
                        ret[0] = false;
                    }
                }
            });
            return ret[0];
        }
    }

    static class OverwriteConfirmerDialog
    extends Dialog {
        private final String className;
        private boolean yes = false;
        private boolean yesToAll = false;
        private boolean no = false;
        private boolean noToAll = false;

        OverwriteConfirmerDialog(Shell parent, String className) {
            super(parent);
            this.className = className;
        }

        protected void configureShell(Shell shell) {
            super.configureShell(shell);
            shell.setText(JptUiMessages.OverwriteConfirmerDialog_title);
        }

        protected Control createDialogArea(Composite parent) {
            Composite composite = (Composite)super.createDialogArea(parent);
            GridLayout gridLayout = (GridLayout)composite.getLayout();
            gridLayout.numColumns = 1;
            Label text = new Label(composite, 16384);
            text.setText(NLS.bind((String)JptUiMessages.OverwriteConfirmerDialog_text, (Object)this.className));
            text.setLayoutData((Object)new GridData());
            this.createDontShowControl(composite);
            return composite;
        }

        protected Control createDontShowControl(Composite composite) {
            final Button checkbox = new Button(composite, 32);
            checkbox.setText(JptUiEntityGenMessages.GenerateEntitiesWizard_doNotShowWarning);
            checkbox.setSelection(false);
            final IEclipsePreferences pref = new InstanceScope().getNode("org.eclipse.jpt.ui");
            checkbox.setLayoutData((Object)new GridData(1808));
            checkbox.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent e) {
                }

                public void widgetSelected(SelectionEvent e) {
                    boolean b = checkbox.getSelection();
                    pref.putBoolean(GenerateEntitiesFromSchemaWizard.DONT_SHOW_OVERWRITE_WARNING_DIALOG, b);
                }
            });
            return checkbox;
        }

        protected void createButtonsForButtonBar(Composite parent) {
            this.createButton(parent, 2, IDialogConstants.YES_LABEL, false);
            this.createButton(parent, 4, IDialogConstants.YES_TO_ALL_LABEL, false);
            this.createButton(parent, 3, IDialogConstants.NO_LABEL, true);
            this.createButton(parent, 21, IDialogConstants.NO_TO_ALL_LABEL, false);
            this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
        }

        protected void buttonPressed(int buttonId) {
            switch (buttonId) {
                case 2: {
                    this.yesPressed();
                    break;
                }
                case 4: {
                    this.yesToAllPressed();
                    break;
                }
                case 3: {
                    this.noPressed();
                    break;
                }
                case 21: {
                    this.noToAllPressed();
                    break;
                }
                case 1: {
                    this.cancelPressed();
                    break;
                }
            }
        }

        private void yesPressed() {
            this.yes = true;
            this.setReturnCode(0);
            this.close();
        }

        private void yesToAllPressed() {
            this.yesToAll = true;
            this.setReturnCode(0);
            this.close();
        }

        private void noPressed() {
            this.no = true;
            this.setReturnCode(0);
            this.close();
        }

        private void noToAllPressed() {
            this.noToAll = true;
            this.setReturnCode(0);
            this.close();
        }

        boolean yes() {
            return this.yes;
        }

        boolean yesToAll() {
            return this.yesToAll;
        }

        boolean no() {
            return this.no;
        }

        boolean noToAll() {
            return this.noToAll;
        }
    }
}

