/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.resource.java.source;

import java.util.ListIterator;
import java.util.Vector;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.core.internal.resource.java.source.AnnotationContainerTools;
import org.eclipse.jpt.core.internal.resource.java.source.SourceBaseTableAnnotation;
import org.eclipse.jpt.core.internal.resource.java.source.SourcePrimaryKeyJoinColumnAnnotation;
import org.eclipse.jpt.core.internal.resource.java.source.SourceUniqueConstraintAnnotation;
import org.eclipse.jpt.core.internal.utility.jdt.ConversionDeclarationAnnotationElementAdapter;
import org.eclipse.jpt.core.internal.utility.jdt.MemberAnnotationAdapter;
import org.eclipse.jpt.core.internal.utility.jdt.MemberIndexedAnnotationAdapter;
import org.eclipse.jpt.core.internal.utility.jdt.NestedIndexedDeclarationAnnotationAdapter;
import org.eclipse.jpt.core.internal.utility.jdt.SimpleDeclarationAnnotationAdapter;
import org.eclipse.jpt.core.resource.java.AnnotationContainer;
import org.eclipse.jpt.core.resource.java.JavaResourceNode;
import org.eclipse.jpt.core.resource.java.NestableAnnotation;
import org.eclipse.jpt.core.resource.java.NestablePrimaryKeyJoinColumnAnnotation;
import org.eclipse.jpt.core.resource.java.NestableSecondaryTableAnnotation;
import org.eclipse.jpt.core.resource.java.NestableUniqueConstraintAnnotation;
import org.eclipse.jpt.core.resource.java.PrimaryKeyJoinColumnAnnotation;
import org.eclipse.jpt.core.resource.java.SecondaryTableAnnotation;
import org.eclipse.jpt.core.resource.java.UniqueConstraintAnnotation;
import org.eclipse.jpt.core.utility.jdt.AnnotationAdapter;
import org.eclipse.jpt.core.utility.jdt.DeclarationAnnotationAdapter;
import org.eclipse.jpt.core.utility.jdt.DeclarationAnnotationElementAdapter;
import org.eclipse.jpt.core.utility.jdt.IndexedAnnotationAdapter;
import org.eclipse.jpt.core.utility.jdt.IndexedDeclarationAnnotationAdapter;
import org.eclipse.jpt.core.utility.jdt.Member;
import org.eclipse.jpt.utility.internal.CollectionTools;
import org.eclipse.jpt.utility.internal.StringTools;
import org.eclipse.jpt.utility.internal.iterators.CloneListIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SourceSecondaryTableAnnotation
extends SourceBaseTableAnnotation
implements NestableSecondaryTableAnnotation {
    private static final DeclarationAnnotationAdapter DECLARATION_ANNOTATION_ADAPTER = new SimpleDeclarationAnnotationAdapter("javax.persistence.SecondaryTable");
    private final Vector<NestablePrimaryKeyJoinColumnAnnotation> pkJoinColumns = new Vector();
    private final PkJoinColumnsAnnotationContainer pkJoinColumnsContainer = new PkJoinColumnsAnnotationContainer();

    public SourceSecondaryTableAnnotation(JavaResourceNode parent, Member member, DeclarationAnnotationAdapter daa, AnnotationAdapter annotationAdapter) {
        super(parent, member, daa, annotationAdapter);
    }

    @Override
    public String getAnnotationName() {
        return "javax.persistence.SecondaryTable";
    }

    @Override
    public void initialize(CompilationUnit astRoot) {
        super.initialize(astRoot);
        AnnotationContainerTools.initialize(this.pkJoinColumnsContainer, astRoot);
    }

    @Override
    public void update(CompilationUnit astRoot) {
        super.update(astRoot);
        AnnotationContainerTools.update(this.pkJoinColumnsContainer, astRoot);
    }

    @Override
    DeclarationAnnotationElementAdapter<String> getNameAdapter(DeclarationAnnotationAdapter declarationAnnotationAdapter) {
        return ConversionDeclarationAnnotationElementAdapter.forStrings(declarationAnnotationAdapter, "name");
    }

    @Override
    DeclarationAnnotationElementAdapter<String> getSchemaAdapter(DeclarationAnnotationAdapter declarationAnnotationAdapter) {
        return ConversionDeclarationAnnotationElementAdapter.forStrings(declarationAnnotationAdapter, "schema");
    }

    @Override
    DeclarationAnnotationElementAdapter<String> getCatalogAdapter(DeclarationAnnotationAdapter declarationAnnotationAdapter) {
        return ConversionDeclarationAnnotationElementAdapter.forStrings(declarationAnnotationAdapter, "catalog");
    }

    @Override
    String getUniqueConstraintsElementName() {
        return "uniqueConstraints";
    }

    @Override
    NestableUniqueConstraintAnnotation buildUniqueConstraint(int index) {
        return SourceUniqueConstraintAnnotation.createSecondaryTableUniqueConstraint(this, this.member, this.daa, index);
    }

    @Override
    public ListIterator<PrimaryKeyJoinColumnAnnotation> pkJoinColumns() {
        return new CloneListIterator(this.pkJoinColumns);
    }

    ListIterator<NestablePrimaryKeyJoinColumnAnnotation> nestablePkJoinColumns() {
        return new CloneListIterator(this.pkJoinColumns);
    }

    @Override
    public int pkJoinColumnsSize() {
        return this.pkJoinColumns.size();
    }

    @Override
    public NestablePrimaryKeyJoinColumnAnnotation pkJoinColumnAt(int index) {
        return this.pkJoinColumns.get(index);
    }

    @Override
    public int indexOfPkJoinColumn(PrimaryKeyJoinColumnAnnotation joinColumn) {
        return this.pkJoinColumns.indexOf(joinColumn);
    }

    @Override
    public NestablePrimaryKeyJoinColumnAnnotation addPkJoinColumn(int index) {
        return (NestablePrimaryKeyJoinColumnAnnotation)AnnotationContainerTools.addNestedAnnotation(index, this.pkJoinColumnsContainer);
    }

    NestablePrimaryKeyJoinColumnAnnotation addPkJoinColumnInternal() {
        NestablePrimaryKeyJoinColumnAnnotation pkJoinColumn = this.buildPrimaryKeyJoinColumn(this.pkJoinColumns.size());
        this.pkJoinColumns.add(pkJoinColumn);
        return pkJoinColumn;
    }

    private NestablePrimaryKeyJoinColumnAnnotation buildPrimaryKeyJoinColumn(int index) {
        return SourcePrimaryKeyJoinColumnAnnotation.createSecondaryTablePrimaryKeyJoinColumn(this.daa, this, this.member, index);
    }

    void pkJoinColumnAdded(int index, NestablePrimaryKeyJoinColumnAnnotation joinColumn) {
        this.fireItemAdded("pkJoinColumns", index, joinColumn);
    }

    @Override
    public void movePkJoinColumn(int targetIndex, int sourceIndex) {
        AnnotationContainerTools.moveNestedAnnotation(targetIndex, sourceIndex, this.pkJoinColumnsContainer);
    }

    NestablePrimaryKeyJoinColumnAnnotation movePkJoinColumnInternal(int targetIndex, int sourceIndex) {
        return (NestablePrimaryKeyJoinColumnAnnotation)CollectionTools.move(this.pkJoinColumns, (int)targetIndex, (int)sourceIndex).get(targetIndex);
    }

    void pkJoinColumnMoved(int targetIndex, int sourceIndex) {
        this.fireItemMoved("pkJoinColumns", targetIndex, sourceIndex);
    }

    @Override
    public void removePkJoinColumn(int index) {
        AnnotationContainerTools.removeNestedAnnotation(index, this.pkJoinColumnsContainer);
    }

    NestablePrimaryKeyJoinColumnAnnotation removePkJoinColumnInternal(int index) {
        return this.pkJoinColumns.remove(index);
    }

    void pkJoinColumnRemoved(int index, NestablePrimaryKeyJoinColumnAnnotation joinColumn) {
        this.fireItemRemoved("pkJoinColumns", index, joinColumn);
    }

    @Override
    public void moveAnnotation(int newIndex) {
        this.getIndexedAnnotationAdapter().moveAnnotation(newIndex);
    }

    protected IndexedAnnotationAdapter getIndexedAnnotationAdapter() {
        return (IndexedAnnotationAdapter)this.annotationAdapter;
    }

    @Override
    public void initializeFrom(NestableAnnotation oldAnnotation) {
        SecondaryTableAnnotation oldTable = (SecondaryTableAnnotation)((Object)oldAnnotation);
        this.setName(oldTable.getName());
        this.setSchema(oldTable.getSchema());
        this.setCatalog(oldTable.getCatalog());
        for (UniqueConstraintAnnotation oldUniqueConstraint : CollectionTools.iterable(oldTable.uniqueConstraints())) {
            NestableUniqueConstraintAnnotation newUniqueConstraint = this.addUniqueConstraint(oldTable.indexOfUniqueConstraint(oldUniqueConstraint));
            newUniqueConstraint.initializeFrom((NestableAnnotation)((Object)oldUniqueConstraint));
        }
        for (PrimaryKeyJoinColumnAnnotation oldPkJoinColumn : CollectionTools.iterable(oldTable.pkJoinColumns())) {
            NestablePrimaryKeyJoinColumnAnnotation newPkJoinColumn = this.addPkJoinColumn(oldTable.indexOfPkJoinColumn(oldPkJoinColumn));
            newPkJoinColumn.initializeFrom((NestableAnnotation)((Object)oldPkJoinColumn));
        }
    }

    public static SourceSecondaryTableAnnotation createSecondaryTable(JavaResourceNode parent, Member member) {
        return new SourceSecondaryTableAnnotation(parent, member, DECLARATION_ANNOTATION_ADAPTER, (AnnotationAdapter)new MemberAnnotationAdapter(member, DECLARATION_ANNOTATION_ADAPTER));
    }

    static SourceSecondaryTableAnnotation createNestedSecondaryTable(JavaResourceNode parent, Member member, int index, DeclarationAnnotationAdapter secondaryTablesAdapter) {
        IndexedDeclarationAnnotationAdapter idaa = SourceSecondaryTableAnnotation.buildNestedDeclarationAnnotationAdapter(index, secondaryTablesAdapter);
        MemberIndexedAnnotationAdapter annotationAdapter = new MemberIndexedAnnotationAdapter(member, idaa);
        return new SourceSecondaryTableAnnotation(parent, member, (DeclarationAnnotationAdapter)idaa, (AnnotationAdapter)annotationAdapter);
    }

    private static IndexedDeclarationAnnotationAdapter buildNestedDeclarationAnnotationAdapter(int index, DeclarationAnnotationAdapter secondaryTablesAdapter) {
        return new NestedIndexedDeclarationAnnotationAdapter(secondaryTablesAdapter, index, "javax.persistence.SecondaryTable");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class PkJoinColumnsAnnotationContainer
    implements AnnotationContainer<NestablePrimaryKeyJoinColumnAnnotation> {
        PkJoinColumnsAnnotationContainer() {
        }

        @Override
        public String getContainerAnnotationName() {
            return SourceSecondaryTableAnnotation.this.getAnnotationName();
        }

        @Override
        public Annotation getContainerJdtAnnotation(CompilationUnit astRoot) {
            return SourceSecondaryTableAnnotation.this.getJdtAnnotation(astRoot);
        }

        @Override
        public String getElementName() {
            return "pkJoinColumns";
        }

        @Override
        public String getNestableAnnotationName() {
            return "javax.persistence.PrimaryKeyJoinColumn";
        }

        @Override
        public ListIterator<NestablePrimaryKeyJoinColumnAnnotation> nestedAnnotations() {
            return SourceSecondaryTableAnnotation.this.nestablePkJoinColumns();
        }

        @Override
        public int nestedAnnotationsSize() {
            return SourceSecondaryTableAnnotation.this.pkJoinColumnsSize();
        }

        @Override
        public NestablePrimaryKeyJoinColumnAnnotation addNestedAnnotationInternal() {
            return SourceSecondaryTableAnnotation.this.addPkJoinColumnInternal();
        }

        @Override
        public void nestedAnnotationAdded(int index, NestablePrimaryKeyJoinColumnAnnotation nestedAnnotation) {
            SourceSecondaryTableAnnotation.this.pkJoinColumnAdded(index, nestedAnnotation);
        }

        @Override
        public NestablePrimaryKeyJoinColumnAnnotation moveNestedAnnotationInternal(int targetIndex, int sourceIndex) {
            return SourceSecondaryTableAnnotation.this.movePkJoinColumnInternal(targetIndex, sourceIndex);
        }

        @Override
        public void nestedAnnotationMoved(int targetIndex, int sourceIndex) {
            SourceSecondaryTableAnnotation.this.pkJoinColumnMoved(targetIndex, sourceIndex);
        }

        @Override
        public NestablePrimaryKeyJoinColumnAnnotation removeNestedAnnotationInternal(int index) {
            return SourceSecondaryTableAnnotation.this.removePkJoinColumnInternal(index);
        }

        @Override
        public void nestedAnnotationRemoved(int index, NestablePrimaryKeyJoinColumnAnnotation nestedAnnotation) {
            SourceSecondaryTableAnnotation.this.pkJoinColumnRemoved(index, nestedAnnotation);
        }

        public String toString() {
            return StringTools.buildToStringFor((Object)this);
        }
    }
}

