/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.sqm.core.internal.ui.widgets;

import java.util.ArrayList;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.datatools.connectivity.sqm.core.internal.ui.util.resources.ResourceLoader;
import org.eclipse.datatools.connectivity.sqm.core.internal.ui.widgets.DataContainerContentProvider;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.part.DrillDownComposite;

public class DataContainerSelectionGroup
extends Composite {
    private static final ResourceLoader resource = ResourceLoader.getResourceLoader();
    private Listener listener;
    private boolean allowNewContainerName = true;
    private boolean showClosedProjects = true;
    private boolean showFiles = true;
    private String[] fileFilter = new String[0];
    private String[] projectNatureFilter = new String[0];
    private boolean allowMultipleSelection = false;
    private String[] filesToExclude = new String[0];
    private IResource selectedContainer;
    private IStructuredSelection lastSelection;
    private Text containerNameField;
    TreeViewer treeViewer;
    private static final String DEFAULT_MSG_NEW_ALLOWED = resource.queryString("_UI_DEFAULT_MSG_NEW_ALLOWED");
    private static final String DEFAULT_MSG_SELECT_ONLY = resource.queryString("_UI_DEFAULT_MSG_SELECT_ONLY");
    private static final int SIZING_SELECTION_PANE_WIDTH = 320;
    private static final int SIZING_SELECTION_PANE_HEIGHT = 300;

    public DataContainerSelectionGroup(Composite parent, Listener listener, boolean allowNewContainerName) {
        this(parent, listener, allowNewContainerName, null);
    }

    public DataContainerSelectionGroup(Composite parent, Listener listener, boolean allowNewContainerName, String message) {
        this(parent, listener, allowNewContainerName, message, true, new String[0], true, new String[0], false, new String[0]);
    }

    public DataContainerSelectionGroup(Composite parent, Listener listener, boolean allowNewContainerName, String message, boolean showClosedProjects, String[] projectNatureFilter, boolean showFiles, String[] fileFilter, boolean allowMultipleSelection, String[] filesToExclude) {
        this(parent, listener, allowNewContainerName, message, showClosedProjects, 300, projectNatureFilter, showFiles, fileFilter, allowMultipleSelection, filesToExclude);
    }

    public DataContainerSelectionGroup(Composite parent, Listener listener, boolean allowNewContainerName, String message, boolean showClosedProjects, int heightHint, String[] projectNatureFilter, boolean showFiles, String[] fileFilter, boolean allowMultipleSelection, String[] filesToExclude) {
        super(parent, 0);
        this.listener = listener;
        this.allowNewContainerName = allowNewContainerName;
        this.showClosedProjects = showClosedProjects;
        this.showFiles = showFiles;
        this.fileFilter = fileFilter;
        this.projectNatureFilter = projectNatureFilter;
        this.filesToExclude = filesToExclude;
        this.allowMultipleSelection = allowMultipleSelection;
        if (message != null) {
            this.createContents(message, heightHint);
        } else if (allowNewContainerName) {
            this.createContents(DEFAULT_MSG_NEW_ALLOWED, heightHint);
        } else {
            this.createContents(DEFAULT_MSG_SELECT_ONLY, heightHint);
        }
    }

    public void containerSelectionChanged(IStructuredSelection selection) {
        this.lastSelection = selection;
        if (!this.showFiles) {
            IResource container;
            this.selectedContainer = container = (IResource)selection.getFirstElement();
            if (this.allowNewContainerName) {
                if (container == null) {
                    this.containerNameField.setText("");
                } else {
                    this.containerNameField.setText(container.getFullPath().makeRelative().toString());
                }
            }
        }
        if (this.listener != null) {
            Event changeEvent = new Event();
            changeEvent.type = 13;
            changeEvent.widget = this;
            this.listener.handleEvent(changeEvent);
        }
    }

    public void createContents(String message) {
        this.createContents(message, 300);
    }

    public void createContents(String message, int heightHint) {
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        this.setLayout((Layout)layout);
        this.setLayoutData(new GridData(1808));
        Label label = new Label((Composite)this, 64);
        label.setText(message);
        label.setFont(this.getFont());
        if (this.allowNewContainerName) {
            this.containerNameField = new Text((Composite)this, 2052);
            this.containerNameField.setLayoutData((Object)new GridData(768));
            this.containerNameField.addListener(24, this.listener);
            this.containerNameField.setFont(this.getFont());
        } else {
            new Label((Composite)this, 0);
        }
        this.createTreeViewer(heightHint);
        Dialog.applyDialogFont((Control)this);
    }

    protected void createTreeViewer(int heightHint) {
        DrillDownComposite drillDown = new DrillDownComposite((Composite)this, 2048);
        GridData spec = new GridData(1808);
        spec.widthHint = 320;
        spec.heightHint = heightHint;
        drillDown.setLayoutData((Object)spec);
        Tree tree = null;
        tree = this.allowMultipleSelection ? new Tree((Composite)drillDown, 2) : new Tree((Composite)drillDown, 0);
        this.treeViewer = new TreeViewer(tree);
        drillDown.setChildTree(this.treeViewer);
        DataContainerContentProvider cp = new DataContainerContentProvider();
        cp.showClosedProjects(this.showClosedProjects);
        cp.showFiles(this.showFiles);
        cp.setFileFilter(this.fileFilter);
        cp.setProjectNatureFilter(this.projectNatureFilter);
        cp.setExcludedFiles(this.filesToExclude);
        this.treeViewer.setContentProvider((IContentProvider)cp);
        this.treeViewer.setLabelProvider((IBaseLabelProvider)WorkbenchLabelProvider.getDecoratingWorkbenchLabelProvider());
        this.treeViewer.setSorter(new ViewerSorter());
        this.treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                DataContainerSelectionGroup.this.containerSelectionChanged(selection);
            }
        });
        this.treeViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                ISelection selection = event.getSelection();
                if (selection instanceof IStructuredSelection) {
                    Object item = ((IStructuredSelection)selection).getFirstElement();
                    if (DataContainerSelectionGroup.this.treeViewer.getExpandedState(item)) {
                        DataContainerSelectionGroup.this.treeViewer.collapseToLevel(item, 1);
                    } else {
                        DataContainerSelectionGroup.this.treeViewer.expandToLevel(item, 1);
                    }
                }
            }
        });
        this.treeViewer.setInput((Object)ResourcesPlugin.getWorkspace());
    }

    public IPath getContainerFullPath() {
        if (this.allowNewContainerName) {
            String pathName = this.containerNameField.getText();
            if (pathName == null || pathName.length() < 1) {
                return null;
            }
            return new Path(pathName).makeAbsolute();
        }
        if (this.selectedContainer == null) {
            return null;
        }
        return this.selectedContainer.getFullPath();
    }

    public void setInitialFocus() {
        if (this.allowNewContainerName) {
            this.containerNameField.setFocus();
        } else {
            this.treeViewer.getTree().setFocus();
        }
    }

    public void setSelectedContainer(IContainer container) {
        this.selectedContainer = container;
        ArrayList<IContainer> itemsToExpand = new ArrayList<IContainer>();
        IContainer parent = container.getParent();
        while (parent != null) {
            itemsToExpand.add(0, parent);
            parent = parent.getParent();
        }
        this.treeViewer.setExpandedElements(itemsToExpand.toArray());
        this.treeViewer.setSelection((ISelection)new StructuredSelection((Object)container), true);
    }

    public IStructuredSelection getSelection() {
        return this.lastSelection;
    }
}

