/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.oda.spec.result;

public class ColumnIdentifier {
    private Integer m_pos;
    private String m_valueExpr;

    public ColumnIdentifier(int pos) {
        if (pos < 1) {
            throw new IllegalArgumentException(Integer.valueOf(pos).toString());
        }
        this.m_pos = pos;
    }

    public ColumnIdentifier(String valueExpr) {
        if (valueExpr == null || valueExpr.length() == 0) {
            throw new IllegalArgumentException(valueExpr);
        }
        this.m_valueExpr = valueExpr;
    }

    public void setNumber(Integer pos) {
        this.m_pos = pos;
    }

    public void setValueExpression(String valueExpr) {
        this.m_valueExpr = valueExpr;
    }

    public Integer getNumber() {
        return this.m_pos;
    }

    public String getValueExpression() {
        return this.m_valueExpr;
    }

    public boolean isIdentifiedByNumber() {
        return this.m_pos != null && this.m_pos > 0;
    }

    public boolean hasValueExpression() {
        return this.m_valueExpr != null && this.m_valueExpr.length() > 0;
    }

    public boolean isValid() {
        if (this.isIdentifiedByNumber()) {
            return true;
        }
        return this.hasValueExpression();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ColumnIdentifier)) {
            return false;
        }
        ColumnIdentifier thatObj = (ColumnIdentifier)obj;
        if (this.isIdentifiedByNumber()) {
            return this.m_pos.equals(thatObj.m_pos);
        }
        if (this.hasValueExpression()) {
            return this.m_valueExpr.equals(thatObj.m_valueExpr);
        }
        return false;
    }

    public int hashCode() {
        if (this.isIdentifiedByNumber()) {
            return this.m_pos.hashCode();
        }
        if (this.hasValueExpression()) {
            return this.m_valueExpr.hashCode();
        }
        return super.hashCode();
    }

    public String toString() {
        return "ColumnIdentifier@" + super.hashCode() + " [number= " + this.m_pos + ", value expression= " + this.m_valueExpr + "]";
    }
}

