/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.oda.spec.manifest;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.datatools.connectivity.oda.nls.Messages;
import org.eclipse.datatools.connectivity.oda.spec.manifest.AggregateDefinition;
import org.eclipse.datatools.connectivity.oda.spec.manifest.ExtensionContributor;
import org.eclipse.datatools.connectivity.oda.spec.manifest.FilterExpressionDefinition;
import org.eclipse.datatools.connectivity.oda.util.manifest.ManifestExplorer;
import org.eclipse.datatools.connectivity.oda.util.manifest.ManifestUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResultExtensionExplorer {
    public static final String DTP_ODA_DYNAMIC_RESULT_SETS_EXT_POINT = "org.eclipse.datatools.connectivity.oda.dynamicResultSet";
    public static final String FILTER_GROUP_NAME = "filterExpressionTypes";
    public static final String AGGREGATE_GROUP_NAME = "aggregateExpressionTypes";
    private static ResultExtensionExplorer sm_instance = null;
    private static Logger sm_logger = null;
    private static final ExtensionContributor[] EMTPY_CONTRIBUTOR_ARRAY = new ExtensionContributor[0];
    private static final FilterExpressionDefinition[] EMPTY_FILTER_EXPRS_ARRAY = new FilterExpressionDefinition[0];
    private static final AggregateDefinition[] EMPTY_AGGR_EXPRS_ARRAY = new AggregateDefinition[0];
    private Map<ExtensionContributor, Map<String, FilterExpressionDefinition>> m_filterExpressionsByExtn;
    private Map<ExtensionContributor, Map<String, AggregateDefinition>> m_aggregateTypesByExtn;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ResultExtensionExplorer getInstance() {
        if (sm_instance != null) return sm_instance;
        Class<ResultExtensionExplorer> clazz = ResultExtensionExplorer.class;
        synchronized (ResultExtensionExplorer.class) {
            if (sm_instance != null) return sm_instance;
            sm_instance = new ResultExtensionExplorer();
            // ** MonitorExit[var0] (shouldn't be in output)
            return sm_instance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void releaseInstance() {
        Class<ResultExtensionExplorer> clazz = ResultExtensionExplorer.class;
        synchronized (ResultExtensionExplorer.class) {
            sm_instance = null;
            sm_logger = null;
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static Logger getLogger() {
        if (sm_logger != null) return sm_logger;
        Class<ResultExtensionExplorer> clazz = ResultExtensionExplorer.class;
        synchronized (ResultExtensionExplorer.class) {
            if (sm_logger != null) return sm_logger;
            sm_logger = Logger.getLogger(ResultExtensionExplorer.class.getPackage().getName());
            // ** MonitorExit[var0] (shouldn't be in output)
            return sm_logger;
        }
    }

    private ResultExtensionExplorer() {
        this.addAllExtensions();
    }

    public void refresh() {
        this.addAllExtensions();
    }

    private void resetCache() {
        if (this.m_filterExpressionsByExtn != null) {
            this.m_filterExpressionsByExtn.clear();
        }
        if (this.m_aggregateTypesByExtn != null) {
            this.m_aggregateTypesByExtn.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<ExtensionContributor, Map<String, FilterExpressionDefinition>> getCachedFilterExtensions() {
        if (this.m_filterExpressionsByExtn == null) {
            ResultExtensionExplorer resultExtensionExplorer = this;
            synchronized (resultExtensionExplorer) {
                if (this.m_filterExpressionsByExtn == null) {
                    this.m_filterExpressionsByExtn = new HashMap<ExtensionContributor, Map<String, FilterExpressionDefinition>>(4);
                }
            }
        }
        return this.m_filterExpressionsByExtn;
    }

    private Map<String, FilterExpressionDefinition> getCachedFilterDefinitionsByExtension(String extensionId) {
        ExtensionContributor contributor = this.findCachedContributorOfFilterExtension(extensionId);
        if (contributor != null) {
            return this.getCachedFilterExtensions().get(contributor);
        }
        return null;
    }

    private ExtensionContributor findCachedContributorOfFilterExtension(String extensionId) {
        if (this.getCachedFilterExtensions().isEmpty()) {
            return null;
        }
        for (ExtensionContributor aContributor : this.getCachedFilterExtensions().keySet()) {
            if (!aContributor.getDeclaringExtensionId().equals(extensionId)) continue;
            return aContributor;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<ExtensionContributor, Map<String, AggregateDefinition>> getCachedAggregateExtensions() {
        if (this.m_aggregateTypesByExtn == null) {
            ResultExtensionExplorer resultExtensionExplorer = this;
            synchronized (resultExtensionExplorer) {
                if (this.m_aggregateTypesByExtn == null) {
                    this.m_aggregateTypesByExtn = new HashMap<ExtensionContributor, Map<String, AggregateDefinition>>(4);
                }
            }
        }
        return this.m_aggregateTypesByExtn;
    }

    private Map<String, AggregateDefinition> getCachedAggregateDefinitionsByExtension(String extensionId) {
        ExtensionContributor contributor = this.findCachedContributorOfAggregateExtension(extensionId);
        if (contributor != null) {
            return this.getCachedAggregateExtensions().get(contributor);
        }
        return null;
    }

    private ExtensionContributor findCachedContributorOfAggregateExtension(String extensionId) {
        if (this.getCachedAggregateExtensions().isEmpty()) {
            return null;
        }
        for (ExtensionContributor aContributor : this.getCachedAggregateExtensions().keySet()) {
            if (!aContributor.getDeclaringExtensionId().equals(extensionId)) continue;
            return aContributor;
        }
        return null;
    }

    private static FilterExpressionDefinition[] convertFilterDefnValuesToSortByNameArray(Map<String, FilterExpressionDefinition> exprDefns) {
        if (exprDefns == null) {
            return EMPTY_FILTER_EXPRS_ARRAY;
        }
        TreeMap<String, FilterExpressionDefinition> sortedDefnsByName = new TreeMap<String, FilterExpressionDefinition>();
        for (FilterExpressionDefinition exprDefn : exprDefns.values()) {
            sortedDefnsByName.put(exprDefn.getDisplayName(), exprDefn);
        }
        return sortedDefnsByName.values().toArray(new FilterExpressionDefinition[sortedDefnsByName.size()]);
    }

    private static AggregateDefinition[] convertAggregateDefnValuesToSortByNameArray(Map<String, AggregateDefinition> exprDefns) {
        if (exprDefns == null) {
            return EMPTY_AGGR_EXPRS_ARRAY;
        }
        TreeMap<String, AggregateDefinition> sortedDefnsByName = new TreeMap<String, AggregateDefinition>();
        for (AggregateDefinition exprDefn : exprDefns.values()) {
            sortedDefnsByName.put(exprDefn.getDisplayName(), exprDefn);
        }
        return sortedDefnsByName.values().toArray(new AggregateDefinition[sortedDefnsByName.size()]);
    }

    public ExtensionContributor[] getContributorsOfDataSet(String odaDataSourceId, String odaDataSetId) throws IllegalArgumentException, OdaException {
        if (odaDataSourceId == null || odaDataSourceId.length() == 0) {
            throw new IllegalArgumentException(odaDataSourceId);
        }
        if (odaDataSetId == null || odaDataSetId.length() == 0) {
            throw new IllegalArgumentException(odaDataSetId);
        }
        ExtensionContributor[] contributors = this.findCachedContributorsByDataSet(odaDataSourceId, odaDataSetId);
        return contributors == null ? EMTPY_CONTRIBUTOR_ARRAY : contributors;
    }

    private ExtensionContributor[] findCachedContributorsByDataSet(String odaDataSourceId, String odaDataSetId) {
        List<ExtensionContributor> aggrContributors;
        HashSet<ExtensionContributor> contributors = new HashSet<ExtensionContributor>(4);
        List<ExtensionContributor> filterContributors = this.findCachedContributorsOfFilterExtension(odaDataSourceId, odaDataSetId);
        if (filterContributors != null) {
            contributors.addAll(filterContributors);
        }
        if ((aggrContributors = this.findCachedContributorsOfAggregateExtension(odaDataSourceId, odaDataSetId)) != null) {
            contributors.addAll(aggrContributors);
        }
        return contributors.isEmpty() ? null : contributors.toArray(new ExtensionContributor[contributors.size()]);
    }

    private List<ExtensionContributor> findCachedContributorsOfFilterExtension(String odaDataSourceId, String odaDataSetId) {
        if (this.getCachedFilterExtensions().isEmpty()) {
            return null;
        }
        return this.findSupportingContributors(this.getCachedFilterExtensions().keySet().iterator(), odaDataSourceId, odaDataSetId);
    }

    private List<ExtensionContributor> findCachedContributorsOfAggregateExtension(String odaDataSourceId, String odaDataSetId) {
        if (this.getCachedAggregateExtensions().isEmpty()) {
            return null;
        }
        return this.findSupportingContributors(this.getCachedAggregateExtensions().keySet().iterator(), odaDataSourceId, odaDataSetId);
    }

    private List<ExtensionContributor> findSupportingContributors(Iterator<ExtensionContributor> iter, String odaDataSourceId, String odaDataSetId) {
        ArrayList<ExtensionContributor> contributors = null;
        while (iter.hasNext()) {
            ExtensionContributor aContributor = iter.next();
            if (!aContributor.supportsDataSetType(odaDataSourceId, odaDataSetId)) continue;
            if (contributors == null) {
                contributors = new ArrayList<ExtensionContributor>(4);
            }
            contributors.add(aContributor);
        }
        return contributors == null || contributors.isEmpty() ? null : contributors;
    }

    public FilterExpressionDefinition[] getContributedFilterDefinitions(ExtensionContributor extensionContributor) throws IllegalArgumentException, OdaException {
        Map<String, FilterExpressionDefinition> filterExprDefns = this.getFilterDefinitionsByContributor(extensionContributor);
        return ResultExtensionExplorer.convertFilterDefnValuesToSortByNameArray(filterExprDefns);
    }

    public FilterExpressionDefinition getContributedFilterDefinition(ExtensionContributor extensionContributor, String exprId) throws IllegalArgumentException, OdaException {
        if (exprId == null || exprId.length() == 0) {
            throw new IllegalArgumentException(exprId);
        }
        Map<String, FilterExpressionDefinition> filterExprDefns = this.getFilterDefinitionsByContributor(extensionContributor);
        return filterExprDefns == null ? null : filterExprDefns.get(exprId);
    }

    public FilterExpressionDefinition[] getExtensionFilterDefinitions(String extensionId) throws IllegalArgumentException, OdaException {
        Map<String, FilterExpressionDefinition> filterExprDefns = this.getFilterDefinitionsByExtension(extensionId);
        return ResultExtensionExplorer.convertFilterDefnValuesToSortByNameArray(filterExprDefns);
    }

    public FilterExpressionDefinition getExtensionFilterDefinition(String extensionId, String exprId) throws IllegalArgumentException, OdaException {
        if (exprId == null || exprId.length() == 0) {
            throw new IllegalArgumentException(exprId);
        }
        Map<String, FilterExpressionDefinition> filterExprDefns = this.getFilterDefinitionsByExtension(extensionId);
        return filterExprDefns == null ? null : filterExprDefns.get(exprId);
    }

    private Map<String, FilterExpressionDefinition> getFilterDefinitionsByExtension(String extensionId) throws IllegalArgumentException, OdaException {
        if (extensionId == null || extensionId.length() == 0) {
            throw new IllegalArgumentException(extensionId);
        }
        Map<String, FilterExpressionDefinition> filterExprDefns = this.getCachedFilterDefinitionsByExtension(extensionId);
        return filterExprDefns;
    }

    private Map<String, FilterExpressionDefinition> getFilterDefinitionsByContributor(ExtensionContributor extensionContributor) throws IllegalArgumentException, OdaException {
        if (extensionContributor == null) {
            throw new IllegalArgumentException(new NullPointerException());
        }
        Map<String, FilterExpressionDefinition> filterExprDefns = this.getCachedFilterExtensions().get(extensionContributor);
        return filterExprDefns;
    }

    public ExtensionContributor getExtensionContributor(String extensionId) throws OdaException {
        ExtensionContributor contributor = this.findCachedContributorOfFilterExtension(extensionId);
        if (contributor != null) {
            return contributor;
        }
        contributor = this.findCachedContributorOfAggregateExtension(extensionId);
        return contributor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addAllExtensions() {
        IExtension[] extensions = ManifestExplorer.getExtensions(DTP_ODA_DYNAMIC_RESULT_SETS_EXT_POINT);
        ResultExtensionExplorer resultExtensionExplorer = this;
        synchronized (resultExtensionExplorer) {
            this.resetCache();
            int i = 0;
            while (i < extensions.length) {
                try {
                    this.addExtension(extensions[i], false);
                }
                catch (OdaException ex) {
                    ResultExtensionExplorer.getLogger().log(Level.WARNING, "Ignoring invalid org.eclipse.datatools.connectivity.oda.dynamicResultSet extension.", ex);
                }
                ++i;
            }
        }
    }

    private ExtensionContributor addExtension(IExtension dynamicResultExtn, boolean replaceExisting) throws OdaException {
        IConfigurationElement[] aggregateExprGroup;
        int i;
        IConfigurationElement[] filterExprGroup;
        IConfigurationElement contributorElement = ManifestUtil.getNamedElement(dynamicResultExtn, "contributor");
        if (contributorElement == null) {
            throw new OdaException(Messages.bind((String)Messages.querySpec_MISSING_EXT_POINT_ELEMENT, (Object[])new Object[]{DTP_ODA_DYNAMIC_RESULT_SETS_EXT_POINT, dynamicResultExtn.getUniqueIdentifier(), "contributor"}));
        }
        ExtensionContributor contributor = new ExtensionContributor(contributorElement);
        if ((replaceExisting || this.getCachedFilterExtensions().get(contributor) == null) && (filterExprGroup = ManifestUtil.getNamedElements(dynamicResultExtn, FILTER_GROUP_NAME)).length > 0) {
            IConfigurationElement[] filterExprElements = filterExprGroup[0].getChildren("filterType");
            HashMap<String, FilterExpressionDefinition> filterExprs = new HashMap<String, FilterExpressionDefinition>(filterExprElements.length);
            i = 0;
            while (i < filterExprElements.length) {
                FilterExpressionDefinition filerExprDefn = new FilterExpressionDefinition(filterExprElements[i], contributor);
                filterExprs.put(filerExprDefn.getId(), filerExprDefn);
                ++i;
            }
            this.getCachedFilterExtensions().put(contributor, filterExprs);
        }
        if ((replaceExisting || this.getCachedAggregateExtensions().get(contributor) == null) && (aggregateExprGroup = ManifestUtil.getNamedElements(dynamicResultExtn, AGGREGATE_GROUP_NAME)).length > 0) {
            IConfigurationElement[] aggregateElements = aggregateExprGroup[0].getChildren("aggregateType");
            HashMap<String, AggregateDefinition> aggregateExprs = new HashMap<String, AggregateDefinition>(aggregateElements.length);
            i = 0;
            while (i < aggregateElements.length) {
                AggregateDefinition aggregateDefn = new AggregateDefinition(aggregateElements[i], contributor);
                aggregateExprs.put(aggregateDefn.getId(), aggregateDefn);
                ++i;
            }
            this.getCachedAggregateExtensions().put(contributor, aggregateExprs);
        }
        return contributor;
    }

    public AggregateDefinition[] getContributedAggregateDefinitions(ExtensionContributor extensionContributor) throws IllegalArgumentException, OdaException {
        Map<String, AggregateDefinition> aggrExprDefns = this.getAggregateDefinitionsByContributor(extensionContributor);
        return ResultExtensionExplorer.convertAggregateDefnValuesToSortByNameArray(aggrExprDefns);
    }

    public AggregateDefinition getContributedAggregateDefinition(ExtensionContributor extensionContributor, String exprId) throws IllegalArgumentException, OdaException {
        if (exprId == null || exprId.length() == 0) {
            throw new IllegalArgumentException(exprId);
        }
        Map<String, AggregateDefinition> aggrExprDefns = this.getAggregateDefinitionsByContributor(extensionContributor);
        return aggrExprDefns == null ? null : aggrExprDefns.get(exprId);
    }

    public AggregateDefinition[] getExtensionAggregateDefinitions(String extensionId) throws IllegalArgumentException, OdaException {
        Map<String, AggregateDefinition> aggrExprDefns = this.getAggregateDefinitionsByExtension(extensionId);
        return ResultExtensionExplorer.convertAggregateDefnValuesToSortByNameArray(aggrExprDefns);
    }

    public AggregateDefinition getExtensionAggregateDefinition(String extensionId, String exprId) throws IllegalArgumentException, OdaException {
        if (exprId == null || exprId.length() == 0) {
            throw new IllegalArgumentException(exprId);
        }
        Map<String, AggregateDefinition> aggrExprDefns = this.getAggregateDefinitionsByExtension(extensionId);
        return aggrExprDefns == null ? null : aggrExprDefns.get(exprId);
    }

    private Map<String, AggregateDefinition> getAggregateDefinitionsByExtension(String extensionId) throws IllegalArgumentException, OdaException {
        if (extensionId == null || extensionId.length() == 0) {
            throw new IllegalArgumentException(extensionId);
        }
        Map<String, AggregateDefinition> exprDefns = this.getCachedAggregateDefinitionsByExtension(extensionId);
        return exprDefns;
    }

    private Map<String, AggregateDefinition> getAggregateDefinitionsByContributor(ExtensionContributor extensionContributor) throws OdaException {
        if (extensionContributor == null) {
            throw new IllegalArgumentException(new NullPointerException());
        }
        Map<String, AggregateDefinition> aggregateDefns = this.getCachedAggregateExtensions().get(extensionContributor);
        return aggregateDefns;
    }
}

