/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jee.ui.internal.navigator.web;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jst.javaee.core.JavaEEObject;
import org.eclipse.jst.javaee.web.WebApp;
import org.eclipse.jst.jee.ui.internal.Messages;
import org.eclipse.jst.jee.ui.internal.navigator.AbstractGroupProvider;
import org.eclipse.jst.jee.ui.internal.navigator.web.GroupContextParamsItemProvider;
import org.eclipse.jst.jee.ui.internal.navigator.web.GroupErrorPagesItemProvider;
import org.eclipse.jst.jee.ui.internal.navigator.web.GroupFilterMappingItemProvider;
import org.eclipse.jst.jee.ui.internal.navigator.web.GroupFiltersItemProvider;
import org.eclipse.jst.jee.ui.internal.navigator.web.GroupListenerItemProvider;
import org.eclipse.jst.jee.ui.internal.navigator.web.GroupReferenceItemProvider;
import org.eclipse.jst.jee.ui.internal.navigator.web.GroupServletItemProvider;
import org.eclipse.jst.jee.ui.internal.navigator.web.GroupServletMappingItemProvider;
import org.eclipse.jst.jee.ui.internal.navigator.web.GroupWelcomePagesItemProvider;
import org.eclipse.jst.jee.ui.plugin.JEEUIPlugin;
import org.eclipse.jst.jee.ui.plugin.JEEUIPluginIcons;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualFolder;

public class WebAppProvider
extends AbstractGroupProvider
implements IAdaptable {
    private static final String PROJECT_RELATIVE_PATH = "WEB-INF/web.xml";
    private GroupErrorPagesItemProvider errors;
    private GroupServletItemProvider servlets;
    private GroupFiltersItemProvider filters;
    private GroupListenerItemProvider listeners;
    private GroupServletMappingItemProvider servletMapping;
    private GroupFilterMappingItemProvider filterMapping;
    private GroupReferenceItemProvider references;
    private GroupWelcomePagesItemProvider welcome;
    private GroupContextParamsItemProvider contextParams;
    private List<Object> children = new ArrayList<Object>();
    private String text;
    private Image WEB_APP_IMAGE;
    private IProject prjct = null;
    private IFile ddFile = null;

    public WebAppProvider(WebApp webApp, IProject project) {
        super((JavaEEObject)webApp);
        this.text = NLS.bind((String)Messages.DEPLOYMENT_DESCRIPTOR, (Object)project.getName());
        this.contextParams = new GroupContextParamsItemProvider(webApp);
        this.errors = new GroupErrorPagesItemProvider(webApp);
        this.servlets = new GroupServletItemProvider(webApp);
        this.servletMapping = new GroupServletMappingItemProvider(webApp);
        this.filters = new GroupFiltersItemProvider(webApp);
        this.filterMapping = new GroupFilterMappingItemProvider(webApp);
        this.listeners = new GroupListenerItemProvider(webApp);
        this.references = new GroupReferenceItemProvider(webApp);
        this.welcome = new GroupWelcomePagesItemProvider(webApp);
        this.children.add(this.contextParams);
        this.children.add(this.errors);
        this.children.add(this.servlets);
        this.children.add(this.filters);
        this.children.add(this.listeners);
        this.children.add(this.servletMapping);
        this.children.add(this.filterMapping);
        this.children.add(this.references);
        this.children.add(this.welcome);
        this.prjct = project;
    }

    public List getChildren() {
        return this.children;
    }

    public String getText() {
        return this.text;
    }

    public Image getImage() {
        if (this.WEB_APP_IMAGE == null) {
            ImageDescriptor imageWebDescriptor = JEEUIPlugin.getDefault().getImageDescriptor(JEEUIPluginIcons.IMG_WEBEEMODEL);
            this.WEB_APP_IMAGE = imageWebDescriptor.createImage();
        }
        return this.WEB_APP_IMAGE;
    }

    public IProject getProject() {
        return this.prjct;
    }

    public IFile getDDFile() {
        if (this.ddFile != null) {
            return this.ddFile;
        }
        IVirtualFolder virtualFolder = ComponentCore.createComponent((IProject)this.getProject()).getRootFolder();
        return virtualFolder.getFile(PROJECT_RELATIVE_PATH).getUnderlyingFile();
    }

    public void reinit(JavaEEObject modelObject) {
        super.reinit(modelObject);
        for (Object child : this.children) {
            ((AbstractGroupProvider)child).reinit(modelObject);
        }
    }

    public Object getAdapter(Class adapter) {
        if (IProject.class == adapter) {
            return this.getProject();
        }
        return null;
    }
}

