/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.utility.jdt;

import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jpt.core.internal.utility.jdt.ConversionDeclarationAnnotationElementAdapter;
import org.eclipse.jpt.core.internal.utility.jdt.JDTTools;
import org.eclipse.jpt.core.internal.utility.jdt.NameStringExpressionConverter;
import org.eclipse.jpt.core.utility.jdt.DeclarationAnnotationAdapter;
import org.eclipse.jpt.core.utility.jdt.DeclarationAnnotationElementAdapter;
import org.eclipse.jpt.core.utility.jdt.ModifiedDeclaration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EnumDeclarationAnnotationElementAdapter
implements DeclarationAnnotationElementAdapter<String> {
    private final ConversionDeclarationAnnotationElementAdapter<String> adapter;

    public EnumDeclarationAnnotationElementAdapter(DeclarationAnnotationAdapter annotationAdapter) {
        this(annotationAdapter, "value");
    }

    public EnumDeclarationAnnotationElementAdapter(DeclarationAnnotationAdapter annotationAdapter, String elementName) {
        this(annotationAdapter, elementName, true);
    }

    public EnumDeclarationAnnotationElementAdapter(DeclarationAnnotationAdapter annotationAdapter, String elementName, boolean removeAnnotationWhenEmpty) {
        this(new ConversionDeclarationAnnotationElementAdapter<String>(annotationAdapter, elementName, removeAnnotationWhenEmpty, NameStringExpressionConverter.instance()));
    }

    protected EnumDeclarationAnnotationElementAdapter(ConversionDeclarationAnnotationElementAdapter<String> adapter) {
        this.adapter = adapter;
    }

    @Override
    public String getValue(ModifiedDeclaration declaration) {
        return this.resolve(this.adapter.getExpression(declaration));
    }

    @Override
    public void setValue(String value, ModifiedDeclaration declaration) {
        this.adapter.setValue(EnumDeclarationAnnotationElementAdapter.convertToSourceCodeName(value, declaration), declaration);
    }

    @Override
    public Expression getExpression(ModifiedDeclaration declaration) {
        return this.adapter.getExpression(declaration);
    }

    @Override
    public ASTNode getAstNode(ModifiedDeclaration declaration) {
        return this.adapter.getAstNode(declaration);
    }

    protected String resolve(Expression expression) {
        return JDTTools.resolveEnum(expression);
    }

    protected static String convertToSourceCodeName(String enumConstantName, ModifiedDeclaration declaration) {
        return enumConstantName == null ? null : EnumDeclarationAnnotationElementAdapter.convertToSourceCodeName_(enumConstantName, declaration);
    }

    protected static String convertToSourceCodeName_(String enumConstantName, ModifiedDeclaration declaration) {
        if (declaration.addStaticImport(enumConstantName)) {
            return EnumDeclarationAnnotationElementAdapter.convertToShortName(enumConstantName);
        }
        if (declaration.addImport(EnumDeclarationAnnotationElementAdapter.convertToTypeName(enumConstantName))) {
            return EnumDeclarationAnnotationElementAdapter.convertToPartiallyQualifiedName(enumConstantName);
        }
        return enumConstantName;
    }

    protected static String convertToShortName(String name) {
        return name.substring(name.lastIndexOf(46) + 1);
    }

    protected static String convertToTypeName(String name) {
        return name.substring(0, name.lastIndexOf(46));
    }

    protected static String convertToPartiallyQualifiedName(String name) {
        return name.substring(name.lastIndexOf(46, name.lastIndexOf(46) - 1) + 1);
    }
}

