/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.resource.java.source;

import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.core.internal.resource.java.source.SourceAnnotation;
import org.eclipse.jpt.core.internal.utility.jdt.ConversionDeclarationAnnotationElementAdapter;
import org.eclipse.jpt.core.internal.utility.jdt.JDTTools;
import org.eclipse.jpt.core.internal.utility.jdt.ShortCircuitAnnotationElementAdapter;
import org.eclipse.jpt.core.internal.utility.jdt.SimpleDeclarationAnnotationAdapter;
import org.eclipse.jpt.core.internal.utility.jdt.SimpleTypeStringExpressionConverter;
import org.eclipse.jpt.core.resource.java.IdClassAnnotation;
import org.eclipse.jpt.core.resource.java.JavaResourceNode;
import org.eclipse.jpt.core.utility.TextRange;
import org.eclipse.jpt.core.utility.jdt.AnnotationElementAdapter;
import org.eclipse.jpt.core.utility.jdt.DeclarationAnnotationAdapter;
import org.eclipse.jpt.core.utility.jdt.DeclarationAnnotationElementAdapter;
import org.eclipse.jpt.core.utility.jdt.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SourceIdClassAnnotation
extends SourceAnnotation<Type>
implements IdClassAnnotation {
    private static final DeclarationAnnotationAdapter DECLARATION_ANNOTATION_ADAPTER = new SimpleDeclarationAnnotationAdapter("javax.persistence.IdClass");
    private static final DeclarationAnnotationElementAdapter<String> VALUE_ADAPTER = SourceIdClassAnnotation.buildValueAdapter();
    private final AnnotationElementAdapter<String> valueAdapter;
    private String value;
    private String fullyQualifiedClassName;

    public SourceIdClassAnnotation(JavaResourceNode parent, Type type) {
        super(parent, type, DECLARATION_ANNOTATION_ADAPTER);
        this.valueAdapter = new ShortCircuitAnnotationElementAdapter<String>(type, VALUE_ADAPTER);
    }

    @Override
    public String getAnnotationName() {
        return "javax.persistence.IdClass";
    }

    @Override
    public void initialize(CompilationUnit astRoot) {
        this.value = this.buildValue(astRoot);
        this.fullyQualifiedClassName = this.buildFullyQualifiedClassName(astRoot);
    }

    @Override
    public void update(CompilationUnit astRoot) {
        this.setValue(this.buildValue(astRoot));
        this.setFullyQualifiedClassName(this.buildFullyQualifiedClassName(astRoot));
    }

    public void toString(StringBuilder sb) {
        sb.append(this.value);
    }

    @Override
    public String getValue() {
        return this.value;
    }

    @Override
    public void setValue(String value) {
        if (this.attributeValueHasNotChanged(this.value, value)) {
            return;
        }
        String old = this.value;
        this.value = value;
        this.valueAdapter.setValue(value);
        this.firePropertyChanged("value", old, value);
    }

    private String buildValue(CompilationUnit astRoot) {
        return this.valueAdapter.getValue(astRoot);
    }

    @Override
    public TextRange getValueTextRange(CompilationUnit astRoot) {
        return this.getElementTextRange(VALUE_ADAPTER, astRoot);
    }

    @Override
    public String getFullyQualifiedClassName() {
        return this.fullyQualifiedClassName;
    }

    private void setFullyQualifiedClassName(String fullyQualifiedClassName) {
        String old = this.fullyQualifiedClassName;
        this.fullyQualifiedClassName = fullyQualifiedClassName;
        this.firePropertyChanged("fullyQualifiedClassName", old, fullyQualifiedClassName);
    }

    private String buildFullyQualifiedClassName(CompilationUnit astRoot) {
        return this.value == null ? null : JDTTools.resolveFullyQualifiedName(this.valueAdapter.getExpression(astRoot));
    }

    protected static DeclarationAnnotationElementAdapter<String> buildValueAdapter() {
        return new ConversionDeclarationAnnotationElementAdapter<String>(DECLARATION_ANNOTATION_ADAPTER, "value", SimpleTypeStringExpressionConverter.instance());
    }
}

