/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.resource.java.source;

import java.util.ListIterator;
import java.util.Vector;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.core.internal.resource.java.source.AnnotationContainerTools;
import org.eclipse.jpt.core.internal.resource.java.source.SourceJoinColumnAnnotation;
import org.eclipse.jpt.core.internal.resource.java.source.SourceOverrideAnnotation;
import org.eclipse.jpt.core.internal.utility.jdt.MemberAnnotationAdapter;
import org.eclipse.jpt.core.internal.utility.jdt.MemberIndexedAnnotationAdapter;
import org.eclipse.jpt.core.internal.utility.jdt.NestedIndexedDeclarationAnnotationAdapter;
import org.eclipse.jpt.core.internal.utility.jdt.SimpleDeclarationAnnotationAdapter;
import org.eclipse.jpt.core.resource.java.AnnotationContainer;
import org.eclipse.jpt.core.resource.java.AssociationOverrideAnnotation;
import org.eclipse.jpt.core.resource.java.JavaResourceNode;
import org.eclipse.jpt.core.resource.java.JoinColumnAnnotation;
import org.eclipse.jpt.core.resource.java.NestableAnnotation;
import org.eclipse.jpt.core.resource.java.NestableAssociationOverrideAnnotation;
import org.eclipse.jpt.core.resource.java.NestableJoinColumnAnnotation;
import org.eclipse.jpt.core.utility.jdt.AnnotationAdapter;
import org.eclipse.jpt.core.utility.jdt.DeclarationAnnotationAdapter;
import org.eclipse.jpt.core.utility.jdt.IndexedDeclarationAnnotationAdapter;
import org.eclipse.jpt.core.utility.jdt.Member;
import org.eclipse.jpt.utility.internal.CollectionTools;
import org.eclipse.jpt.utility.internal.StringTools;
import org.eclipse.jpt.utility.internal.iterators.CloneListIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SourceAssociationOverrideAnnotation
extends SourceOverrideAnnotation
implements NestableAssociationOverrideAnnotation {
    public static final DeclarationAnnotationAdapter DECLARATION_ANNOTATION_ADAPTER = new SimpleDeclarationAnnotationAdapter("javax.persistence.AssociationOverride");
    private final Vector<NestableJoinColumnAnnotation> joinColumns = new Vector();
    private final JoinColumnsAnnotationContainer joinColumnsContainer = new JoinColumnsAnnotationContainer();

    public SourceAssociationOverrideAnnotation(JavaResourceNode parent, Member member, DeclarationAnnotationAdapter daa, AnnotationAdapter annotationAdapter) {
        super(parent, member, daa, annotationAdapter);
    }

    @Override
    public String getAnnotationName() {
        return "javax.persistence.AssociationOverride";
    }

    @Override
    public void initialize(CompilationUnit astRoot) {
        super.initialize(astRoot);
        AnnotationContainerTools.initialize(this.joinColumnsContainer, astRoot);
    }

    @Override
    public void update(CompilationUnit astRoot) {
        super.update(astRoot);
        AnnotationContainerTools.update(this.joinColumnsContainer, astRoot);
    }

    @Override
    String getNameElementName() {
        return "name";
    }

    @Override
    public ListIterator<JoinColumnAnnotation> joinColumns() {
        return new CloneListIterator(this.joinColumns);
    }

    ListIterator<NestableJoinColumnAnnotation> nestableJoinColumns() {
        return new CloneListIterator(this.joinColumns);
    }

    @Override
    public int joinColumnsSize() {
        return this.joinColumns.size();
    }

    @Override
    public NestableJoinColumnAnnotation joinColumnAt(int index) {
        return this.joinColumns.get(index);
    }

    @Override
    public int indexOfJoinColumn(JoinColumnAnnotation joinColumn) {
        return this.joinColumns.indexOf(joinColumn);
    }

    @Override
    public NestableJoinColumnAnnotation addJoinColumn(int index) {
        return (NestableJoinColumnAnnotation)AnnotationContainerTools.addNestedAnnotation(index, this.joinColumnsContainer);
    }

    NestableJoinColumnAnnotation addJoinColumnInternal() {
        NestableJoinColumnAnnotation joinColumn = this.buildJoinColumn(this.joinColumns.size());
        this.joinColumns.add(joinColumn);
        return joinColumn;
    }

    private NestableJoinColumnAnnotation buildJoinColumn(int index) {
        return SourceJoinColumnAnnotation.createAssociationOverrideJoinColumn(this.daa, this, this.member, index);
    }

    void joinColumnAdded(int index, NestableJoinColumnAnnotation joinColumn) {
        this.fireItemAdded("joinColumns", index, joinColumn);
    }

    @Override
    public void moveJoinColumn(int targetIndex, int sourceIndex) {
        AnnotationContainerTools.moveNestedAnnotation(targetIndex, sourceIndex, this.joinColumnsContainer);
    }

    NestableJoinColumnAnnotation moveJoinColumnInternal(int targetIndex, int sourceIndex) {
        return (NestableJoinColumnAnnotation)CollectionTools.move(this.joinColumns, (int)targetIndex, (int)sourceIndex).get(targetIndex);
    }

    void joinColumnMoved(int targetIndex, int sourceIndex) {
        this.fireItemMoved("joinColumns", targetIndex, sourceIndex);
    }

    @Override
    public void removeJoinColumn(int index) {
        AnnotationContainerTools.removeNestedAnnotation(index, this.joinColumnsContainer);
    }

    NestableJoinColumnAnnotation removeJoinColumnInternal(int index) {
        return this.joinColumns.remove(index);
    }

    void joinColumnRemoved(int index, NestableJoinColumnAnnotation joinColumn) {
        this.fireItemRemoved("joinColumns", index, joinColumn);
    }

    @Override
    public void initializeFrom(NestableAnnotation oldAnnotation) {
        super.initializeFrom(oldAnnotation);
        AssociationOverrideAnnotation oldOverride = (AssociationOverrideAnnotation)((Object)oldAnnotation);
        for (JoinColumnAnnotation oldJoinColumn : CollectionTools.iterable(oldOverride.joinColumns())) {
            NestableJoinColumnAnnotation newJoinColumn = this.addJoinColumn(oldOverride.indexOfJoinColumn(oldJoinColumn));
            newJoinColumn.initializeFrom((NestableAnnotation)((Object)oldJoinColumn));
        }
    }

    public static SourceAssociationOverrideAnnotation createAssociationOverride(JavaResourceNode parent, Member member) {
        return new SourceAssociationOverrideAnnotation(parent, member, DECLARATION_ANNOTATION_ADAPTER, (AnnotationAdapter)new MemberAnnotationAdapter(member, DECLARATION_ANNOTATION_ADAPTER));
    }

    static SourceAssociationOverrideAnnotation createNestedAssociationOverride(JavaResourceNode parent, Member member, int index, DeclarationAnnotationAdapter attributeOverridesAdapter) {
        IndexedDeclarationAnnotationAdapter idaa = SourceAssociationOverrideAnnotation.buildNestedDeclarationAnnotationAdapter(index, attributeOverridesAdapter);
        MemberIndexedAnnotationAdapter annotationAdapter = new MemberIndexedAnnotationAdapter(member, idaa);
        return new SourceAssociationOverrideAnnotation(parent, member, (DeclarationAnnotationAdapter)idaa, (AnnotationAdapter)annotationAdapter);
    }

    protected static IndexedDeclarationAnnotationAdapter buildNestedDeclarationAnnotationAdapter(int index, DeclarationAnnotationAdapter attributeOverridesAdapter) {
        return new NestedIndexedDeclarationAnnotationAdapter(attributeOverridesAdapter, index, "javax.persistence.AssociationOverride");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class JoinColumnsAnnotationContainer
    implements AnnotationContainer<NestableJoinColumnAnnotation> {
        JoinColumnsAnnotationContainer() {
        }

        @Override
        public String getContainerAnnotationName() {
            return SourceAssociationOverrideAnnotation.this.getAnnotationName();
        }

        @Override
        public Annotation getContainerJdtAnnotation(CompilationUnit astRoot) {
            return SourceAssociationOverrideAnnotation.this.getJdtAnnotation(astRoot);
        }

        @Override
        public String getElementName() {
            return "joinColumns";
        }

        @Override
        public String getNestableAnnotationName() {
            return "javax.persistence.JoinColumn";
        }

        @Override
        public ListIterator<NestableJoinColumnAnnotation> nestedAnnotations() {
            return SourceAssociationOverrideAnnotation.this.nestableJoinColumns();
        }

        @Override
        public int nestedAnnotationsSize() {
            return SourceAssociationOverrideAnnotation.this.joinColumnsSize();
        }

        @Override
        public NestableJoinColumnAnnotation addNestedAnnotationInternal() {
            return SourceAssociationOverrideAnnotation.this.addJoinColumnInternal();
        }

        @Override
        public void nestedAnnotationAdded(int index, NestableJoinColumnAnnotation nestedAnnotation) {
            SourceAssociationOverrideAnnotation.this.joinColumnAdded(index, nestedAnnotation);
        }

        @Override
        public NestableJoinColumnAnnotation moveNestedAnnotationInternal(int targetIndex, int sourceIndex) {
            return SourceAssociationOverrideAnnotation.this.moveJoinColumnInternal(targetIndex, sourceIndex);
        }

        @Override
        public void nestedAnnotationMoved(int targetIndex, int sourceIndex) {
            SourceAssociationOverrideAnnotation.this.joinColumnMoved(targetIndex, sourceIndex);
        }

        @Override
        public NestableJoinColumnAnnotation removeNestedAnnotationInternal(int index) {
            return SourceAssociationOverrideAnnotation.this.removeJoinColumnInternal(index);
        }

        @Override
        public void nestedAnnotationRemoved(int index, NestableJoinColumnAnnotation nestedAnnotation) {
            SourceAssociationOverrideAnnotation.this.joinColumnRemoved(index, nestedAnnotation);
        }

        public String toString() {
            return StringTools.buildToStringFor((Object)this);
        }
    }
}

