/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.context.java;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.core.context.BaseJoinColumn;
import org.eclipse.jpt.core.context.Entity;
import org.eclipse.jpt.core.context.JoinColumn;
import org.eclipse.jpt.core.context.RelationshipMapping;
import org.eclipse.jpt.core.context.TypeMapping;
import org.eclipse.jpt.core.context.java.JavaJoinColumn;
import org.eclipse.jpt.core.context.java.JavaJoinColumnEnabledRelationshipReference;
import org.eclipse.jpt.core.context.java.JavaJoinColumnJoiningStrategy;
import org.eclipse.jpt.core.context.java.JavaRelationshipMapping;
import org.eclipse.jpt.core.internal.context.java.AbstractJavaJpaContextNode;
import org.eclipse.jpt.core.internal.resource.java.NullJoinColumnAnnotation;
import org.eclipse.jpt.core.internal.validation.DefaultJpaValidationMessages;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentAttribute;
import org.eclipse.jpt.core.resource.java.JoinColumnAnnotation;
import org.eclipse.jpt.core.resource.java.NestableAnnotation;
import org.eclipse.jpt.core.utility.TextRange;
import org.eclipse.jpt.db.Table;
import org.eclipse.jpt.utility.Filter;
import org.eclipse.jpt.utility.internal.CollectionTools;
import org.eclipse.jpt.utility.internal.iterators.CloneListIterator;
import org.eclipse.jpt.utility.internal.iterators.EmptyListIterator;
import org.eclipse.jpt.utility.internal.iterators.SingleElementListIterator;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericJavaJoinColumnJoiningStrategy
extends AbstractJavaJpaContextNode
implements JavaJoinColumnJoiningStrategy {
    protected JavaResourcePersistentAttribute resourcePersistentAttribute;
    protected JavaJoinColumn defaultJoinColumn;
    protected final List<JavaJoinColumn> specifiedJoinColumns = new ArrayList<JavaJoinColumn>();

    public GenericJavaJoinColumnJoiningStrategy(JavaJoinColumnEnabledRelationshipReference parent) {
        super(parent);
    }

    @Override
    public JavaJoinColumnEnabledRelationshipReference getParent() {
        return (JavaJoinColumnEnabledRelationshipReference)super.getParent();
    }

    @Override
    public JavaJoinColumnEnabledRelationshipReference getRelationshipReference() {
        return this.getParent();
    }

    public JavaRelationshipMapping getRelationshipMapping() {
        return this.getRelationshipReference().getRelationshipMapping();
    }

    @Override
    public void addStrategy() {
        if (this.specifiedJoinColumnsSize() == 0) {
            this.addSpecifiedJoinColumn(0);
        }
    }

    @Override
    public void removeStrategy() {
        for (JoinColumn each : CollectionTools.iterable(this.specifiedJoinColumns())) {
            this.removeSpecifiedJoinColumn(each);
        }
    }

    @Override
    public ListIterator<JavaJoinColumn> joinColumns() {
        return this.hasSpecifiedJoinColumns() ? this.specifiedJoinColumns() : this.defaultJoinColumns();
    }

    @Override
    public int joinColumnsSize() {
        return this.hasSpecifiedJoinColumns() ? this.specifiedJoinColumnsSize() : this.defaultJoinColumnsSize();
    }

    @Override
    public JavaJoinColumn getDefaultJoinColumn() {
        return this.defaultJoinColumn;
    }

    protected void setDefaultJoinColumn(JavaJoinColumn column) {
        JavaJoinColumn old = this.defaultJoinColumn;
        this.defaultJoinColumn = column;
        this.firePropertyChanged("defaultJoinColumn", old, column);
    }

    protected ListIterator<JavaJoinColumn> defaultJoinColumns() {
        if (this.defaultJoinColumn != null) {
            return new SingleElementListIterator((Object)this.defaultJoinColumn);
        }
        return EmptyListIterator.instance();
    }

    protected int defaultJoinColumnsSize() {
        return this.defaultJoinColumn == null ? 0 : 1;
    }

    @Override
    public ListIterator<JavaJoinColumn> specifiedJoinColumns() {
        return new CloneListIterator(this.specifiedJoinColumns);
    }

    @Override
    public int specifiedJoinColumnsSize() {
        return this.specifiedJoinColumns.size();
    }

    @Override
    public boolean hasSpecifiedJoinColumns() {
        return !this.specifiedJoinColumns.isEmpty();
    }

    @Override
    public JavaJoinColumn addSpecifiedJoinColumn(int index) {
        JavaJoinColumn oldDefaultJoinColumn = this.defaultJoinColumn;
        if (oldDefaultJoinColumn != null) {
            this.defaultJoinColumn = null;
        }
        JavaJoinColumn joinColumn = this.getJpaFactory().buildJavaJoinColumn(this, this.createJoinColumnOwner());
        this.specifiedJoinColumns.add(index, joinColumn);
        JoinColumnAnnotation joinColumnAnnotation = this.addAnnotation(index);
        joinColumn.initialize(joinColumnAnnotation);
        this.fireItemAdded("specifiedJoinColumns", index, joinColumn);
        if (oldDefaultJoinColumn != null) {
            this.firePropertyChanged("defaultJoinColumn", oldDefaultJoinColumn, null);
        }
        return joinColumn;
    }

    protected void addSpecifiedJoinColumn(int index, JavaJoinColumn joinColumn) {
        this.addItemToList(index, joinColumn, this.specifiedJoinColumns, "specifiedJoinColumns");
    }

    protected void addSpecifiedJoinColumn(JavaJoinColumn joinColumn) {
        this.addSpecifiedJoinColumn(this.specifiedJoinColumns.size(), joinColumn);
    }

    @Override
    public void removeSpecifiedJoinColumn(JoinColumn joinColumn) {
        this.removeSpecifiedJoinColumn(this.specifiedJoinColumns.indexOf(joinColumn));
    }

    @Override
    public void removeSpecifiedJoinColumn(int index) {
        JavaJoinColumn removedJoinColumn = this.specifiedJoinColumns.remove(index);
        if (this.specifiedJoinColumns.isEmpty()) {
            this.defaultJoinColumn = this.buildJoinColumn(new NullJoinColumnAnnotation(this.resourcePersistentAttribute));
        }
        this.removeAnnotation(index);
        this.fireItemRemoved("specifiedJoinColumns", index, removedJoinColumn);
        if (this.defaultJoinColumn != null) {
            this.firePropertyChanged("defaultJoinColumn", null, this.defaultJoinColumn);
        }
    }

    protected void removeSpecifiedJoinColumn_(JavaJoinColumn joinColumn) {
        this.removeItemFromList(joinColumn, this.specifiedJoinColumns, "specifiedJoinColumns");
    }

    @Override
    public void moveSpecifiedJoinColumn(int targetIndex, int sourceIndex) {
        CollectionTools.move(this.specifiedJoinColumns, (int)targetIndex, (int)sourceIndex);
        this.moveAnnotation(targetIndex, sourceIndex);
        this.fireItemMoved("specifiedJoinColumns", targetIndex, sourceIndex);
    }

    protected JoinColumnAnnotation addAnnotation(int index) {
        return (JoinColumnAnnotation)this.resourcePersistentAttribute.addSupportingAnnotation(index, "javax.persistence.JoinColumn", "javax.persistence.JoinColumns");
    }

    protected void removeAnnotation(int index) {
        this.resourcePersistentAttribute.removeSupportingAnnotation(index, "javax.persistence.JoinColumn", "javax.persistence.JoinColumns");
    }

    protected void moveAnnotation(int targetIndex, int sourceIndex) {
        this.resourcePersistentAttribute.moveSupportingAnnotation(targetIndex, sourceIndex, "javax.persistence.JoinColumns");
    }

    @Override
    public void initialize() {
        this.resourcePersistentAttribute = this.getRelationshipReference().getRelationshipMapping().getPersistentAttribute().getResourcePersistentAttribute();
        this.initializeSpecifiedJoinColumns();
        this.initializeDefaultJoinColumn();
    }

    protected void initializeSpecifiedJoinColumns() {
        ListIterator<NestableAnnotation> annotations = this.resourcePersistentAttribute.supportingAnnotations("javax.persistence.JoinColumn", "javax.persistence.JoinColumns");
        while (annotations.hasNext()) {
            this.specifiedJoinColumns.add(this.buildJoinColumn((JoinColumnAnnotation)((Object)annotations.next())));
        }
    }

    public void initializeDefaultJoinColumn() {
        if (this.mayHaveDefaultJoinColumn()) {
            this.defaultJoinColumn = this.buildJoinColumn(new NullJoinColumnAnnotation(this.resourcePersistentAttribute));
        }
    }

    @Override
    public void update() {
        this.resourcePersistentAttribute = this.getRelationshipReference().getRelationshipMapping().getPersistentAttribute().getResourcePersistentAttribute();
        this.updateSpecifiedJoinColumns();
        this.updateDefaultJoinColumn();
    }

    protected void updateSpecifiedJoinColumns() {
        ListIterator<JavaJoinColumn> joinColumns = this.specifiedJoinColumns();
        ListIterator<NestableAnnotation> resourceJoinColumns = this.resourcePersistentAttribute.supportingAnnotations("javax.persistence.JoinColumn", "javax.persistence.JoinColumns");
        while (joinColumns.hasNext()) {
            JavaJoinColumn joinColumn = joinColumns.next();
            if (resourceJoinColumns.hasNext()) {
                joinColumn.update((JoinColumnAnnotation)((Object)resourceJoinColumns.next()));
                continue;
            }
            this.removeSpecifiedJoinColumn_(joinColumn);
        }
        while (resourceJoinColumns.hasNext()) {
            this.addSpecifiedJoinColumn(this.buildJoinColumn((JoinColumnAnnotation)((Object)resourceJoinColumns.next())));
        }
    }

    protected void updateDefaultJoinColumn() {
        if (this.mayHaveDefaultJoinColumn()) {
            NullJoinColumnAnnotation nullAnnotation = new NullJoinColumnAnnotation(this.resourcePersistentAttribute);
            if (this.defaultJoinColumn == null) {
                this.setDefaultJoinColumn(this.buildJoinColumn(nullAnnotation));
            }
            this.defaultJoinColumn.update(nullAnnotation);
        } else if (this.defaultJoinColumn != null) {
            this.setDefaultJoinColumn(null);
        }
    }

    protected boolean mayHaveDefaultJoinColumn() {
        return this.getRelationshipReference().mayHaveDefaultJoinColumn() && !this.hasSpecifiedJoinColumns();
    }

    protected JavaJoinColumn buildJoinColumn(JoinColumnAnnotation joinColumnResource) {
        JavaJoinColumn joinColumn = this.getJpaFactory().buildJavaJoinColumn(this, this.createJoinColumnOwner());
        joinColumn.initialize(joinColumnResource);
        return joinColumn;
    }

    protected JavaJoinColumn.Owner createJoinColumnOwner() {
        return new JoinColumnOwner();
    }

    @Override
    public Iterator<String> javaCompletionProposals(int pos, Filter<String> filter, CompilationUnit astRoot) {
        Iterator result = super.javaCompletionProposals(pos, filter, astRoot);
        if (result != null) {
            return result;
        }
        for (JavaJoinColumn column : CollectionTools.iterable(this.joinColumns())) {
            result = column.javaCompletionProposals(pos, filter, astRoot);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    @Override
    public void validate(List<IMessage> messages, IReporter reporter, CompilationUnit astRoot) {
        super.validate(messages, reporter, astRoot);
        if (this.getRelationshipMapping().shouldValidateAgainstDatabase()) {
            ListIterator<JavaJoinColumn> stream = this.joinColumns();
            while (stream.hasNext()) {
                this.validateJoinColumn((JavaJoinColumn)stream.next(), messages, astRoot);
            }
        }
    }

    protected void validateJoinColumn(JavaJoinColumn joinColumn, List<IMessage> messages, CompilationUnit astRoot) {
        if (this.getRelationshipMapping().getTypeMapping().tableNameIsInvalid(joinColumn.getTable())) {
            messages.add(DefaultJpaValidationMessages.buildMessage(1, "JOIN_COLUMN_UNRESOLVED_TABLE", new String[]{joinColumn.getTable(), joinColumn.getName()}, joinColumn, joinColumn.getTableTextRange(astRoot)));
            return;
        }
        this.validateJoinColumnName(joinColumn, messages, astRoot);
        this.validationJoinColumnReferencedColumnName(joinColumn, messages, astRoot);
    }

    protected void validateJoinColumnName(JavaJoinColumn joinColumn, List<IMessage> messages, CompilationUnit astRoot) {
        if (!joinColumn.isResolved() && joinColumn.getDbTable() != null) {
            if (joinColumn.getName() != null) {
                messages.add(DefaultJpaValidationMessages.buildMessage(1, "JOIN_COLUMN_UNRESOLVED_NAME", new String[]{joinColumn.getName()}, joinColumn, joinColumn.getNameTextRange(astRoot)));
            } else if (joinColumn.getOwner().joinColumnsSize() > 1) {
                messages.add(DefaultJpaValidationMessages.buildMessage(1, "JOIN_COLUMN_UNRESOLVED_NAME_MULTIPLE_JOIN_COLUMNS", joinColumn, joinColumn.getNameTextRange(astRoot)));
            }
        }
    }

    protected void validationJoinColumnReferencedColumnName(JavaJoinColumn joinColumn, List<IMessage> messages, CompilationUnit astRoot) {
        if (!joinColumn.isReferencedColumnResolved() && joinColumn.getReferencedColumnDbTable() != null) {
            if (joinColumn.getReferencedColumnName() != null) {
                messages.add(DefaultJpaValidationMessages.buildMessage(1, "JOIN_COLUMN_REFERENCED_COLUMN_UNRESOLVED_NAME", new String[]{joinColumn.getReferencedColumnName(), joinColumn.getName()}, joinColumn, joinColumn.getReferencedColumnNameTextRange(astRoot)));
            } else if (joinColumn.getOwner().joinColumnsSize() > 1) {
                messages.add(DefaultJpaValidationMessages.buildMessage(1, "JOIN_COLUMN_REFERENCED_COLUMN_UNRESOLVED_NAME_MULTIPLE_JOIN_COLUMNS", joinColumn, joinColumn.getReferencedColumnNameTextRange(astRoot)));
            }
        }
    }

    @Override
    public TextRange getValidationTextRange(CompilationUnit astRoot) {
        return this.getRelationshipReference().getValidationTextRange(astRoot);
    }

    public class JoinColumnOwner
    implements JavaJoinColumn.Owner {
        public String getDefaultTableName() {
            return this.getTypeMapping().getPrimaryTableName();
        }

        public Entity getTargetEntity() {
            return this.getRelationshipMapping().getResolvedTargetEntity();
        }

        public String getAttributeName() {
            return this.getRelationshipMapping().getPersistentAttribute().getName();
        }

        public RelationshipMapping getRelationshipMapping() {
            return GenericJavaJoinColumnJoiningStrategy.this.getRelationshipMapping();
        }

        public boolean tableNameIsInvalid(String tableName) {
            return this.getTypeMapping().tableNameIsInvalid(tableName);
        }

        public boolean tableIsAllowed() {
            return true;
        }

        public TypeMapping getTypeMapping() {
            return this.getRelationshipMapping().getTypeMapping();
        }

        public Table getDbTable(String tableName) {
            return this.getTypeMapping().getDbTable(tableName);
        }

        public Table getReferencedColumnDbTable() {
            Entity targetEntity = this.getTargetEntity();
            return targetEntity == null ? null : targetEntity.getPrimaryDbTable();
        }

        public boolean isVirtual(BaseJoinColumn joinColumn) {
            return GenericJavaJoinColumnJoiningStrategy.this.defaultJoinColumn == joinColumn;
        }

        public String getDefaultColumnName() {
            return null;
        }

        public TextRange getValidationTextRange(CompilationUnit astRoot) {
            return GenericJavaJoinColumnJoiningStrategy.this.getValidationTextRange(astRoot);
        }

        public int joinColumnsSize() {
            return GenericJavaJoinColumnJoiningStrategy.this.joinColumnsSize();
        }
    }
}

