/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.build.fetch;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.build.IAntScript;
import org.eclipse.pde.build.IFetchFactory;
import org.eclipse.pde.internal.build.Messages;
import org.eclipse.pde.internal.build.Utils;

public class P2IUFetchFactory
implements IFetchFactory {
    private static final String ATTRIBUTE_DESTINATION = "destination";
    private static final String ATTRIBUTE_ID = "id";
    private static final String ATTRIBUTE_SOURCE = "source";
    private static final String ATTRIBUTE_VERSION = "version";
    private static final String KEY_REPOSITORY = "repository";
    private static final String KEY_ID = "id";
    private static final String KEY_VERSION = "version";
    private static final String SEPARATOR = ",";
    private static final String TASK_IU = "iu";
    private static final String TASK_REPO2RUNNABLE = "p2.repo2runnable";

    private static void throwException(String message, Exception e) throws CoreException {
        throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.build", 0, message, (Throwable)e));
    }

    public void addTargets(IAntScript script) {
    }

    public void generateRetrieveElementCall(Map entryInfos, IPath destination, IAntScript script) {
        script.println();
        script.print("<p2.repo2runnable");
        script.printAttribute(ATTRIBUTE_DESTINATION, "${transformedRepoLocation}", true);
        script.printAttribute(ATTRIBUTE_SOURCE, (String)entryInfos.get(KEY_REPOSITORY), true);
        script.println(">");
        script.print("<");
        script.print(TASK_IU);
        script.printAttribute("id", (String)entryInfos.get("id"), true);
        script.printAttribute("version", (String)entryInfos.get("version"), true);
        script.println("/>");
        script.printEndTag(TASK_REPO2RUNNABLE);
        script.println();
    }

    public void generateRetrieveFilesCall(Map entryInfos, IPath destination, String[] files, IAntScript script) {
    }

    public void parseMapFileEntry(String rawEntry, Properties overrideTags, Map entryInfos) throws CoreException {
        String[] arguments = Utils.getArrayFromStringWithBlank(rawEntry, SEPARATOR);
        if (arguments.length < 3) {
            P2IUFetchFactory.throwException(NLS.bind((String)Messages.error_incorrectDirectoryEntry, entryInfos.get("element")), null);
        }
        HashMap<String, String> table = new HashMap<String, String>();
        int i = 0;
        while (i < arguments.length) {
            String arg = arguments[i];
            int index = arg.indexOf(61);
            if (index == -1) {
                P2IUFetchFactory.throwException(NLS.bind((String)Messages.error_incorrectDirectoryEntry, entryInfos.get("element")), null);
            }
            String key = arg.substring(0, index);
            String value = arg.substring(index + 1);
            table.put(key, value);
            ++i;
        }
        entryInfos.put("id", table.get("id"));
        entryInfos.put("version", table.get("version"));
        entryInfos.put(KEY_REPOSITORY, table.get(KEY_REPOSITORY));
    }
}

