/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.xpath2.processor.internal.function;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.ListIterator;
import org.eclipse.wst.xml.xpath2.processor.DynamicError;
import org.eclipse.wst.xml.xpath2.processor.ResultSequence;
import org.eclipse.wst.xml.xpath2.processor.ResultSequenceFactory;
import org.eclipse.wst.xml.xpath2.processor.internal.TypeError;
import org.eclipse.wst.xml.xpath2.processor.internal.function.CmpEq;
import org.eclipse.wst.xml.xpath2.processor.internal.function.FnData;
import org.eclipse.wst.xml.xpath2.processor.internal.function.Function;
import org.eclipse.wst.xml.xpath2.processor.internal.types.AnyType;
import org.eclipse.wst.xml.xpath2.processor.internal.types.NumericType;
import org.eclipse.wst.xml.xpath2.processor.internal.types.QName;
import org.eclipse.wst.xml.xpath2.processor.internal.types.UntypedAtomic;
import org.eclipse.wst.xml.xpath2.processor.internal.types.XSBoolean;
import org.eclipse.wst.xml.xpath2.processor.internal.types.XSDouble;
import org.eclipse.wst.xml.xpath2.processor.internal.types.XSString;

public class FsEq
extends Function {
    public FsEq() {
        super(new QName("eq"), 2);
    }

    public ResultSequence evaluate(Collection args) throws DynamicError {
        assert (args.size() == this.arity());
        return FsEq.fs_eq_value(args);
    }

    private static Collection value_convert_args(Collection args) throws DynamicError {
        ArrayList<ResultSequence> result = new ArrayList<ResultSequence>(args.size());
        for (ResultSequence rs : args) {
            FnData.fast_atomize(rs);
            if (rs.empty()) {
                return new ArrayList();
            }
            if (rs.size() > 1) {
                throw new DynamicError(TypeError.invalid_type(null));
            }
            AnyType arg = rs.first();
            if (arg instanceof UntypedAtomic) {
                arg = new XSString(arg.string_value());
            }
            rs = ResultSequenceFactory.create_new();
            rs.add(arg);
            result.add(rs);
        }
        return result;
    }

    public static ResultSequence fs_eq_value(Collection args) throws DynamicError {
        return FsEq.do_cmp_value_op(args, CmpEq.class, "eq");
    }

    public static boolean fs_eq_fast(AnyType one, AnyType two) throws DynamicError {
        one = FnData.atomize(one);
        two = FnData.atomize(two);
        if (one instanceof UntypedAtomic) {
            one = new XSString(one.string_value());
        }
        if (two instanceof UntypedAtomic) {
            two = new XSString(two.string_value());
        }
        if (!(one instanceof CmpEq)) {
            DynamicError.throw_type_error();
        }
        CmpEq cmpone = (CmpEq)((Object)one);
        return cmpone.eq(two);
    }

    private static boolean do_general_pair(AnyType a, AnyType b, Method comparator) throws DynamicError {
        ResultSequence converted;
        if (a instanceof UntypedAtomic && b instanceof NumericType || b instanceof UntypedAtomic && a instanceof NumericType) {
            if (a instanceof UntypedAtomic) {
                a = new XSDouble(a.string_value());
            } else {
                b = new XSDouble(b.string_value());
            }
        } else if (a instanceof UntypedAtomic && (b instanceof XSString || b instanceof UntypedAtomic) || b instanceof UntypedAtomic && (a instanceof XSString || a instanceof UntypedAtomic)) {
            if (a instanceof UntypedAtomic) {
                a = new XSString(a.string_value());
            }
            if (b instanceof UntypedAtomic) {
                b = new XSString(a.string_value());
            }
        } else if (a instanceof UntypedAtomic) {
            converted = ResultSequenceFactory.create_new(a);
            assert (converted.size() == 1);
            a = converted.first();
        } else if (b instanceof UntypedAtomic) {
            converted = ResultSequenceFactory.create_new(b);
            assert (converted.size() == 1);
            b = converted.first();
        }
        ResultSequence one = ResultSequenceFactory.create_new(a);
        ResultSequence two = ResultSequenceFactory.create_new(b);
        ArrayList<ResultSequence> args = new ArrayList<ResultSequence>();
        args.add(one);
        args.add(two);
        Object[] margs = new Object[]{args};
        ResultSequence result = null;
        try {
            result = (ResultSequence)comparator.invoke(null, margs);
        }
        catch (IllegalAccessException illegalAccessException) {
            assert (false);
        }
        catch (InvocationTargetException err) {
            Throwable ex = err.getTargetException();
            if (ex instanceof DynamicError) {
                throw (DynamicError)ex;
            }
            ex.printStackTrace();
            System.exit(1);
        }
        return ((XSBoolean)result.first()).value();
    }

    public static ResultSequence fs_eq_general(Collection args) throws DynamicError {
        return FsEq.do_cmp_general_op(args, FsEq.class, "fs_eq_value");
    }

    public static ResultSequence do_cmp_general_op(Collection args, Class type, String mname) throws DynamicError {
        Method comparator;
        block6: {
            comparator = null;
            try {
                Class[] margsdef = new Class[]{Collection.class};
                comparator = type.getMethod(mname, margsdef);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                if ($assertionsDisabled) break block6;
                throw new AssertionError();
            }
        }
        if (args.size() != 2) {
            DynamicError.throw_type_error();
        }
        Iterator argiter = args.iterator();
        ResultSequence one = (ResultSequence)argiter.next();
        ResultSequence two = (ResultSequence)argiter.next();
        if (one.empty() || two.empty()) {
            return ResultSequenceFactory.create_new(new XSBoolean(false));
        }
        one = FnData.atomize(one);
        two = FnData.atomize(two);
        ListIterator i = one.iterator();
        while (i.hasNext()) {
            ListIterator j = two.iterator();
            while (j.hasNext()) {
                AnyType b;
                AnyType a = (AnyType)i.next();
                if (!FsEq.do_general_pair(a, b = (AnyType)j.next(), comparator)) continue;
                return ResultSequenceFactory.create_new(new XSBoolean(true));
            }
        }
        return ResultSequenceFactory.create_new(new XSBoolean(false));
    }

    public static ResultSequence do_cmp_value_op(Collection args, Class type, String mname) throws DynamicError {
        if (args.size() != 2) {
            DynamicError.throw_type_error();
        }
        Collection cargs = FsEq.value_convert_args(args);
        ResultSequence result = ResultSequenceFactory.create_new();
        if (cargs.size() == 0) {
            return result;
        }
        Iterator argi = cargs.iterator();
        AnyType arg = ((ResultSequence)argi.next()).first();
        ResultSequence arg2 = (ResultSequence)argi.next();
        if (arg2.size() != 1) {
            DynamicError.throw_type_error();
        }
        if (!type.isInstance(arg)) {
            DynamicError.throw_type_error();
        }
        try {
            Class[] margsdef = new Class[]{AnyType.class};
            Method method = null;
            method = type.getMethod(mname, margsdef);
            Object[] margs = new Object[]{arg2.first()};
            Boolean cmpres = (Boolean)method.invoke((Object)arg, margs);
            return ResultSequenceFactory.create_new(new XSBoolean(cmpres));
        }
        catch (NoSuchMethodException noSuchMethodException) {
            assert (false);
        }
        catch (IllegalAccessException illegalAccessException) {
            assert (false);
        }
        catch (InvocationTargetException err) {
            Throwable ex = err.getTargetException();
            if (ex instanceof DynamicError) {
                throw (DynamicError)ex;
            }
            ex.printStackTrace();
            System.exit(1);
        }
        return null;
    }
}

