/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.xpath2.processor.internal.function;

import java.util.Collection;
import org.eclipse.wst.xml.xpath2.processor.ResultSequence;
import org.eclipse.wst.xml.xpath2.processor.ResultSequenceFactory;
import org.eclipse.wst.xml.xpath2.processor.internal.function.Function;
import org.eclipse.wst.xml.xpath2.processor.internal.types.AnyAtomicType;
import org.eclipse.wst.xml.xpath2.processor.internal.types.AnyType;
import org.eclipse.wst.xml.xpath2.processor.internal.types.NumericType;
import org.eclipse.wst.xml.xpath2.processor.internal.types.QName;
import org.eclipse.wst.xml.xpath2.processor.internal.types.UntypedAtomic;
import org.eclipse.wst.xml.xpath2.processor.internal.types.XSBoolean;
import org.eclipse.wst.xml.xpath2.processor.internal.types.XSDouble;
import org.eclipse.wst.xml.xpath2.processor.internal.types.XSFloat;
import org.eclipse.wst.xml.xpath2.processor.internal.types.XSString;

public class FnBoolean
extends Function {
    public FnBoolean() {
        super(new QName("boolean"), 1);
    }

    public ResultSequence evaluate(Collection args) {
        assert (args.size() == this.arity());
        ResultSequence argument = (ResultSequence)args.iterator().next();
        return FnBoolean.fn_boolean(argument);
    }

    private static ResultSequence make_sequence(boolean val) {
        ResultSequence rs = ResultSequenceFactory.create_new();
        rs.add(new XSBoolean(val));
        return rs;
    }

    private static ResultSequence make_true() {
        return FnBoolean.make_sequence(true);
    }

    private static ResultSequence make_false() {
        return FnBoolean.make_sequence(false);
    }

    public static ResultSequence fn_boolean(ResultSequence arg) {
        if (arg.empty()) {
            return FnBoolean.make_false();
        }
        if (arg.size() > 1) {
            return FnBoolean.make_true();
        }
        AnyType at = arg.first();
        if (!(at instanceof AnyAtomicType)) {
            return FnBoolean.make_true();
        }
        if (at instanceof XSBoolean && !((XSBoolean)at).value()) {
            return FnBoolean.make_false();
        }
        if ((at instanceof XSString || at instanceof UntypedAtomic) && at.string_value().equals("")) {
            return FnBoolean.make_false();
        }
        if (at instanceof NumericType && ((NumericType)at).zero()) {
            return FnBoolean.make_false();
        }
        if (at instanceof XSFloat && ((XSFloat)at).nan()) {
            return FnBoolean.make_false();
        }
        if (at instanceof XSDouble && ((XSDouble)at).nan()) {
            return FnBoolean.make_false();
        }
        return FnBoolean.make_true();
    }
}

