/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.xpath2.processor;

import org.eclipse.wst.xml.xpath2.processor.XPathException;
import org.eclipse.wst.xml.xpath2.processor.internal.TypeError;

public class DynamicError
extends XPathException {
    private static final long serialVersionUID = -6146830764753685791L;
    private String _code;
    private TypeError _te;

    public DynamicError(String code, String err) {
        super(err);
        this._code = code;
        this._te = null;
    }

    public DynamicError(TypeError te) {
        super(te.reason());
        this._te = te;
    }

    public String code() {
        if (this._te != null) {
            return this._te.code();
        }
        return this._code;
    }

    public static DynamicError cant_cast(String err) {
        String error = "Can't cast to required type.";
        if (err != null) {
            error = String.valueOf(error) + " " + err;
        }
        return new DynamicError("XPDY0021", error);
    }

    public static DynamicError throw_type_error() throws DynamicError {
        throw new DynamicError(TypeError.invalid_type(null));
    }

    public static DynamicError user_error(String err) {
        String error = "Error reported by user.";
        if (err != null) {
            error = String.valueOf(error) + " " + err;
        }
        return new DynamicError("FOER0000", error);
    }

    public static DynamicError regex_error(String err) {
        String error = "Invalid regular expression.";
        if (err != null) {
            error = String.valueOf(error) + " " + err;
        }
        return new DynamicError("FORX0002", error);
    }

    private static DynamicError make_error(String code, String err, String msg) {
        String error = err;
        if (msg != null) {
            error = String.valueOf(error) + msg;
        }
        return new DynamicError(code, error);
    }

    public static DynamicError lexical_error(String msg) {
        return DynamicError.make_error("FOCA0002", "Invalid lexical value.", msg);
    }

    public static DynamicError not_cmp(String msg) {
        return DynamicError.make_error("FOTY0012", "Items not comparable", msg);
    }

    public static DynamicError more_one_item(String msg) {
        return DynamicError.make_error("FORG0003", "fn:zero-or-one called with a sequence containing more than one item", msg);
    }

    public static DynamicError empty_seq(String msg) {
        return DynamicError.make_error("FORG0004", "fn:one-or-more called with a sequence containing no items", msg);
    }

    public static DynamicError not_one(String msg) {
        return DynamicError.make_error("FORG0005", "fn:exactly-one called with a sequence containing zero or more than one item", msg);
    }

    public static DynamicError invalid_doc(String msg) {
        return DynamicError.make_error("FODC0005", "Invalid argument to fn:doc", msg);
    }

    public static DynamicError div_zero(String msg) {
        return DynamicError.make_error("FOAR0001", "Division by zero", msg);
    }
}

