/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.ds;

import org.eclipse.equinox.internal.ds.Activator;
import org.eclipse.equinox.internal.ds.InstanceProcess;
import org.eclipse.equinox.internal.ds.Messages;
import org.eclipse.equinox.internal.ds.impl.ComponentInstanceImpl;
import org.eclipse.equinox.internal.ds.model.ServiceComponentProp;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.Bundle;
import org.osgi.framework.ServiceFactory;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.ComponentException;

final class ServiceReg
implements ServiceFactory {
    static boolean dontDisposeInstances = true;
    private int useCount = 0;
    private ComponentInstanceImpl instance;
    private ServiceComponentProp scp;

    static {
        String tmp = Activator.bc.getProperty("equinox.scr.dontDisposeInstances");
        dontDisposeInstances = tmp != null ? !tmp.equalsIgnoreCase("false") : true;
    }

    ServiceReg(ServiceComponentProp scp, ComponentInstanceImpl instance) {
        this.scp = scp;
        this.instance = instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getService(Bundle bundle, ServiceRegistration registration) {
        block8: {
            try {
                if (this.instance != null) break block8;
                this.instance = InstanceProcess.staticRef.buildComponent(bundle, this.scp, null, false);
                if (this.instance != null) break block8;
                return null;
            }
            catch (Exception e) {
                if (!(e instanceof ComponentException)) {
                    Activator.log.error(NLS.bind((String)Messages.CANNOT_CREATE_INSTANCE, (Object)this.scp.name), (Throwable)e);
                    return null;
                }
                throw (ComponentException)((Object)e);
            }
        }
        ServiceReg serviceReg = this;
        synchronized (serviceReg) {
            ++this.useCount;
        }
        if (Activator.DEBUG) {
            Activator.log.debug("ServiceReg.getService(): " + NLS.bind((String)Messages.SERVICE_USAGE_COUNT, (Object)this.scp.name, (Object)Integer.toString(this.useCount)) + ", object = " + this.instance.getInstance(), null);
        }
        return this.instance.getInstance();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ungetService(Bundle bundle, ServiceRegistration registration, Object service) {
        boolean shallDispose = false;
        ServiceReg serviceReg = this;
        synchronized (serviceReg) {
            --this.useCount;
            if (this.useCount == 0) {
                shallDispose = true;
            }
        }
        if (shallDispose) {
            if (!dontDisposeInstances && !this.scp.serviceComponent.immediate) {
                if (Activator.DEBUG) {
                    Activator.log.debug(NLS.bind((String)Messages.SERVICE_NO_LONGER_USED, (Object)this.scp.name, (Object)service), null);
                }
                this.scp.disposeObj(service, 0);
                this.instance = null;
            } else if (Activator.DEBUG) {
                Activator.log.debug("ServiceReg.ungetService(): " + NLS.bind((String)Messages.SERVICE_USAGE_COUNT, (Object)this.scp.name, (Object)Integer.toString(this.useCount)), null);
            }
        } else if (this.useCount < 0) {
            Activator.log.warning("ServiceReg.ungetService(): " + NLS.bind((String)Messages.SERVICE_USAGE_COUNT, (Object)this.scp.name, (Object)Integer.toString(this.useCount)), (Throwable)new Exception("Debug callstack"));
        } else if (Activator.DEBUG) {
            Activator.log.debug("ServiceReg.ungetService(): " + NLS.bind((String)Messages.SERVICE_USAGE_COUNT, (Object)this.scp.name, (Object)Integer.toString(this.useCount)), null);
        }
    }

    public String toString() {
        return String.valueOf(this.scp.name) + " Service Registration";
    }
}

