/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.java;

import java.util.Collection;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.jdt.internal.corext.codemanipulation.CodeGenerationSettings;
import org.eclipse.jdt.internal.corext.codemanipulation.GetterSetterUtil;
import org.eclipse.jdt.internal.corext.util.CodeFormatterUtil;
import org.eclipse.jdt.internal.corext.util.JdtFlags;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.corext.util.Strings;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.preferences.JavaPreferencesSettings;
import org.eclipse.jdt.internal.ui.text.java.JavaTextMessages;
import org.eclipse.jdt.internal.ui.text.java.JavaTypeCompletionProposal;
import org.eclipse.jdt.internal.ui.text.java.ProposalInfo;
import org.eclipse.jdt.internal.ui.viewsupport.BasicElementLabels;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension4;
import org.eclipse.jface.viewers.StyledString;

public class GetterSetterCompletionProposal
extends JavaTypeCompletionProposal
implements ICompletionProposalExtension4 {
    private final IField fField;
    private final boolean fIsGetter;

    public static void evaluateProposals(IType type, String prefix, int offset, int length, int relevance, Set suggestedMethods, Collection result) throws CoreException {
        if (prefix.length() == 0) {
            --relevance;
        }
        IField[] fields = type.getFields();
        IMethod[] methods = type.getMethods();
        int i = 0;
        while (i < fields.length) {
            IField curr = fields[i];
            if (!JdtFlags.isEnum((IMember)curr)) {
                String setterName;
                String getterName = GetterSetterUtil.getGetterName(curr, null);
                if (Strings.startsWithIgnoreCase(getterName, prefix) && !GetterSetterCompletionProposal.hasMethod(methods, getterName) && suggestedMethods.add(getterName)) {
                    result.add(new GetterSetterCompletionProposal(curr, offset, length, true, relevance));
                }
                if (Strings.startsWithIgnoreCase(setterName = GetterSetterUtil.getSetterName(curr, null), prefix) && !GetterSetterCompletionProposal.hasMethod(methods, setterName) && suggestedMethods.add(setterName)) {
                    result.add(new GetterSetterCompletionProposal(curr, offset, length, false, relevance));
                }
            }
            ++i;
        }
    }

    private static boolean hasMethod(IMethod[] methods, String name) {
        int i = 0;
        while (i < methods.length) {
            if (methods[i].getElementName().equals(name)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public GetterSetterCompletionProposal(IField field, int start, int length, boolean isGetter, int relevance) throws JavaModelException {
        super("", field.getCompilationUnit(), start, length, JavaPluginImages.get("org.eclipse.jdt.ui.methpub_obj.gif"), GetterSetterCompletionProposal.getDisplayName(field, isGetter), relevance);
        Assert.isNotNull((Object)field);
        this.fField = field;
        this.fIsGetter = isGetter;
        this.setProposalInfo(new ProposalInfo((IMember)field));
    }

    private static StyledString getDisplayName(IField field, boolean isGetter) throws JavaModelException {
        StyledString buf = new StyledString();
        String fieldTypeName = Signature.toString((String)field.getTypeSignature());
        String fieldNameLabel = BasicElementLabels.getJavaElementName(field.getElementName());
        if (isGetter) {
            buf.append(BasicElementLabels.getJavaElementName(String.valueOf(GetterSetterUtil.getGetterName(field, null)) + "() : " + fieldTypeName));
            buf.append(" - ", StyledString.QUALIFIER_STYLER);
            buf.append(Messages.format(JavaTextMessages.GetterSetterCompletionProposal_getter_label, fieldNameLabel), StyledString.QUALIFIER_STYLER);
        } else {
            buf.append(BasicElementLabels.getJavaElementName(String.valueOf(GetterSetterUtil.getSetterName(field, null)) + '(' + fieldTypeName + ") : void"));
            buf.append(" - ", StyledString.QUALIFIER_STYLER);
            buf.append(Messages.format(JavaTextMessages.GetterSetterCompletionProposal_setter_label, fieldNameLabel), StyledString.QUALIFIER_STYLER);
        }
        return buf;
    }

    protected boolean updateReplacementString(IDocument document, char trigger, int offset, ImportRewrite impRewrite) throws CoreException, BadLocationException {
        String stub;
        CodeGenerationSettings settings = JavaPreferencesSettings.getCodeGenerationSettings(this.fField.getJavaProject());
        boolean addComments = settings.createComments;
        int flags = 1 | this.fField.getFlags() & 8;
        if (this.fIsGetter) {
            String getterName = GetterSetterUtil.getGetterName(this.fField, null);
            stub = GetterSetterUtil.getGetterStub(this.fField, getterName, addComments, flags);
        } else {
            String setterName = GetterSetterUtil.getSetterName(this.fField, null);
            stub = GetterSetterUtil.getSetterStub(this.fField, setterName, addComments, flags);
        }
        String lineDelim = TextUtilities.getDefaultLineDelimiter((IDocument)document);
        IRegion region = document.getLineInformationOfOffset(this.getReplacementOffset());
        int lineStart = region.getOffset();
        int indent = Strings.computeIndentUnits(document.get(lineStart, this.getReplacementOffset() - lineStart), settings.tabWidth, settings.indentWidth);
        String replacement = CodeFormatterUtil.format(4, stub, indent, lineDelim, this.fField.getJavaProject());
        if (replacement.endsWith(lineDelim)) {
            replacement = replacement.substring(0, replacement.length() - lineDelim.length());
        }
        this.setReplacementString(Strings.trimLeadingTabsAndSpaces(replacement));
        return true;
    }

    public boolean isAutoInsertable() {
        return false;
    }
}

