/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.preferences.cleanup;

import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jdt.internal.ui.preferences.cleanup.CleanUpPreview;
import org.eclipse.jdt.internal.ui.preferences.formatter.JavaPreview;
import org.eclipse.jdt.internal.ui.preferences.formatter.ModifyDialogTabPage;
import org.eclipse.jdt.ui.cleanup.ICleanUpConfigurationUI;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;

public abstract class CleanUpTabPage
extends ModifyDialogTabPage
implements ICleanUpConfigurationUI {
    private Map fValues;
    private JavaPreview fCleanUpPreview;
    private boolean fIsSaveAction;
    private int fCount = 0;
    private int fSelectedCount;

    public CleanUpTabPage() {
        this.setSelectedCleanUpCount(0);
        this.fIsSaveAction = false;
    }

    public void setOptionsKind(int kind) {
        this.fIsSaveAction = kind == 2;
    }

    public void setWorkingValues(Map workingValues) {
        super.setWorkingValues(workingValues);
        this.fValues = workingValues;
    }

    public boolean isSaveAction() {
        return this.fIsSaveAction;
    }

    public int getCleanUpCount() {
        return this.fCount;
    }

    public int getSelectedCleanUpCount() {
        return this.fSelectedCount;
    }

    private void setSelectedCleanUpCount(int selectedCount) {
        Assert.isLegal((selectedCount >= 0 && selectedCount <= this.fCount ? 1 : 0) != 0);
        this.fSelectedCount = selectedCount;
    }

    protected JavaPreview doCreateJavaPreview(Composite parent) {
        this.fCleanUpPreview = new CleanUpPreview(parent, this);
        return this.fCleanUpPreview;
    }

    protected void doUpdatePreview() {
        this.fCleanUpPreview.setWorkingValues(this.fValues);
        this.fCleanUpPreview.update();
    }

    protected void initializePage() {
        this.fCleanUpPreview.update();
    }

    protected void registerPreference(final ModifyDialogTabPage.CheckboxPreference preference) {
        ++this.fCount;
        preference.addObserver(new Observer(){

            public void update(Observable o, Object arg) {
                if (preference.getChecked()) {
                    CleanUpTabPage.this.setSelectedCleanUpCount(CleanUpTabPage.this.fSelectedCount + 1);
                } else {
                    CleanUpTabPage.this.setSelectedCleanUpCount(CleanUpTabPage.this.fSelectedCount - 1);
                }
            }
        });
        if (preference.getChecked()) {
            this.setSelectedCleanUpCount(this.fSelectedCount + 1);
        }
    }

    protected void registerSlavePreference(ModifyDialogTabPage.CheckboxPreference master, ModifyDialogTabPage.RadioPreference[] slaves) {
        this.internalRegisterSlavePreference(master, slaves);
        this.registerPreference(master);
    }

    protected void registerSlavePreference(final ModifyDialogTabPage.CheckboxPreference master, final ModifyDialogTabPage.CheckboxPreference[] slaves) {
        this.internalRegisterSlavePreference(master, slaves);
        this.fCount += slaves.length;
        master.addObserver(new Observer(){

            public void update(Observable o, Object arg) {
                if (master.getChecked()) {
                    int i = 0;
                    while (i < slaves.length) {
                        if (slaves[i].getChecked()) {
                            CleanUpTabPage.this.setSelectedCleanUpCount(CleanUpTabPage.this.fSelectedCount + 1);
                        }
                        ++i;
                    }
                } else {
                    int i = 0;
                    while (i < slaves.length) {
                        if (slaves[i].getChecked()) {
                            CleanUpTabPage.this.setSelectedCleanUpCount(CleanUpTabPage.this.fSelectedCount - 1);
                        }
                        ++i;
                    }
                }
            }
        });
        int i = 0;
        while (i < slaves.length) {
            final ModifyDialogTabPage.CheckboxPreference slave = slaves[i];
            slave.addObserver(new Observer(){

                public void update(Observable o, Object arg) {
                    if (slave.getChecked()) {
                        CleanUpTabPage.this.setSelectedCleanUpCount(CleanUpTabPage.this.fSelectedCount + 1);
                    } else {
                        CleanUpTabPage.this.setSelectedCleanUpCount(CleanUpTabPage.this.fSelectedCount - 1);
                    }
                }
            });
            ++i;
        }
        if (master.getChecked()) {
            i = 0;
            while (i < slaves.length) {
                if (slaves[i].getChecked()) {
                    this.setSelectedCleanUpCount(this.fSelectedCount + 1);
                }
                ++i;
            }
        }
    }

    private void internalRegisterSlavePreference(final ModifyDialogTabPage.CheckboxPreference master, final ModifyDialogTabPage.ButtonPreference[] slaves) {
        master.addObserver(new Observer(){

            public void update(Observable o, Object arg) {
                int i = 0;
                while (i < slaves.length) {
                    slaves[i].setEnabled(master.getChecked());
                    ++i;
                }
            }
        });
        int i = 0;
        while (i < slaves.length) {
            slaves[i].setEnabled(master.getChecked());
            ++i;
        }
    }

    protected void intent(Composite group) {
        Label l = new Label(group, 0);
        GridData gd = new GridData();
        gd.widthHint = this.fPixelConverter.convertWidthInCharsToPixels(4);
        l.setLayoutData((Object)gd);
    }
}

