/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.ui.sdk.scheduler;

import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.AbstractPreferenceInitializer;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.equinox.internal.p2.ui.sdk.scheduler.AutomaticUpdateMessages;
import org.eclipse.equinox.internal.provisional.p2.engine.ProfileScope;
import org.eclipse.equinox.internal.provisional.p2.ui.ProvUI;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

public class PreferenceInitializer
extends AbstractPreferenceInitializer {
    private static final String P_ENABLED = "enabled";
    private static final String UPDATE_PLUGIN_ID = "org.eclipse.update.scheduler";
    private static final String SDK_UI_PLUGIN_ID = "org.eclipse.equinox.p2.ui.sdk";

    public static void migratePreferences() {
        IEclipsePreferences pref = new ProfileScope("_SELF_").getNode("org.eclipse.equinox.p2.ui.sdk.scheduler");
        try {
            if (pref.keys().length == 0) {
                IEclipsePreferences oldPref = new InstanceScope().getNode("org.eclipse.equinox.p2.ui.sdk.scheduler");
                String[] keys = oldPref.keys();
                int i = 0;
                while (i < keys.length) {
                    pref.put(keys[i], oldPref.get(keys[i], ""));
                    ++i;
                }
                if (keys.length > 0) {
                    pref.flush();
                }
            }
        }
        catch (BackingStoreException e) {
            ProvUI.handleException((Throwable)e, (String)AutomaticUpdateMessages.ErrorLoadingPreferenceKeys, (int)1);
        }
        boolean migrated34 = pref.getBoolean("migrated34Prefs", false);
        boolean node34exists = false;
        if (!migrated34) {
            Preferences instanceScope = Platform.getPreferencesService().getRootNode().node("instance");
            try {
                node34exists = instanceScope.nodeExists(SDK_UI_PLUGIN_ID);
            }
            catch (BackingStoreException backingStoreException) {}
            if (node34exists) {
                Preferences node34 = instanceScope.node(SDK_UI_PLUGIN_ID);
                if (node34.get(P_ENABLED, null) == null) {
                    pref.putBoolean(P_ENABLED, node34.getBoolean(P_ENABLED, false));
                }
                if (node34.get("schedule", null) == null) {
                    pref.put("schedule", node34.get("schedule", "on-startup"));
                }
                if (node34.get("download", null) == null) {
                    pref.putBoolean("download", node34.getBoolean("download", false));
                }
                if (node34.get("remindOnSchedule", null) == null) {
                    pref.putBoolean("remindOnSchedule", node34.getBoolean("remindOnSchedule", false));
                }
                if (node34.get("remindElapsedTime", null) == null) {
                    pref.put("remindElapsedTime", node34.get("remindElapsedTime", AutomaticUpdateMessages.AutomaticUpdateScheduler_30Minutes));
                }
            }
            pref.putBoolean("migrated34Prefs", true);
            try {
                pref.flush();
            }
            catch (BackingStoreException e) {
                ProvUI.handleException((Throwable)e, (String)AutomaticUpdateMessages.ErrorSavingPreferences, (int)1);
            }
        }
        boolean autoUpdateInit = pref.getBoolean("autoUpdateInit", false);
        if (!migrated34 && !autoUpdateInit) {
            Preferences instanceScope = Platform.getPreferencesService().getRootNode().node("instance");
            try {
                boolean updateNodeExists = instanceScope.nodeExists(UPDATE_PLUGIN_ID);
                Preferences prefUM = instanceScope.node(UPDATE_PLUGIN_ID);
                boolean enableUpdate = prefUM.getBoolean(P_ENABLED, false);
                if (pref.get(P_ENABLED, null) == null) {
                    pref.putBoolean(P_ENABLED, enableUpdate);
                }
                if (updateNodeExists) {
                    prefUM.putBoolean(P_ENABLED, false);
                    prefUM.flush();
                }
                pref.putBoolean("autoUpdateInit", true);
                pref.flush();
            }
            catch (BackingStoreException e) {
                ProvUI.handleException((Throwable)e, (String)AutomaticUpdateMessages.ErrorSavingClassicPreferences, (int)1);
            }
        }
    }

    public void initializeDefaultPreferences() {
        IEclipsePreferences node = new DefaultScope().getNode("org.eclipse.equinox.p2.ui.sdk.scheduler");
        node.putBoolean(P_ENABLED, false);
        node.put("schedule", "on-startup");
        node.putBoolean("download", false);
        node.putBoolean("remindOnSchedule", false);
        node.put("remindElapsedTime", AutomaticUpdateMessages.AutomaticUpdateScheduler_30Minutes);
    }
}

