/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.result.internal.ui.export;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.datatools.sqltools.result.IResultSetObject;
import org.eclipse.datatools.sqltools.result.XMLResultSetObject;
import org.eclipse.datatools.sqltools.result.internal.export.IOutputterDescriptor;
import org.eclipse.datatools.sqltools.result.internal.export.OutputterRegistryReader;
import org.eclipse.datatools.sqltools.result.internal.ui.Messages;
import org.eclipse.datatools.sqltools.result.internal.ui.export.ResourceAndContainerGroup;
import org.eclipse.datatools.sqltools.result.internal.ui.export.component.EncodingDelimiterOptionsSection;
import org.eclipse.datatools.sqltools.result.model.IResultInstance;
import org.eclipse.datatools.sqltools.result.model.ResultItem;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;

public class SaveResultGroup
extends ResourceAndContainerGroup {
    private Combo _resourceTypeField;
    private Composite _typeGroup;
    private EncodingDelimiterOptionsSection _options;
    private boolean _isXMLResult = false;

    public SaveResultGroup(Composite parent, Listener client, String resourceFieldLabel, String resourceType, IResultSetObject resultset, Listener listener) {
        super(parent, client, resourceFieldLabel, resourceType, listener);
        this._isXMLResult = resultset != null && resultset instanceof XMLResultSetObject;
        this._resourceTypeField.setItems(OutputterRegistryReader.getInstance().getOutputterDspStrings(this._isXMLResult));
        this._resourceTypeField.select(0);
    }

    public SaveResultGroup(Composite parent, Listener client, String resourceFieldLabel, String resourceType, IResultInstance resultInstance, Listener listener) {
        super(parent, client, resourceFieldLabel, resourceType, listener);
        int i = 0;
        while (i < resultInstance.getItemCount()) {
            IResultSetObject rs;
            ResultItem ri = resultInstance.getItem(i);
            if (ri != null && ri.getResultObject() instanceof IResultSetObject && (rs = (IResultSetObject)ri.getResultObject()) instanceof XMLResultSetObject) {
                this._isXMLResult = true;
            }
            ++i;
        }
        this._resourceTypeField.setItems(OutputterRegistryReader.getInstance().getOutputterDspStrings(this._isXMLResult));
        this._resourceTypeField.select(0);
    }

    protected void createExtraContents(Composite composite, GridLayout layout, Font font, GridData data) {
        super.createExtraContents(composite, layout, font, data);
        this._typeGroup = new Composite(composite, 0);
        layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginWidth = 0;
        this._typeGroup.setLayout((Layout)layout);
        this._typeGroup.setLayoutData((Object)new GridData(768));
        this._typeGroup.setFont(font);
        Label typeLabel = new Label(this._typeGroup, 0);
        typeLabel.setText(Messages.SaveResultSetDialog_filetype_label);
        typeLabel.setFont(font);
        this._resourceTypeField = new Combo(this._typeGroup, 8);
        this._resourceTypeField.setLayoutData((Object)data);
        this._resourceTypeField.setFont(font);
        this._resourceTypeField.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SaveResultGroup.this.resourceTypeFieldSelected();
            }
        });
        this._resourceTypeField.select(0);
        this._options = new EncodingDelimiterOptionsSection(this._typeGroup, 2, this._listener);
    }

    private void resourceTypeFieldSelected() {
        String value = this.getResource();
        if (value != null && !"".equals(value.trim())) {
            String name = value;
            int sep = value.lastIndexOf(".");
            if (sep > 0) {
                name = value.substring(0, sep);
            }
            int selIndex = this._resourceTypeField.getSelectionIndex();
            value = String.valueOf(name) + "." + OutputterRegistryReader.getInstance().getOutputterDesciptor(this._isXMLResult, selIndex).getFileExtension();
            this._options.setSupportDelimiter(OutputterRegistryReader.getInstance().getOutputterDesciptor(this._isXMLResult, selIndex).supportDelimiter());
            this._options.updateOptionsSection();
            this.setResource(value);
        }
    }

    public String getDelimiter() {
        return this._options.getDelimiter();
    }

    public String getUserDefinedDelimiter() {
        return this._options.getUserDefinedDelimiter();
    }

    public String getEncoding() {
        return this._options.getEncoding();
    }

    public void disableDelimiters() {
        this._options.updateXMLExportControls();
    }

    public Combo getResourceTypeField() {
        return this._resourceTypeField;
    }

    public IStatus getStatus() {
        return this._options.getStatus();
    }

    public boolean isXMLResult() {
        return this._isXMLResult;
    }

    public IOutputterDescriptor getOutputterDesp() {
        return OutputterRegistryReader.getInstance().getOutputterDesciptor(this._isXMLResult, this._resourceTypeField.getSelectionIndex());
    }
}

