/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.ui.actions;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.jsdt.core.IField;
import org.eclipse.wst.jsdt.core.IFunction;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.IMember;
import org.eclipse.wst.jsdt.core.ISourceRange;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.core.Signature;
import org.eclipse.wst.jsdt.core.dom.PrimitiveType;
import org.eclipse.wst.jsdt.internal.corext.refactoring.RefactoringAvailabilityTester;
import org.eclipse.wst.jsdt.internal.corext.refactoring.RefactoringExecutionStarter;
import org.eclipse.wst.jsdt.internal.corext.util.JavaModelUtil;
import org.eclipse.wst.jsdt.internal.corext.util.JdtFlags;
import org.eclipse.wst.jsdt.internal.ui.JavaScriptPlugin;
import org.eclipse.wst.jsdt.internal.ui.actions.ActionUtil;
import org.eclipse.wst.jsdt.internal.ui.actions.SelectionConverter;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.JavaTextSelection;
import org.eclipse.wst.jsdt.internal.ui.refactoring.RefactoringMessages;
import org.eclipse.wst.jsdt.internal.ui.util.ExceptionHandler;
import org.eclipse.wst.jsdt.ui.actions.SelectionDispatchAction;

public class ChangeTypeAction
extends SelectionDispatchAction {
    private JavaEditor fEditor;

    public ChangeTypeAction(JavaEditor editor) {
        this((IWorkbenchSite)editor.getEditorSite());
        this.fEditor = editor;
        this.setEnabled(SelectionConverter.getInputAsCompilationUnit(this.fEditor) != null);
    }

    public ChangeTypeAction(IWorkbenchSite site) {
        super(site);
        this.setText(RefactoringMessages.ChangeTypeAction_label);
        this.setToolTipText(RefactoringMessages.ChangeTypeAction_tooltipText);
        this.setDescription(RefactoringMessages.ChangeTypeAction_description);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.wst.jsdt.ui.change_type_action");
    }

    public void selectionChanged(IStructuredSelection selection) {
        try {
            this.setEnabled(RefactoringAvailabilityTester.isGeneralizeTypeAvailable(selection));
        }
        catch (JavaScriptModelException e) {
            if (JavaModelUtil.isExceptionToBeLogged((CoreException)((Object)e))) {
                JavaScriptPlugin.log(e);
            }
            this.setEnabled(false);
        }
    }

    public void run(IStructuredSelection selection) {
        try {
            IMember member = ChangeTypeAction.getMember(selection);
            if (member == null || !ActionUtil.isEditable(this.getShell(), (IJavaScriptElement)member)) {
                return;
            }
            ISourceRange range = member.getNameRange();
            RefactoringExecutionStarter.startChangeTypeRefactoring(member.getJavaScriptUnit(), this.getShell(), range.getOffset(), range.getLength());
        }
        catch (CoreException e) {
            ExceptionHandler.handle(e, RefactoringMessages.ChangeTypeAction_dialog_title, RefactoringMessages.ChangeTypeAction_exception);
        }
    }

    private static IMember getMember(IStructuredSelection selection) throws JavaScriptModelException {
        if (selection.size() != 1) {
            return null;
        }
        Object element = selection.getFirstElement();
        if (!(element instanceof IMember)) {
            return null;
        }
        if (element instanceof IFunction) {
            IFunction method = (IFunction)element;
            String returnType = method.getReturnType();
            if (PrimitiveType.toCode((String)Signature.toString((String)returnType)) != null) {
                return null;
            }
            return method;
        }
        if (element instanceof IField && !JdtFlags.isEnum((IMember)element)) {
            return (IField)element;
        }
        return null;
    }

    public void selectionChanged(ITextSelection selection) {
        this.setEnabled(true);
    }

    public void selectionChanged(JavaTextSelection selection) {
        try {
            this.setEnabled(RefactoringAvailabilityTester.isGeneralizeTypeAvailable(selection));
        }
        catch (JavaScriptModelException javaScriptModelException) {
            this.setEnabled(false);
        }
    }

    public void run(ITextSelection selection) {
        if (!ActionUtil.isEditable(this.fEditor)) {
            return;
        }
        try {
            RefactoringExecutionStarter.startChangeTypeRefactoring(SelectionConverter.getInputAsCompilationUnit(this.fEditor), this.getShell(), selection.getOffset(), selection.getLength());
        }
        catch (CoreException e) {
            ExceptionHandler.handle(e, RefactoringMessages.ChangeTypeAction_dialog_title, RefactoringMessages.ChangeTypeAction_exception);
        }
    }
}

