/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.oda.design.internal.ui.profile.db;

import java.util.Properties;
import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.datatools.connectivity.oda.design.internal.ui.profile.db.DbProfilePageWrapper;
import org.eclipse.datatools.connectivity.oda.design.ui.wizards.DataSourceWizardPage;
import org.eclipse.datatools.connectivity.ui.wizards.ProfilePropertyPage;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.widgets.Composite;

public class DbProfileWizardPage
extends DataSourceWizardPage {
    private DbProfilePageWrapper m_pageHelper = null;
    private Properties m_dataSourceProps = null;
    private ProfilePropertyPage m_wrappedPage;

    public DbProfileWizardPage(String pageName, ProfilePropertyPage dbPropertyPage) {
        super(pageName);
        this.m_wrappedPage = dbPropertyPage;
        this.setTitle(this.m_wrappedPage.getConnectionProfile().getName());
        this.setMessage(DbProfilePageWrapper.DEFAULT_MESSAGE);
    }

    public void createPageCustomControl(Composite parent) {
        if (this.m_pageHelper == null) {
            this.m_pageHelper = this.createDataSourcePageWrapper();
        }
        try {
            this.m_pageHelper.createCustomControl(parent, !this.isSessionEditable());
        }
        catch (OdaException e) {
            e.printStackTrace();
        }
        this.m_pageHelper.initCustomControl(this.m_dataSourceProps);
        this.setPingButtonVisible(false);
    }

    protected DbProfilePageWrapper createDataSourcePageWrapper() {
        return new DbProfilePageWrapper(this, this.m_wrappedPage);
    }

    public void setInitialProperties(Properties dataSourceProps) {
        this.m_dataSourceProps = dataSourceProps;
        if (this.m_pageHelper != null) {
            this.m_pageHelper.initCustomControl(this.m_dataSourceProps);
        }
    }

    public void refresh() {
    }

    public Properties collectCustomProperties() {
        if (this.m_pageHelper != null) {
            return this.m_pageHelper.collectCustomProperties(this.m_dataSourceProps);
        }
        return this.m_dataSourceProps != null ? this.m_dataSourceProps : new Properties();
    }

    public IWizardPage getNextPage() {
        return null;
    }

    public boolean isPageComplete() {
        if (this.m_pageHelper == null) {
            return super.isPageComplete();
        }
        return this.m_pageHelper.isValid();
    }

    String getDbProfileProviderId() {
        if (this.m_pageHelper == null) {
            return null;
        }
        return this.m_pageHelper.getDbProfileProviderId();
    }
}

