/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.oda.design.internal.ui;

import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.datatools.connectivity.oda.design.DataSetDesign;
import org.eclipse.datatools.connectivity.oda.design.DataSourceDesign;
import org.eclipse.datatools.connectivity.oda.design.DesignSessionResponse;
import org.eclipse.datatools.connectivity.oda.design.DesignerState;
import org.eclipse.datatools.connectivity.oda.design.Locale;
import org.eclipse.datatools.connectivity.oda.design.OdaDesignSession;
import org.eclipse.datatools.connectivity.oda.design.ResourceIdentifiers;
import org.eclipse.datatools.connectivity.oda.design.SessionStatus;
import org.eclipse.datatools.connectivity.oda.design.internal.designsession.DesignerLogger;
import org.eclipse.datatools.connectivity.oda.design.internal.ui.DataSetWizardPageCore;
import org.eclipse.datatools.connectivity.oda.design.internal.ui.DesignerUtil;
import org.eclipse.datatools.connectivity.oda.design.ui.manifest.DataSetPageInfo;
import org.eclipse.datatools.connectivity.oda.design.ui.manifest.DataSetUIElement;
import org.eclipse.datatools.connectivity.oda.design.ui.manifest.UIManifestExplorer;
import org.eclipse.datatools.connectivity.oda.design.ui.nls.Messages;
import org.eclipse.datatools.connectivity.oda.design.ui.wizards.DataSetWizardPage;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;

public class DataSetWizardBase
extends Wizard {
    private OdaDesignSession m_designSession;
    private DataSetUIElement m_dataSetUIElement;
    private DataSetDesign m_editDataSetDesign;
    private DesignerState m_responseDesignerState;
    private SessionStatus m_responseSessionStatus;
    private static final String sm_className = DataSetWizardBase.class.getName();

    protected DataSetWizardBase() {
    }

    public void initialize(OdaDesignSession odaDesign, DataSetUIElement dataSetUIElement) throws OdaException {
        this.m_designSession = odaDesign;
        this.m_dataSetUIElement = dataSetUIElement;
        this.m_editDataSetDesign = null;
        if (this.getPageCount() == 0) {
            this.addCustomPages();
        }
    }

    public boolean performFinish() {
        try {
            this.finishDataSetDesign();
        }
        catch (OdaException ex) {
            DesignerLogger logger = DesignerLogger.getInstance();
            logger.warning(sm_className, "performFinish", "Caught exception while finishDataSetDesign.", ex);
            return false;
        }
        return true;
    }

    public OdaDesignSession getResponseSession() throws OdaException {
        if (this.m_designSession.getResponse() == null) {
            this.finishDataSetDesign();
        }
        return this.m_designSession;
    }

    private void addCustomPages() throws OdaException {
        String odaUIPluginId = this.getOdaDesignerPluginId();
        DataSetPageInfo[] pageDefns = this.m_dataSetUIElement.getPageDefinitions();
        String initialPageId = this.m_dataSetUIElement.getInitialPageId();
        int i = 0;
        while (i < pageDefns.length) {
            DataSetPageInfo pageInfo = pageDefns[i];
            DataSetWizardPageCore page = this.createCustomPage(odaUIPluginId, pageInfo);
            if (initialPageId != null && page.getName().equalsIgnoreCase(initialPageId)) {
                page.setHasInitialFocus();
                initialPageId = null;
            }
            this.addPage((IWizardPage)page);
            ++i;
        }
    }

    protected String getOdaDesignerPluginId() {
        return UIManifestExplorer.getInstance().getOdaDesignerId(this.m_designSession.getRequestDataSourceDesign().getOdaExtensionDataSourceId());
    }

    protected DataSetWizardPageCore createCustomPage(String odaUIPluginId, DataSetPageInfo pageInfo) throws OdaException {
        DataSetWizardPageCore page = this.createWizardPage(odaUIPluginId, pageInfo.getWizardPageClassName(), pageInfo.getPageId());
        String pageTitle = pageInfo.getDisplayName();
        if (pageTitle != null && pageTitle.length() > 0) {
            page.setTitle(pageTitle);
        }
        page.setPagePath(pageInfo.getPath());
        page.setIconFilePath(pageInfo.getIcon());
        return page;
    }

    protected DataSetWizardPageCore createWizardPage(String pluginId, String wizardPageClassName, String pageId) throws OdaException {
        Object pageInstance;
        try {
            pageInstance = DesignerUtil.createInstanceWithStringArg(pluginId, wizardPageClassName, pageId);
        }
        catch (RuntimeException ex) {
            throw new OdaException((Throwable)ex);
        }
        if (!(pageInstance instanceof DataSetWizardPage)) {
            throw new OdaException(Messages.bind((String)Messages.extension_mustInheritFromODAPage, (Object)wizardPageClassName, (Object)DataSetWizardPage.class.getName()));
        }
        return (DataSetWizardPageCore)((Object)pageInstance);
    }

    DataSetDesign copyRequestDataSetDesign() {
        if (this.m_designSession == null) {
            return null;
        }
        return (DataSetDesign)EcoreUtil.copy((EObject)this.m_designSession.getRequestDataSetDesign());
    }

    DesignerState copyRequestDesignerState() {
        if (this.m_designSession == null || this.m_designSession.getRequest().getDesignerState() == null) {
            return null;
        }
        return (DesignerState)EcoreUtil.copy((EObject)this.m_designSession.getRequest().getDesignerState());
    }

    Locale copySessionLocale() {
        if (this.m_designSession == null || this.m_designSession.getRequest().getSessionLocale() == null) {
            return null;
        }
        return (Locale)EcoreUtil.copy((EObject)this.m_designSession.getRequest().getSessionLocale());
    }

    boolean isSessionEditable() {
        if (this.m_designSession == null) {
            return true;
        }
        return this.m_designSession.getRequest().isEditable();
    }

    ResourceIdentifiers getHostResourceIdentifiers() {
        if (this.m_designSession == null) {
            return null;
        }
        DataSourceDesign dataSourceDesign = this.m_designSession.getRequestDataSourceDesign();
        return dataSourceDesign != null ? dataSourceDesign.getHostResourceIdentifiers() : null;
    }

    protected DataSetDesign getEditingDataSet() {
        if (this.m_editDataSetDesign == null) {
            this.m_editDataSetDesign = this.copyRequestDataSetDesign();
        }
        return this.m_editDataSetDesign;
    }

    protected DataSetDesign collectDataSetDesignFromPage(DataSetWizardPageCore dataSetPage) {
        this.m_editDataSetDesign = dataSetPage.finishDataSetDesign(this.getEditingDataSet());
        return this.m_editDataSetDesign;
    }

    protected void finishDataSetDesign() throws OdaException {
        IWizardPage[] pages = this.getPages();
        int i = 0;
        while (i < pages.length) {
            IWizardPage page = pages[i];
            if (page instanceof DataSetWizardPageCore) {
                DataSetWizardPageCore dataSetPage = (DataSetWizardPageCore)page;
                this.collectDataSetDesignFromPage(dataSetPage);
            }
            ++i;
        }
        boolean isSessionOk = this.m_editDataSetDesign != null;
        this.m_designSession.setNewResponse(isSessionOk, this.m_editDataSetDesign);
        this.updateResponseWithState(this.m_designSession.getResponse());
    }

    void updateResponseWithState(DesignSessionResponse response) {
        DesignerState customState;
        SessionStatus defaultStatus;
        SessionStatus customStatus = this.getResponseSessionStatus();
        if (customStatus != null && customStatus.getValue() != 0 && ((defaultStatus = response.getSessionStatus()) == null || customStatus.getValue() != defaultStatus.getValue())) {
            response.setSessionStatus(customStatus);
            response.getDataAccessDesign().setDataSetDesign(null);
        }
        if ((customState = this.getResponseDesignerState()) != null) {
            response.setDesignerState(customState);
        }
    }

    protected DesignerState getResponseDesignerState() {
        return this.m_responseDesignerState;
    }

    protected void setResponseDesignerState(DesignerState customDesignerState) {
        this.m_responseDesignerState = customDesignerState;
    }

    protected SessionStatus getResponseSessionStatus() {
        return this.m_responseSessionStatus;
    }

    protected void setResponseSessionStatus(SessionStatus sessionStatus) {
        this.m_responseSessionStatus = sessionStatus;
    }
}

