/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.server.core.internal;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.wst.server.core.TaskModel;
import org.eclipse.wst.server.core.internal.ServerPlugin;
import org.eclipse.wst.server.core.internal.Trace;
import org.eclipse.wst.server.core.model.PublisherDelegate;

public class Publisher {
    private IConfigurationElement element;
    private PublisherDelegate delegate;

    public Publisher(IConfigurationElement element) {
        this.element = element;
    }

    public String getId() {
        return this.element.getAttribute("id");
    }

    public String getName() {
        return this.element.getAttribute("name");
    }

    public String getDescription() {
        return this.element.getAttribute("description");
    }

    protected String[] getTypeIds() {
        try {
            return ServerPlugin.tokenize(this.element.getAttribute("typeIds"), ",");
        }
        catch (Exception exception) {
            return null;
        }
    }

    public boolean supportsType(String id) {
        return ServerPlugin.contains(this.getTypeIds(), id);
    }

    public PublisherDelegate getDelegate() {
        if (this.delegate == null) {
            try {
                long time = System.currentTimeMillis();
                this.delegate = (PublisherDelegate)this.element.createExecutableExtension("class");
                Trace.trace(10, "PublishTask.getDelegate(): <" + (System.currentTimeMillis() - time) + "> " + this.getId());
            }
            catch (Throwable t) {
                Trace.trace(3, "Could not create delegate" + this.toString(), t);
            }
        }
        return this.delegate;
    }

    public IStatus execute(int kind, IProgressMonitor monitor, IAdaptable info) throws CoreException {
        try {
            Trace.trace(5, "Task.init " + this);
            return this.getDelegate().execute(kind, monitor, info);
        }
        catch (Exception e) {
            Trace.trace(3, "Error calling delegate " + this.toString(), e);
            return new Status(4, "org.eclipse.wst.server.core", "Error in delegate", (Throwable)e);
        }
    }

    public void setTaskModel(TaskModel taskModel) {
        try {
            this.getDelegate().setTaskModel(taskModel);
        }
        catch (Exception e) {
            Trace.trace(3, "Error calling delegate " + this.toString(), e);
        }
    }

    public String toString() {
        return "Publisher[" + this.getId() + "]";
    }
}

