/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.ase.deltaddl;

import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.datatools.enablement.ase.deltaddl.SybaseASEConstraintDeltaDdlGenProvider;
import org.eclipse.datatools.enablement.sybase.ase.models.sybaseasesqlmodel.SybaseASEPrimaryKey;
import org.eclipse.datatools.enablement.sybase.ase.models.sybaseasesqlmodel.SybaseASEUniqueConstraint;
import org.eclipse.datatools.enablement.sybase.ddl.SybaseDdlScript;
import org.eclipse.datatools.enablement.sybase.deltaddl.SybaseDeltaDdlGeneration;
import org.eclipse.datatools.enablement.sybase.util.SQLUtil;
import org.eclipse.datatools.modelbase.sql.constraints.TableConstraint;
import org.eclipse.datatools.modelbase.sql.constraints.UniqueConstraint;
import org.eclipse.datatools.modelbase.sql.schema.SQLObject;

public class SybaseASEUniqueDeltaDdlGenProvider
extends SybaseASEConstraintDeltaDdlGenProvider {
    public void analyze(SQLObject element, Map changeMap, Map modificationRecords) {
        super.analyze(element, changeMap, modificationRecords);
        int flag = (Integer)changeMap.get(element);
        if ((flag & 3) != 0) {
            if (element instanceof SybaseASEUniqueConstraint && element.eContainer() instanceof SybaseASEPrimaryKey) {
                changeMap.remove(element);
            } else if (element instanceof SybaseASEPrimaryKey) {
                changeMap.remove(((SybaseASEPrimaryKey)element).getAseUniqueConstraint());
            }
        }
    }

    public void processAlterStatement(SQLObject element, Map modifyRecordMap, boolean quoteIdentifiers, boolean qualifyNames, boolean fullSyntax, SybaseDdlScript script, IProgressMonitor monitor) {
        if (!(element instanceof UniqueConstraint)) {
            return;
        }
        UniqueConstraint constraint = (UniqueConstraint)element;
        List records = (List)modifyRecordMap.get(element);
        if (records != null) {
            for (SybaseDeltaDdlGeneration.FeatureChangeRecord r : records) {
                CharSequence statement;
                int featureID = r.feature.getFeatureID();
                if (featureID == 8 || featureID == 12) {
                    String oldName = constraint.getName();
                    String newName = constraint.getName();
                    if (this.isConstraintNameChanged(modifyRecordMap, (TableConstraint)constraint)) {
                        oldName = this.getConstraintOldName(modifyRecordMap, (TableConstraint)constraint);
                    }
                    constraint.setName(oldName);
                    String dropStatement = this._builder.dropUniqueConstraint(constraint, quoteIdentifiers, qualifyNames);
                    this.addDropStatement(script, dropStatement);
                    constraint.setName(newName);
                    String[] addStatement = this._builder.addUniqueConstraint(constraint, quoteIdentifiers, qualifyNames, fullSyntax);
                    int i = 0;
                    while (i < addStatement.length) {
                        this.addCreateStatement(script, addStatement[i]);
                        ++i;
                    }
                    return;
                }
                if (featureID == 9) {
                    statement = this.alterIndexParameter((TableConstraint)constraint, r.newValue, "fillfactor");
                    script.addAlterOtherStatements((String)statement);
                    continue;
                }
                if (featureID == 16) {
                    statement = this.alterIndexParameter((TableConstraint)constraint, r.newValue, "max_rows_per_page");
                    script.addAlterOtherStatements((String)statement);
                    continue;
                }
                if (featureID == 17) {
                    statement = this.alterIndexParameter((TableConstraint)constraint, r.newValue, "reservepagegap");
                    script.addAlterOtherStatements((String)statement);
                    continue;
                }
                if (featureID == 1) {
                    this.addConstraintRenameStatement((TableConstraint)constraint, r.oldValue, r.newValue, quoteIdentifiers, qualifyNames, fullSyntax, script);
                    continue;
                }
                if (featureID != 21) continue;
                statement = new StringBuffer();
                String objectName = String.valueOf(constraint.getBaseTable().getName()) + "." + constraint.getName();
                ((StringBuffer)statement).append("EXEC").append(" ").append("sp_placeobject").append(" ").append(SQLUtil.quote((String)((String)r.newValue), (String)"'")).append(",").append(SQLUtil.quote((String)objectName, (String)"'"));
            }
        }
    }

    private String alterIndexParameter(TableConstraint constraint, Object newValue, String parameter) {
        StringBuffer statement = new StringBuffer(128);
        String objectName = String.valueOf(constraint.getBaseTable().getName()) + "." + constraint.getName();
        statement.append("EXEC").append(" ").append("sp_chgattribute").append(" ").append(SQLUtil.quote((String)objectName, (String)"'")).append(",").append(SQLUtil.quote((String)parameter, (String)"'")).append(",").append((String)newValue);
        return statement.toString();
    }
}

