/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.internal.ui.wizards;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.datatools.connectivity.ProfileManager;
import org.eclipse.datatools.connectivity.internal.ui.ConnectionProfileManagerUI;
import org.eclipse.datatools.connectivity.internal.ui.ConnectivityUIPlugin;
import org.eclipse.datatools.connectivity.internal.ui.wizards.CPCategoryWizardNode;
import org.eclipse.datatools.connectivity.internal.ui.wizards.CPWizardNode;
import org.eclipse.datatools.connectivity.internal.ui.wizards.NewCPWizard;
import org.eclipse.datatools.connectivity.internal.ui.wizards.NewCategoryWizard;
import org.eclipse.datatools.connectivity.internal.ui.wizards.ProfileWizardProvider;
import org.eclipse.datatools.connectivity.internal.ui.wizards.WizardSelectionPage;
import org.eclipse.datatools.connectivity.ui.Messages;
import org.eclipse.datatools.connectivity.ui.wizards.ICPWizard;
import org.eclipse.datatools.connectivity.ui.wizards.IProfileWizardProvider;
import org.eclipse.datatools.connectivity.ui.wizards.IWizardCategoryProvider;
import org.eclipse.datatools.connectivity.ui.wizards.NewConnectionProfileWizard;
import org.eclipse.datatools.help.ContextProviderDelegate;
import org.eclipse.datatools.help.HelpUtil;
import org.eclipse.help.IContext;
import org.eclipse.help.IContextProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardNode;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.osgi.util.TextProcessor;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;

public class CPWizardSelectionPage
extends WizardSelectionPage
implements IContextProvider {
    private static final String EMPTY_STRING = "";
    private Text filterText = null;
    private WizardFilter mWizFilter = null;
    private Text mCPName;
    private Text mCPDesc;
    private String mCPNameStr;
    private String mCPDescStr;
    private boolean mPageIsVisible = false;
    private String category = "";
    private TableViewer tableViewer;
    private ContextProviderDelegate contextProviderDelegate = new ContextProviderDelegate(ConnectivityUIPlugin.getDefault().getBundle().getSymbolicName());
    private ViewerFilter[] viewerFilters = new ViewerFilter[]{new ViewerFilter(){

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            return true;
        }
    }};

    public List getCatagoryItems(String wizardCategory) {
        return this.getCategoryItems(wizardCategory);
    }

    public List getCategoryItems(String wizardCategory) {
        ConnectionProfileManagerUI manager = ConnectionProfileManagerUI.getInstance();
        Collection wizards = manager.getNewWizards().values();
        Collection wizardCats = manager.getWizardCategories().values();
        ArrayList<CPWizardNode> wizardNodes = new ArrayList<CPWizardNode>();
        if (wizards != null) {
            for (IProfileWizardProvider wizardProvider : wizards) {
                if (!wizardProvider.getCategory().equals(wizardCategory)) continue;
                wizardNodes.add(new CPWizardNode(wizardProvider));
            }
        }
        if (wizardCats != null) {
            for (IProfileWizardProvider wizardProvider : wizardCats) {
                if (!wizardProvider.getCategory().equals(wizardCategory)) continue;
                wizardNodes.add(new CPCategoryWizardNode(wizardProvider));
            }
        }
        return wizardNodes;
    }

    public CPWizardSelectionPage(String id) {
        super(id);
        this.setTitle(ConnectivityUIPlugin.getDefault().getResourceString("CPWizardSelectionPage.title"));
        this.setDescription(ConnectivityUIPlugin.getDefault().getResourceString("CPWizardSelectionPage.desc"));
    }

    protected CPWizardSelectionPage(String id, ViewerFilter filter) {
        this(id);
        if (filter != null) {
            this.viewerFilters = new ViewerFilter[]{filter};
        }
    }

    protected CPWizardSelectionPage(String id, ViewerFilter[] filters) {
        this(id);
        if (filters != null) {
            this.viewerFilters = filters;
        }
    }

    protected CPWizardSelectionPage(String id, ViewerFilter filter, String cat) {
        this(id, filter);
        this.setCategory(cat);
    }

    protected void setCategory(String categoryId) {
        this.category = categoryId;
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout());
        this.setControl((Control)container);
        Group group = new Group(container, 0);
        group.setLayout((Layout)new GridLayout());
        group.setText(ConnectivityUIPlugin.getDefault().getResourceString("CPWizardSelectionPage.group"));
        group.setLayoutData((Object)new GridData(4, 4, true, true, 1, 8));
        this.filterText = new Text((Composite)group, 2048);
        this.filterText.setLayoutData((Object)new GridData(768));
        this.filterText.setText(Messages.CPWizardSelectionPage_default_filter_text);
        this.filterText.selectAll();
        this.filterText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (CPWizardSelectionPage.this.tableViewer != null && !CPWizardSelectionPage.this.tableViewer.getControl().isDisposed()) {
                    String filter = CPWizardSelectionPage.this.filterText.getText();
                    if (CPWizardSelectionPage.this.mWizFilter != null) {
                        CPWizardSelectionPage.this.tableViewer.removeFilter((ViewerFilter)CPWizardSelectionPage.this.mWizFilter);
                    }
                    if (filter != null && filter.trim().length() > 0) {
                        CPWizardSelectionPage.this.mWizFilter = new WizardFilter(filter);
                        CPWizardSelectionPage.this.tableViewer.addFilter((ViewerFilter)CPWizardSelectionPage.this.mWizFilter);
                    }
                    CPWizardSelectionPage.this.setProfileName(new String());
                    CPWizardSelectionPage.this.setSelectedNode(null);
                    CPWizardSelectionPage.this.validate();
                }
            }
        });
        this.tableViewer = new TableViewer((Composite)group, 67584);
        this.tableViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent e) {
                IStructuredSelection iss = (IStructuredSelection)CPWizardSelectionPage.this.tableViewer.getSelection();
                if (iss != null && !iss.isEmpty()) {
                    CPWizardNode node = (CPWizardNode)iss.getFirstElement();
                    String newName = ConnectivityUIPlugin.getDefault().getResourceString("CPWizardSelectionPage.defaultName", new String[]{node.getProvider().getName()});
                    int i = 0;
                    while (ProfileManager.getInstance().getProfileByName(newName) != null && i < Integer.MAX_VALUE) {
                        newName = ConnectivityUIPlugin.getDefault().getResourceString("CPWizardSelectionPage.defaultNameExtended", new String[]{node.getProvider().getName(), Integer.toString(i)});
                        newName = TextProcessor.process((String)newName);
                        ++i;
                    }
                    CPWizardSelectionPage.this.setProfileName(newName);
                    CPWizardSelectionPage.this.setSelectedNode(node);
                    CPWizardSelectionPage.this.validate();
                    if (CPWizardSelectionPage.this.getErrorMessage() == null) {
                        CPWizardSelectionPage.this.getWizard().getContainer().showPage(CPWizardSelectionPage.this.getNextPage());
                    }
                }
            }
        });
        this.tableViewer.setSorter((ViewerSorter)new Sorter());
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new TableLabelProvider());
        this.tableViewer.setContentProvider((IContentProvider)new TableContentProvider());
        Table table = this.tableViewer.getTable();
        GridData gdTable = new GridData(1808);
        gdTable.heightHint = 240;
        table.setLayoutData((Object)gdTable);
        TableLayout tl = new TableLayout();
        tl.addColumnData((ColumnLayoutData)new ColumnWeightData(100));
        TableColumn tableColumn = new TableColumn(table, 0);
        tableColumn.setWidth(400);
        this.tableViewer.setFilters(this.viewerFilters);
        this.tableViewer.setInput((Object)this.category);
        this.tableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection iss = (IStructuredSelection)event.getSelection();
                if (iss != null && !iss.isEmpty()) {
                    CPWizardNode node = (CPWizardNode)iss.getFirstElement();
                    if (CPWizardSelectionPage.this.getSelectedNode() != null && CPWizardSelectionPage.this.getSelectedNode().equals(node)) {
                        return;
                    }
                    int i = 0;
                    String newName = ConnectivityUIPlugin.getDefault().getResourceString("CPWizardSelectionPage.defaultName", new String[]{node.getProvider().getName()});
                    while (ProfileManager.getInstance().getProfileByName(newName) != null && i < Integer.MAX_VALUE) {
                        newName = ConnectivityUIPlugin.getDefault().getResourceString("CPWizardSelectionPage.defaultNameExtended", new String[]{node.getProvider().getName(), Integer.toString(i)});
                        newName = TextProcessor.process((String)newName);
                        ++i;
                    }
                    CPWizardSelectionPage.this.setProfileName(newName);
                    CPWizardSelectionPage.this.setDescription(node.getProvider().getDescription());
                    CPWizardSelectionPage.this.setSelectedNode(node);
                }
            }
        });
        new Label(container, 0).setText(ConnectivityUIPlugin.getDefault().getResourceString("NewConnectionProfileWizardPage.cp_name"));
        this.mCPName = new Text(container, 2048);
        this.mCPName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CPWizardSelectionPage.this.mCPNameStr = CPWizardSelectionPage.this.mCPName.getText();
                CPWizardSelectionPage.this.handleModify();
            }
        });
        this.mCPName.setLayoutData((Object)new GridData(768));
        new Label(container, 0).setText(ConnectivityUIPlugin.getDefault().getResourceString("NewConnectionProfileWizardPage.cp_desc"));
        this.mCPDesc = new Text(container, 2048);
        this.mCPDesc.setLayoutData((Object)new GridData(768));
        this.mCPDesc.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CPWizardSelectionPage.this.mCPDescStr = CPWizardSelectionPage.this.mCPDesc.getText();
                CPWizardSelectionPage.this.handleModify();
            }
        });
        this.initializeDialogUnits((Control)container);
        this.setPageComplete(false);
        this.getShell().setData(HelpUtil.CONTEXT_PROVIDER_KEY, (Object)this);
        HelpUtil.setHelp((Control)this.tableViewer.getTable(), (String)HelpUtil.getContextId((String)"CONTEXT_ID_CP_WIZARD_PAGE", (String)ConnectivityUIPlugin.getDefault().getBundle().getSymbolicName()));
    }

    public void onSetActive() {
        if (this.tableViewer == null) {
            return;
        }
        Object obj = this.tableViewer.getElementAt(0);
        if (obj != null) {
            this.tableViewer.setSelection((ISelection)new StructuredSelection(obj));
        }
    }

    protected void initWizard(IWizard wizard) {
        IProfileWizardProvider wizardProvider = ((CPWizardNode)this.getSelectedNode()).getProvider();
        this.initWizard(wizard, wizardProvider);
    }

    private void initWizard(IWizard wizard, IProfileWizardProvider wizardProvider) {
        if (wizard instanceof ICPWizard) {
            ((ICPWizard)wizard).initProviderID(((ProfileWizardProvider)wizardProvider).getProfile());
            if (this.getWizard() instanceof NewCPWizard) {
                ((ICPWizard)wizard).setParentProfile(((NewCPWizard)this.getWizard()).getParentProfile());
            }
        } else if (wizard instanceof NewCategoryWizard) {
            NewCategoryWizard catWizard = (NewCategoryWizard)wizard;
            catWizard.initWizardCategory((IWizardCategoryProvider)wizardProvider);
            catWizard.setWindowTitle(this.getWizard().getWindowTitle());
        }
    }

    public IWizardPage getNextPage() {
        NewConnectionProfileWizard ancpw;
        List categoryItems;
        IWizardNode selectedNode = this.getSelectedNode();
        if (selectedNode == null) {
            return null;
        }
        IProfileWizardProvider wizardProvider = ((CPWizardNode)this.getSelectedNode()).getProvider();
        boolean isCreated = selectedNode.isContentCreated();
        IWizard wizard = selectedNode.getWizard();
        if (wizard == null) {
            this.setSelectedNode(null);
            return null;
        }
        if (wizard instanceof NewCategoryWizard && (categoryItems = this.getCategoryItems(wizardProvider.getId())).size() == 1) {
            IWizardNode wizardNode = (IWizardNode)categoryItems.get(0);
            isCreated = wizardNode.isContentCreated();
            wizard = wizardNode.getWizard();
            wizardProvider = ((CPWizardNode)wizardNode).getProvider();
        }
        if (!isCreated) {
            this.initWizard(wizard, wizardProvider);
            if (wizard instanceof NewConnectionProfileWizard) {
                ancpw = (NewConnectionProfileWizard)wizard;
                ancpw.setProfileName(this.getProfileName());
                ancpw.setProfileDescription(this.getProfileDescription());
            }
            wizard.addPages();
        } else if (wizard instanceof NewConnectionProfileWizard) {
            ancpw = (NewConnectionProfileWizard)wizard;
            ancpw.setProfileName(this.getProfileName());
            ancpw.setProfileDescription(this.getProfileDescription());
        }
        if (this.mPageIsVisible && wizard instanceof NewConnectionProfileWizard) {
            ancpw = (NewConnectionProfileWizard)wizard;
            ancpw.setSkipProfileNamePage(true);
        }
        return wizard.getStartingPage();
    }

    public IContext getContext(Object target) {
        return this.contextProviderDelegate.getContext(target);
    }

    public int getContextChangeMask() {
        return this.contextProviderDelegate.getContextChangeMask();
    }

    public String getSearchExpression(Object target) {
        return this.contextProviderDelegate.getSearchExpression(target);
    }

    public List getSummaryData() {
        ArrayList<String[]> data = new ArrayList<String[]>();
        data.add(new String[]{ConnectivityUIPlugin.getDefault().getResourceString("NewConnectionProfileWizardPage.summary_cp_name"), this.getProfileName()});
        data.add(new String[]{ConnectivityUIPlugin.getDefault().getResourceString("NewConnectionProfileWizardPage.summary_cp_desc"), this.getProfileDescription()});
        return data;
    }

    private void handleModify() {
        this.validate();
    }

    private void validate() {
        String errorMessage = null;
        String cpName = this.mCPName.getText().trim();
        IConnectionProfile foundProfile = null;
        if (cpName == null || cpName.trim().length() == 0) {
            errorMessage = ConnectivityUIPlugin.getDefault().getResourceString("NewConnectionProfileWizardPage.Status.NoName");
        } else if (cpName.indexOf(":") != -1) {
            errorMessage = ConnectivityUIPlugin.getDefault().getResourceString("NewConnectionProfileWizardPage.Status.ContainsColon");
        } else {
            foundProfile = ProfileManager.getInstance().getProfileByName(cpName.trim());
            if (foundProfile != null) {
                errorMessage = ConnectivityUIPlugin.getDefault().getResourceString("NewConnectionProfileWizardPage.Status.DuplicateName");
            }
        }
        this.setErrorMessage(errorMessage);
        this.setPageComplete(errorMessage == null);
    }

    public String getProfileName() {
        return this.mCPName == null || this.mCPName.isDisposed() ? this.mCPNameStr : this.mCPName.getText();
    }

    public void setProfileName(String name) {
        this.mCPNameStr = name;
        if (this.mCPName != null && !this.mCPName.isDisposed()) {
            if (name == null) {
                name = EMPTY_STRING;
            }
            this.mCPName.setText(name);
        }
    }

    public String getProfileDescription() {
        return this.mCPDesc == null || this.mCPDesc.isDisposed() ? this.mCPDescStr : this.mCPDesc.getText();
    }

    public void setProfileDescription(String desc) {
        this.mCPDescStr = desc;
        if (this.mCPDesc != null && !this.mCPDesc.isDisposed()) {
            if (desc == null) {
                desc = EMPTY_STRING;
            }
            this.mCPDesc.setText(desc);
        }
    }

    public boolean isPageComplete() {
        if (this.getErrorMessage() != null) {
            return false;
        }
        if (this.getNextPage() == null) {
            return false;
        }
        if (!this.getNextPage().isPageComplete()) {
            return false;
        }
        return super.isPageComplete();
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        this.mPageIsVisible = visible;
    }

    public boolean canFlipToNextPage() {
        if (this.getErrorMessage() != null) {
            return false;
        }
        return super.canFlipToNextPage();
    }

    class Sorter
    extends ViewerSorter {
        Sorter() {
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            CPWizardNode item1 = (CPWizardNode)e1;
            CPWizardNode item2 = (CPWizardNode)e2;
            return item1.getProvider().getName().compareTo(item2.getProvider().getName());
        }
    }

    class TableContentProvider
    implements IStructuredContentProvider {
        private String wizardCategory;

        TableContentProvider() {
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            this.wizardCategory = (String)newInput;
        }

        public Object[] getElements(Object inputElement) {
            List wizardNodes = CPWizardSelectionPage.this.getCategoryItems(this.wizardCategory);
            return wizardNodes.toArray(new CPWizardNode[wizardNodes.size()]);
        }
    }

    class TableLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        TableLabelProvider() {
        }

        public String getColumnText(Object element, int columnIndex) {
            return ((CPWizardNode)element).getProvider().getName();
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return ((CPWizardNode)element).getProvider().getCachedIcon();
        }
    }

    class WizardFilter
    extends ViewerFilter {
        private String mFilter;

        public WizardFilter(String filter) {
            this.mFilter = filter;
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            if (element instanceof CPWizardNode) {
                CPWizardNode node = (CPWizardNode)element;
                String name = node.getProvider().getName();
                if (this.mFilter != null) {
                    if (name.toUpperCase().startsWith(this.mFilter.toUpperCase())) {
                        return true;
                    }
                    return name.toUpperCase().indexOf(this.mFilter.toUpperCase()) > 0;
                }
            }
            return true;
        }
    }
}

