/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal.search;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.help.IToc;
import org.eclipse.help.ITopic;
import org.eclipse.help.internal.HelpPlugin;
import org.eclipse.help.internal.search.ISearchHitCollector;
import org.eclipse.help.internal.search.SearchHit;
import org.eclipse.help.internal.toc.Toc;
import org.eclipse.help.internal.util.URLCoder;
import org.eclipse.help.internal.workingset.AdaptableHelpResource;
import org.eclipse.help.internal.workingset.AdaptableToc;
import org.eclipse.help.internal.workingset.WorkingSet;

public class SearchResults
implements ISearchHitCollector {
    private ArrayList scopes;
    private int maxHits;
    private String locale;
    protected SearchHit[] searchHits = new SearchHit[0];
    static /* synthetic */ Class class$0;

    public SearchResults(WorkingSet[] workingSets, int maxHits, String locale) {
        this.maxHits = maxHits;
        this.locale = locale;
        this.scopes = this.getScopes(workingSets);
    }

    public void addHits(List hits, String highlightTerms) {
        String urlEncodedWords = URLCoder.encode((String)highlightTerms);
        ArrayList<SearchHit> searchHitList = new ArrayList<SearchHit>();
        float scoreScale = 1.0f;
        boolean scoreScaleSet = false;
        Iterator iter = hits.iterator();
        int filteredHits = 0;
        while (filteredHits < this.maxHits && iter.hasNext()) {
            ITopic t;
            SearchHit rawHit = (SearchHit)iter.next();
            String href = rawHit.getHref();
            IToc toc = null;
            AdaptableHelpResource scope = null;
            if (this.scopes == null) {
                toc = this.getTocForTopic(href, this.locale);
            } else {
                scope = this.getScopeForTopic(href);
                if (scope == null) continue;
                if (scope instanceof AdaptableToc) {
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        try {
                            clazz = Class.forName("org.eclipse.help.IToc");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    toc = (IToc)scope.getAdapter(clazz);
                } else {
                    IAdaptable iAdaptable = scope.getParent();
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        try {
                            clazz = Class.forName("org.eclipse.help.IToc");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    toc = (IToc)iAdaptable.getAdapter((Class)clazz);
                }
            }
            float score = rawHit.getScore();
            if (!scoreScaleSet) {
                if (score > 0.0f) {
                    scoreScale = 0.99f / score;
                    score = 1.0f;
                }
                scoreScaleSet = true;
            } else {
                score = score * scoreScale + 0.01f;
            }
            String label = rawHit.getLabel();
            if ("".equals(label) && toc != null && (t = scope != null ? scope.getTopic(href) : toc.getTopic(href)) != null) {
                label = t.getLabel();
            }
            if (label == null || "".equals(label)) {
                label = href;
            }
            if (urlEncodedWords.length() > 0) {
                href = String.valueOf(href) + "?resultof=" + urlEncodedWords;
            }
            ++filteredHits;
            searchHitList.add(new SearchHit(href, label, rawHit.getSummary(), score, toc, rawHit.getRawId(), rawHit.getParticipantId(), rawHit.isPotentialHit()));
        }
        this.searchHits = searchHitList.toArray(new SearchHit[searchHitList.size()]);
    }

    private AdaptableHelpResource getScopeForTopic(String href) {
        int i = 0;
        while (i < this.scopes.size()) {
            String owningTocHref;
            Toc toc;
            AdaptableHelpResource scope = (AdaptableHelpResource)this.scopes.get(i);
            if (scope.getTopic(href) != null) {
                return scope;
            }
            IToc tocRoot = this.getTocForScope(scope, this.locale);
            if (tocRoot != null && (toc = HelpPlugin.getTocManager().getOwningToc(href)) != null && (owningTocHref = toc.getHref()) == tocRoot.getHref()) {
                return scope;
            }
            ++i;
        }
        return null;
    }

    private IToc getTocForScope(AdaptableHelpResource scope, String locale) {
        if (scope == null) {
            return null;
        }
        String href = scope.getHref();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.help.IToc");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (scope.getAdapter(clazz) instanceof IToc) {
            Class<?> clazz2 = class$0;
            if (clazz2 == null) {
                try {
                    clazz2 = class$0 = Class.forName("org.eclipse.help.IToc");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            IToc toc = (IToc)scope.getAdapter(clazz2);
            href = toc.getTopic(null).getHref();
        }
        if (href != null && href.length() > 0) {
            return this.getTocForTopic(href, locale);
        }
        AdaptableHelpResource[] childrenScopes = scope.getChildren();
        if (childrenScopes != null) {
            int i = 0;
            while (i < childrenScopes.length) {
                IToc toc = this.getTocForScope(childrenScopes[i], locale);
                if (toc != null) {
                    return toc;
                }
                ++i;
            }
        }
        return null;
    }

    private IToc getTocForTopic(String href, String locale) {
        Toc[] tocs = HelpPlugin.getTocManager().getTocs(locale);
        int i = 0;
        while (i < tocs.length) {
            ITopic topic = tocs[i].getTopic(href);
            if (topic != null) {
                return tocs[i];
            }
            ++i;
        }
        return null;
    }

    public SearchHit[] getSearchHits() {
        return this.searchHits;
    }

    private ArrayList getScopes(WorkingSet[] wSets) {
        if (wSets == null) {
            return null;
        }
        this.scopes = new ArrayList(wSets.length);
        int w = 0;
        while (w < wSets.length) {
            AdaptableHelpResource[] elements = wSets[w].getElements();
            int i = 0;
            while (i < elements.length) {
                this.scopes.add(elements[i]);
                ++i;
            }
            ++w;
        }
        return this.scopes;
    }
}

