/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.metadata.generator.features;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;

public class SiteFeature {
    private URL base;
    private List categoryNames;
    private String featureId;
    private String featureVersion;
    private final boolean resolved = false;
    private URL url;
    private String urlString;

    public static boolean sameURL(URL url1, URL url2) {
        if (url1 == null || url2 == null) {
            return false;
        }
        if (url1 == url2) {
            return true;
        }
        if (url1.equals(url2)) {
            return true;
        }
        if (!"file".equalsIgnoreCase(url1.getProtocol())) {
            return false;
        }
        if (!"file".equalsIgnoreCase(url2.getProtocol())) {
            return false;
        }
        File file1 = new File(url1.getFile());
        File file2 = new File(url2.getFile());
        if (file1 == null) {
            return false;
        }
        return file1.equals(file2);
    }

    public void addCategoryName(String categoryName) {
        if (this.categoryNames == null) {
            this.categoryNames = new ArrayList();
        }
        if (!this.categoryNames.contains(categoryName)) {
            this.categoryNames.add(categoryName);
        }
    }

    private void delayedResolve() {
        try {
            this.url = new URL(this.base, this.urlString);
        }
        catch (MalformedURLException malformedURLException) {}
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this.getURL() == null) {
            return false;
        }
        if (!(object instanceof SiteFeature)) {
            return false;
        }
        SiteFeature f = (SiteFeature)object;
        return SiteFeature.sameURL(this.getURL(), f.getURL());
    }

    public String[] getCategoryNames() {
        if (this.categoryNames == null) {
            return new String[0];
        }
        return this.categoryNames.toArray(new String[0]);
    }

    public String getFeatureIdentifier() {
        return this.featureId;
    }

    public String getFeatureVersion() {
        return this.featureVersion;
    }

    public URL getURL() {
        this.delayedResolve();
        return this.url;
    }

    public void setFeatureIdentifier(String featureId) {
        this.featureId = featureId;
    }

    public void setFeatureVersion(String featureVersion) {
        this.featureVersion = featureVersion;
    }

    public void setURLString(String urlString) {
        this.urlString = urlString;
        this.url = null;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(String.valueOf(this.getClass().toString()) + " :");
        buffer.append(" at ");
        if (this.url != null) {
            buffer.append(this.url.toExternalForm());
        }
        return buffer.toString();
    }
}

