/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.sqlbuilder.views.source;

import java.util.ArrayList;
import org.eclipse.datatools.sqltools.sqlbuilder.views.source.CaseControlledWordRule;
import org.eclipse.datatools.sqltools.sqlbuilder.views.source.SQLColourProvider;
import org.eclipse.datatools.sqltools.sqlbuilder.views.source.SQLKeywords;
import org.eclipse.datatools.sqltools.sqlbuilder.views.source.SQLWhitespaceDetector;
import org.eclipse.datatools.sqltools.sqlbuilder.views.source.SQLWordDetector;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.rules.EndOfLineRule;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.IWhitespaceDetector;
import org.eclipse.jface.text.rules.MultiLineRule;
import org.eclipse.jface.text.rules.NumberRule;
import org.eclipse.jface.text.rules.RuleBasedScanner;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.rules.WhitespaceRule;

public class SQLSourceScanner
extends RuleBasedScanner
implements SQLKeywords {
    private TextAttribute fKeyword = null;
    private TextAttribute fComment = null;
    private TextAttribute fDefaultTextAttribute = null;
    private TextAttribute fString = null;
    private TextAttribute fDoubleQuotesString = null;
    private SQLColourProvider fColourProvider = null;

    public SQLSourceScanner(SQLColourProvider colourProvider) {
        this.fColourProvider = colourProvider;
        this.createTextAttributes();
        Token keyword = new Token((Object)this.fKeyword);
        Token comment = new Token((Object)this.fComment);
        Token other = new Token((Object)this.fDefaultTextAttribute);
        Token string = new Token((Object)this.fString);
        Token doubleQuotesString = new Token((Object)this.fDoubleQuotesString);
        ArrayList<Object> rules = new ArrayList<Object>();
        rules.add(new NumberRule((IToken)other));
        rules.add(new MultiLineRule("'", "'", (IToken)string));
        rules.add(new MultiLineRule("\"", "\"", (IToken)doubleQuotesString));
        rules.add(new EndOfLineRule("--", (IToken)comment));
        rules.add(new WhitespaceRule((IWhitespaceDetector)new SQLWhitespaceDetector()));
        CaseControlledWordRule wordRule = new CaseControlledWordRule(new SQLWordDetector(), (IToken)other);
        int i = 0;
        while (i < fSQLKeywordList.length) {
            wordRule.addWord(fSQLKeywordList[i], (IToken)keyword);
            ++i;
        }
        rules.add((Object)wordRule);
        rules.add(new NumberRule((IToken)other));
        IRule[] result = new IRule[rules.size()];
        rules.toArray(result);
        this.setRules(result);
    }

    protected void createTextAttributes() {
        this.fKeyword = new TextAttribute(this.fColourProvider.getColor(SQLColourProvider.KEYWORD));
        this.fComment = new TextAttribute(this.fColourProvider.getColor(SQLColourProvider.COMMENT));
        this.fDefaultTextAttribute = new TextAttribute(this.fColourProvider.getColor(SQLColourProvider.DEFAULT));
        this.fString = new TextAttribute(this.fColourProvider.getColor(SQLColourProvider.STRING));
        this.fDoubleQuotesString = new TextAttribute(this.fColourProvider.getColor(SQLColourProvider.DEFAULT));
    }
}

