/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.mergedoc.pleiades.resource;

import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import org.apache.commons.io.filefilter.DirectoryFileFilter;
import org.apache.commons.io.filefilter.FileFileFilter;
import org.apache.commons.io.filefilter.SuffixFileFilter;

public class Files {
    public static final File resourceRoot;

    static {
        String markResource = "/.marker";
        URL url = Files.class.getResource(markResource);
        if (url == null) {
            String msg = "\u30af\u30e9\u30b9\u30d1\u30b9\u4e0a\u306b\u30d5\u30a1\u30a4\u30eb\u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093\u3002" + markResource;
            FileNotFoundException e = new FileNotFoundException(msg);
            System.err.println(String.valueOf(msg) + " " + e);
            throw new IllegalStateException(msg, e);
        }
        String path = new File(url.getPath()).getParent();
        String unicodePath = Files.decodePath(path);
        resourceRoot = new File(unicodePath);
    }

    private Files() {
    }

    public static String decodePath(String path) {
        try {
            return URLDecoder.decode(path, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException(e);
        }
    }

    public static File getFile(String resourcePath) {
        return new File(resourceRoot, resourcePath);
    }

    public static String relativePath(File folder, File file) {
        try {
            String folderPath = folder.getCanonicalPath();
            String filePath = file.getCanonicalPath();
            return filePath.replace(folderPath, "");
        }
        catch (IOException e) {
            throw new IllegalArgumentException(folder + ", " + file, e);
        }
    }

    public static String toVcIgnoreName(String path) {
        return path.contains("/") ? path.replaceFirst("(.*/)(.*)", "$1.$2") : "." + path;
    }

    public static FileFilter createDirectoryFilter() {
        return DirectoryFileFilter.INSTANCE;
    }

    public static FileFilter createFileFilter() {
        return FileFileFilter.FILE;
    }

    public static FileFilter createSuffixFilter(String suffix) {
        return new SuffixFileFilter(suffix);
    }
}

