/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.utility.model.event;

import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.jpt.utility.model.Model;
import org.eclipse.jpt.utility.model.event.ChangeEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListChangeEvent
extends ChangeEvent {
    private final String listName;
    private final int index;
    private final List<?> items;
    private final List<?> replacedItems;
    private final int sourceIndex;
    private final int moveLength;
    private static final long serialVersionUID = 1L;

    protected ListChangeEvent(Model source, String listName, int index, List<?> items, List<?> replacedItems, int sourceIndex, int moveLength) {
        super(source);
        if (listName == null || items == null || replacedItems == null) {
            throw new NullPointerException();
        }
        this.listName = listName;
        this.index = index;
        this.items = Collections.unmodifiableList(items);
        this.replacedItems = Collections.unmodifiableList(replacedItems);
        this.sourceIndex = sourceIndex;
        this.moveLength = moveLength;
    }

    public ListChangeEvent(Model source, String listName, int index, List<?> items, List<?> replacedItems) {
        this(source, listName, index, items, replacedItems, -1, -1);
    }

    public ListChangeEvent(Model source, String listName, int index, List<?> items) {
        this(source, listName, index, items, Collections.emptyList(), -1, -1);
    }

    public ListChangeEvent(Model source, String listName, int targetIndex, int sourceIndex, int length) {
        this(source, listName, targetIndex, Collections.emptyList(), Collections.emptyList(), sourceIndex, length);
    }

    public ListChangeEvent(Model source, String listName) {
        this(source, listName, -1, Collections.emptyList(), Collections.emptyList(), -1, -1);
    }

    public String getListName() {
        return this.listName;
    }

    @Override
    public String getAspectName() {
        return this.listName;
    }

    public int getIndex() {
        return this.index;
    }

    public ListIterator<?> items() {
        return this.items.listIterator();
    }

    public int itemsSize() {
        return this.items.size();
    }

    public ListIterator<?> replacedItems() {
        return this.replacedItems.listIterator();
    }

    public int getTargetIndex() {
        return this.index;
    }

    public int getSourceIndex() {
        return this.sourceIndex;
    }

    public int getMoveLength() {
        return this.moveLength;
    }

    @Override
    public ListChangeEvent cloneWithSource(Model newSource) {
        return new ListChangeEvent(newSource, this.listName, this.index, this.items, this.replacedItems, this.sourceIndex, this.moveLength);
    }

    public ListChangeEvent cloneWithSource(Model newSource, String newListName) {
        return new ListChangeEvent(newSource, newListName, this.index, this.items, this.replacedItems, this.sourceIndex, this.moveLength);
    }

    public ListChangeEvent cloneWithSource(Model newSource, String newListName, int offset) {
        return new ListChangeEvent(newSource, newListName, this.index + offset, this.items, this.replacedItems, this.sourceIndex + offset, this.moveLength);
    }
}

