/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.utility.internal.model.value.swing;

import javax.swing.ComboBoxModel;
import org.eclipse.jpt.utility.internal.StringTools;
import org.eclipse.jpt.utility.internal.model.listener.awt.AWTPropertyChangeListenerWrapper;
import org.eclipse.jpt.utility.internal.model.value.swing.ListModelAdapter;
import org.eclipse.jpt.utility.model.event.PropertyChangeEvent;
import org.eclipse.jpt.utility.model.listener.PropertyChangeListener;
import org.eclipse.jpt.utility.model.value.CollectionValueModel;
import org.eclipse.jpt.utility.model.value.ListValueModel;
import org.eclipse.jpt.utility.model.value.WritablePropertyValueModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComboBoxModelAdapter
extends ListModelAdapter
implements ComboBoxModel {
    protected final WritablePropertyValueModel<Object> selectionHolder;
    protected final PropertyChangeListener selectionListener;

    public ComboBoxModelAdapter(ListValueModel<?> listHolder, WritablePropertyValueModel<Object> selectionHolder) {
        super(listHolder);
        if (selectionHolder == null) {
            throw new NullPointerException();
        }
        this.selectionHolder = selectionHolder;
        this.selectionListener = this.buildSelectionListener();
    }

    public ComboBoxModelAdapter(CollectionValueModel<?> collectionHolder, WritablePropertyValueModel<Object> selectionHolder) {
        super(collectionHolder);
        if (selectionHolder == null) {
            throw new NullPointerException();
        }
        this.selectionHolder = selectionHolder;
        this.selectionListener = this.buildSelectionListener();
    }

    protected PropertyChangeListener buildSelectionListener() {
        return new AWTPropertyChangeListenerWrapper(this.buildSelectionListener_());
    }

    protected PropertyChangeListener buildSelectionListener_() {
        return new PropertyChangeListener(){

            public void propertyChanged(PropertyChangeEvent event) {
                ComboBoxModelAdapter.this.fireSelectionChanged();
            }

            public String toString() {
                return "selection listener";
            }
        };
    }

    @Override
    public Object getSelectedItem() {
        return this.selectionHolder.getValue();
    }

    @Override
    public void setSelectedItem(Object selectedItem) {
        this.selectionHolder.setValue(selectedItem);
    }

    @Override
    protected void engageModel() {
        super.engageModel();
        this.selectionHolder.addPropertyChangeListener("value", this.selectionListener);
    }

    @Override
    protected void disengageModel() {
        this.selectionHolder.removePropertyChangeListener("value", this.selectionListener);
        super.disengageModel();
    }

    protected void fireSelectionChanged() {
        this.fireContentsChanged(this, -1, -1);
    }

    @Override
    public String toString() {
        return StringTools.buildToStringFor(this, this.selectionHolder + ":" + this.listHolder);
    }
}

