/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.utility.internal.model.value;

import java.util.Iterator;
import org.eclipse.jpt.utility.internal.iterators.EmptyIterator;
import org.eclipse.jpt.utility.internal.iterators.SingleElementIterator;
import org.eclipse.jpt.utility.internal.model.AbstractModel;
import org.eclipse.jpt.utility.internal.model.ChangeSupport;
import org.eclipse.jpt.utility.internal.model.SingleAspectChangeSupport;
import org.eclipse.jpt.utility.model.event.PropertyChangeEvent;
import org.eclipse.jpt.utility.model.listener.CollectionChangeListener;
import org.eclipse.jpt.utility.model.listener.PropertyChangeListener;
import org.eclipse.jpt.utility.model.value.CollectionValueModel;
import org.eclipse.jpt.utility.model.value.PropertyValueModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyCollectionValueModelAdapter<E>
extends AbstractModel
implements CollectionValueModel<E> {
    protected final PropertyValueModel<? extends E> valueHolder;
    protected final PropertyChangeListener propertyChangeListener;
    protected E value;

    public PropertyCollectionValueModelAdapter(PropertyValueModel<? extends E> valueHolder) {
        if (valueHolder == null) {
            throw new NullPointerException();
        }
        this.valueHolder = valueHolder;
        this.propertyChangeListener = this.buildPropertyChangeListener();
    }

    @Override
    protected ChangeSupport buildChangeSupport() {
        return new SingleAspectChangeSupport(this, CollectionChangeListener.class, "values");
    }

    protected PropertyChangeListener buildPropertyChangeListener() {
        return new PropertyChangeListener(){

            public void propertyChanged(PropertyChangeEvent event) {
                PropertyCollectionValueModelAdapter.this.valueChanged(event.getNewValue());
            }

            public String toString() {
                return "property change listener";
            }
        };
    }

    @Override
    public Iterator<E> iterator() {
        return this.value == null ? EmptyIterator.instance() : new SingleElementIterator<E>(this.value);
    }

    @Override
    public int size() {
        return this.value == null ? 0 : 1;
    }

    @Override
    public void addCollectionChangeListener(CollectionChangeListener listener) {
        if (this.hasNoListeners()) {
            this.engageModel();
        }
        super.addCollectionChangeListener(listener);
    }

    @Override
    public void addCollectionChangeListener(String collectionName, CollectionChangeListener listener) {
        if (collectionName == "values" && this.hasNoListeners()) {
            this.engageModel();
        }
        super.addCollectionChangeListener(collectionName, listener);
    }

    @Override
    public void removeCollectionChangeListener(CollectionChangeListener listener) {
        super.removeCollectionChangeListener(listener);
        if (this.hasNoListeners()) {
            this.disengageModel();
        }
    }

    @Override
    public void removeCollectionChangeListener(String collectionName, CollectionChangeListener listener) {
        super.removeCollectionChangeListener(collectionName, listener);
        if (collectionName == "values" && this.hasNoListeners()) {
            this.disengageModel();
        }
    }

    protected boolean hasListeners() {
        return this.hasAnyCollectionChangeListeners("values");
    }

    protected boolean hasNoListeners() {
        return !this.hasListeners();
    }

    protected void engageModel() {
        this.valueHolder.addPropertyChangeListener("value", this.propertyChangeListener);
        this.value = this.valueHolder.getValue();
    }

    protected void disengageModel() {
        this.valueHolder.removePropertyChangeListener("value", this.propertyChangeListener);
        this.value = null;
    }

    protected void valueChanged(E newValue) {
        if (this.value != null) {
            E oldValue = this.value;
            this.value = null;
            this.fireItemRemoved("values", oldValue);
        }
        this.value = newValue;
        if (this.value != null) {
            this.fireItemAdded("values", this.value);
        }
    }

    @Override
    public void toString(StringBuilder sb) {
        sb.append(this.valueHolder);
    }
}

