/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.utility.internal;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.EventListener;
import org.eclipse.jpt.utility.internal.CollectionTools;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListenerList<L extends EventListener>
implements Serializable {
    private volatile transient L[] listeners;
    private static final long serialVersionUID = 1L;

    public ListenerList(Class<L> listenerClass) {
        this.listeners = this.buildEmptyArray(listenerClass);
    }

    private L[] buildEmptyArray(Class<L> listenerClass) {
        return (EventListener[])Array.newInstance(listenerClass, 0);
    }

    public L[] getListeners() {
        return this.listeners;
    }

    public int size() {
        return this.listeners.length;
    }

    public boolean isEmpty() {
        return this.listeners.length == 0;
    }

    public synchronized void add(L listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        if (CollectionTools.contains(this.listeners, listener)) {
            throw new IllegalArgumentException("duplicate listener: " + listener);
        }
        this.listeners = (EventListener[])CollectionTools.add(this.listeners, listener);
    }

    public synchronized void remove(L listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        int index = CollectionTools.indexOf(this.listeners, listener);
        if (index == -1) {
            throw new IllegalArgumentException("unregistered listener: " + listener);
        }
        this.listeners = (EventListener[])CollectionTools.removeElementAtIndex(this.listeners, index);
    }

    public synchronized void clear() {
        this.listeners = (EventListener[])CollectionTools.clear(this.listeners);
    }

    public String toString() {
        return Arrays.toString(this.listeners);
    }

    private synchronized void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        Class<?> listenerClass = this.listeners.getClass().getComponentType();
        s.writeObject(listenerClass);
        L[] LArray = this.listeners;
        int n = this.listeners.length;
        int n2 = 0;
        while (n2 < n) {
            L listener = LArray[n2];
            if (listener instanceof Serializable) {
                s.writeObject(listener);
            }
            ++n2;
        }
        s.writeObject(null);
    }

    private synchronized void readObject(ObjectInputStream s) throws ClassNotFoundException, IOException {
        Object o;
        s.defaultReadObject();
        Class listenerClass = (Class)s.readObject();
        this.listeners = this.buildEmptyArray(listenerClass);
        while ((o = s.readObject()) != null) {
            this.add((EventListener)o);
        }
    }
}

