/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.routineeditor.ui.launching;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.datatools.sqltools.common.ui.preferences.IDataServerLaunchPreferenceSection;
import org.eclipse.datatools.sqltools.common.ui.preferences.PreferencesRegistry;
import org.eclipse.datatools.sqltools.common.ui.util.SWTUtils;
import org.eclipse.datatools.sqltools.core.DatabaseIdentifier;
import org.eclipse.datatools.sqltools.core.SQLDevToolsConfiguration;
import org.eclipse.datatools.sqltools.core.SQLToolsFacade;
import org.eclipse.datatools.sqltools.core.profile.ProfileUtil;
import org.eclipse.datatools.sqltools.routineeditor.launching.RoutineLaunchConfigurationAttribute;
import org.eclipse.datatools.sqltools.routineeditor.ui.RoutineEditorImages;
import org.eclipse.datatools.sqltools.routineeditor.ui.RoutineEditorUIActivator;
import org.eclipse.datatools.sqltools.routineeditor.ui.launching.Messages;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationListener;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.debug.ui.ILaunchConfigurationTab;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;

public class ConnectionLevelOptionsTab
extends AbstractLaunchConfigurationTab
implements RoutineLaunchConfigurationAttribute {
    public static final String CONNECTION_LEVEL_OPTIONS_PAGE = "org.eclipse.datatools.sqltools.editor.core.preferences.ConnectionLevelOptionsPage";
    private CTabFolder _folder;
    private Composite _comp;
    private Button _useDefault;
    private Button _userDefined;
    private DatabaseIdentifier _databaseIdentifier;
    private Map _sections = new HashMap();
    private Composite _noPageAvailableComp;

    public void createControl(Composite parent) {
        this._folder = (CTabFolder)parent;
        this._comp = new Composite((Composite)this._folder, 0);
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 0;
        this._comp.setLayout((Layout)layout);
        Composite topComp = new Composite(this._comp, 0);
        new GridData(768);
        layout = new GridLayout();
        layout.verticalSpacing = 0;
        layout.marginHeight = 8;
        layout.marginWidth = 8;
        topComp.setLayout((Layout)layout);
        this._useDefault = new Button(topComp, 16);
        this._useDefault.setText(Messages.ConnectionLevelOptionsTab_use_default);
        this._useDefault.setLayoutData((Object)new GridData(768));
        this._userDefined = new Button(topComp, 16);
        this._userDefined.setText(Messages.ConnectionLevelOptionsTab_user_customize);
        this._userDefined.setLayoutData((Object)new GridData(768));
        Composite bottomComp = new Composite(this._comp, 0);
        FormLayout formlayout = new FormLayout();
        formlayout.marginHeight = 0;
        formlayout.marginWidth = 0;
        bottomComp.setLayout((Layout)formlayout);
        bottomComp.setLayoutData((Object)new GridData(768));
        Map sections = PreferencesRegistry.INSTANCE.getPageSections(CONNECTION_LEVEL_OPTIONS_PAGE);
        for (String id : sections.keySet()) {
            IDataServerLaunchPreferenceSection section;
            String name = id;
            if (name == null || (section = (IDataServerLaunchPreferenceSection)sections.get(id)) == null) continue;
            Composite dbComp = new Composite(bottomComp, 0);
            layout = new GridLayout();
            dbComp.setLayout((Layout)layout);
            FormData data = new FormData();
            dbComp.setLayoutData((Object)data);
            dbComp.setVisible(false);
            section.createSectionComposite(dbComp);
            section.setMode(1);
            this._sections.put(name, section);
        }
        this._noPageAvailableComp = new Composite(bottomComp, 0);
        layout = new GridLayout();
        layout.marginWidth = 10;
        this._noPageAvailableComp.setLayout((Layout)layout);
        Label noPageLabel = new Label(this._noPageAvailableComp, 0);
        noPageLabel.setText(Messages.ConnectionLevelOptionsTab_no_page_defined);
        this._noPageAvailableComp.setVisible(false);
        this.setControl((Control)this._comp);
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                ConnectionLevelOptionsTab.this.updateLaunchConfigurationDialog();
            }
        };
        SWTUtils.listenModify((Composite)this._comp, (Listener)listener, null);
        this._useDefault.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                for (IDataServerLaunchPreferenceSection accessor : ConnectionLevelOptionsTab.this._sections.values()) {
                    accessor.getSectionComposite().getParent().setVisible(false);
                }
                ConnectionLevelOptionsTab.this._noPageAvailableComp.setVisible(false);
                ConnectionLevelOptionsTab.this.updateLaunchConfigurationDialog();
            }
        });
        this._userDefined.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                SQLDevToolsConfiguration conf = SQLToolsFacade.getConfigurationByProfileName((String)ConnectionLevelOptionsTab.this._databaseIdentifier.getProfileName());
                IDataServerLaunchPreferenceSection accessor = (IDataServerLaunchPreferenceSection)ConnectionLevelOptionsTab.this._sections.get(conf.getDatabaseVendorDefinitionId().toString());
                if (accessor != null) {
                    accessor.getSectionComposite().getParent().setVisible(true);
                    ConnectionLevelOptionsTab.this._noPageAvailableComp.setVisible(false);
                } else {
                    ConnectionLevelOptionsTab.this._noPageAvailableComp.setVisible(true);
                }
                for (IDataServerLaunchPreferenceSection acc : ConnectionLevelOptionsTab.this._sections.values()) {
                    if (acc == accessor) continue;
                    acc.getSectionComposite().getParent().setVisible(false);
                }
                ConnectionLevelOptionsTab.this.updateLaunchConfigurationDialog();
            }
        });
    }

    private void disableOptionTabIfNecessary() {
        if (this._databaseIdentifier == null || this._databaseIdentifier.getProfileName() == null || this._databaseIdentifier.getProfileName().trim().length() == 0) {
            return;
        }
        SQLDevToolsConfiguration conf = SQLToolsFacade.getConfigurationByProfileName((String)this._databaseIdentifier.getProfileName());
        IDataServerLaunchPreferenceSection accessor = (IDataServerLaunchPreferenceSection)this._sections.get(conf.getDatabaseVendorDefinitionId().toString());
        if (accessor == null) {
            this._useDefault.setEnabled(false);
            this._userDefined.setEnabled(false);
            for (IDataServerLaunchPreferenceSection acc : this._sections.values()) {
                if (acc == accessor) continue;
                acc.getSectionComposite().getParent().setVisible(false);
            }
            this._noPageAvailableComp.setVisible(true);
            this.updateLaunchConfigurationDialog();
        } else {
            this._useDefault.setEnabled(true);
            this._userDefined.setEnabled(true);
            this._noPageAvailableComp.setVisible(false);
            this.updateLaunchConfigurationDialog();
        }
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        this.initUI(configuration);
        this.disableOptionTabIfNecessary();
        if (this._databaseIdentifier.getProfileName() != null && !this._databaseIdentifier.getProfileName().trim().equals("")) {
            SQLDevToolsConfiguration conf = SQLToolsFacade.getConfigurationByProfileName((String)this._databaseIdentifier.getProfileName());
            IDataServerLaunchPreferenceSection accessor = (IDataServerLaunchPreferenceSection)this._sections.get(conf.getDatabaseVendorDefinitionId().toString());
            if (accessor == null) {
                return;
            }
            IPreferenceStore store = RoutineEditorUIActivator.getDefault().getPreferenceStore();
            accessor.launchConfigurationInitialize(configuration, store);
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        if (this._useDefault.getSelection()) {
            configuration.setAttribute("org.eclipse.datatools.sqltools.debug.launching.optiontype", 1);
        } else if (this._userDefined.getSelection()) {
            configuration.setAttribute("org.eclipse.datatools.sqltools.debug.launching.optiontype", 2);
            try {
                String profileName = configuration.getAttribute("org.eclipse.datatools.sqltools.debug.launching.profileName", null);
                String dbName = configuration.getAttribute("org.eclipse.datatools.sqltools.debug.launching.databasename", null);
                this._databaseIdentifier = new DatabaseIdentifier(profileName, dbName);
            }
            catch (CoreException coreException) {
                return;
            }
            SQLDevToolsConfiguration conf = SQLToolsFacade.getConfigurationByProfileName((String)this._databaseIdentifier.getProfileName());
            IDataServerLaunchPreferenceSection accessor = (IDataServerLaunchPreferenceSection)this._sections.get(conf.getDatabaseVendorDefinitionId().toString());
            if (accessor != null) {
                accessor.saveConfiguration(configuration);
            }
        }
    }

    public String getName() {
        return Messages.ConnectionLevelOptionsTab_options;
    }

    public void activated(ILaunchConfigurationWorkingCopy workingCopy) {
        try {
            String profileName = workingCopy.getAttribute("org.eclipse.datatools.sqltools.debug.launching.profileName", null);
            String dbName = workingCopy.getAttribute("org.eclipse.datatools.sqltools.debug.launching.databasename", null);
            this._databaseIdentifier = new DatabaseIdentifier(profileName, dbName);
            if (this._databaseIdentifier.getProfileName() != null && !this._databaseIdentifier.getProfileName().trim().equals("") && ProfileUtil.profileExist((String)this._databaseIdentifier.getProfileName())) {
                super.activated(workingCopy);
            } else {
                ILaunchConfigurationTab[] tabs = this.getLaunchConfigurationDialog().getTabs();
                int tabsCount = tabs.length;
                ILaunchConfigurationTab mainTab = null;
                int i = 0;
                while (i < tabsCount) {
                    if (tabs[i].getName().equals(Messages.ConnectionLevelOptionsTab_maintab)) {
                        mainTab = tabs[i];
                        break;
                    }
                    ++i;
                }
                if (mainTab == null) {
                    mainTab = tabs[0];
                }
                if (this.getLaunchConfigurationDialog() instanceof ILaunchConfigurationListener) {
                    this.getLaunchConfigurationDialog().setActiveTab(mainTab);
                }
            }
        }
        catch (CoreException ce) {
            RoutineEditorUIActivator.getDefault().log(ce);
        }
    }

    private void initUI(ILaunchConfiguration configuration) {
        try {
            String profileName = configuration.getAttribute("org.eclipse.datatools.sqltools.debug.launching.profileName", null);
            String dbName = configuration.getAttribute("org.eclipse.datatools.sqltools.debug.launching.databasename", null);
            this._databaseIdentifier = new DatabaseIdentifier(profileName, dbName);
            if (profileName != null && !profileName.trim().equals("")) {
                if (!(configuration.getAttribute("org.eclipse.datatools.sqltools.debug.launching.optiontype", -1) != 1 && configuration.getAttribute("org.eclipse.datatools.sqltools.debug.launching.optiontype", -1) != -1 || this._userDefined.getSelection())) {
                    this._useDefault.setSelection(true);
                    this._userDefined.setSelection(false);
                    this._useDefault.notifyListeners(13, new Event());
                } else if ((configuration.getAttribute("org.eclipse.datatools.sqltools.debug.launching.optiontype", -1) == 1 || configuration.getAttribute("org.eclipse.datatools.sqltools.debug.launching.optiontype", -1) == -1) && this._userDefined.getSelection()) {
                    ILaunchConfigurationWorkingCopy wc = configuration.getWorkingCopy();
                    wc.setAttribute("org.eclipse.datatools.sqltools.debug.launching.optiontype", 2);
                    wc.doSave();
                    this._useDefault.setSelection(false);
                    this._userDefined.setSelection(true);
                    this._userDefined.notifyListeners(13, new Event());
                } else if (configuration.getAttribute("org.eclipse.datatools.sqltools.debug.launching.optiontype", -1) == 2) {
                    this._useDefault.setSelection(false);
                    this._userDefined.setSelection(true);
                    this._userDefined.notifyListeners(13, new Event());
                }
            }
        }
        catch (CoreException e) {
            RoutineEditorUIActivator.getDefault().log(e);
        }
    }

    private void resetComposte(Composite comp) {
        Control[] children = comp.getChildren();
        int count = children.length;
        int i = 0;
        while (i < count) {
            Control child = children[i];
            if (child instanceof Combo) {
                Combo combo = (Combo)child;
                combo.deselectAll();
            } else if (child instanceof Button) {
                Button button = (Button)child;
                button.setSelection(false);
            } else if (child instanceof Text) {
                Text text = (Text)child;
                text.setText(Messages.ConnectionLevelOptionsTab_9);
            } else if (child instanceof Composite) {
                this.resetComposte((Composite)child);
            }
            ++i;
        }
    }

    public Image getImage() {
        return RoutineEditorImages.getImage(Messages.ConnectionLevelOptionsTab_10);
    }
}

