/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.oda.spec;

public class ExpressionVariable {
    private String m_identifier;
    private VariableType m_variableType;
    private Integer m_nativeDataTypeCode;
    private String m_alias;

    public ExpressionVariable(String variableIdentfier) {
        this(variableIdentfier, VariableType.RESULT_SET_COLUMN);
    }

    public ExpressionVariable(String variableIdentfier, VariableType type) {
        this.m_identifier = variableIdentfier;
        this.setType(type);
    }

    public String getIdentifier() {
        return this.m_identifier;
    }

    public String getAlias() {
        return this.m_alias != null ? this.m_alias : this.getIdentifier();
    }

    public void setAlias(String alias) {
        this.m_alias = alias;
    }

    public VariableType getType() {
        return this.m_variableType;
    }

    public void setType(VariableType type) {
        this.m_variableType = type;
    }

    public Integer getNativeDataType() {
        return this.m_nativeDataTypeCode;
    }

    public void setNativeDataType(Integer nativeDataTypeCode) {
        this.m_nativeDataTypeCode = nativeDataTypeCode;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer(String.valueOf(this.getClass().getSimpleName()) + " identifier: ");
        buffer.append(this.m_identifier);
        buffer.append(", type: ");
        switch (this.m_variableType) {
            case RESULT_SET_COLUMN: {
                buffer.append("ResultSetColumn");
                break;
            }
            case INSTANCE_OF: {
                buffer.append("InstanceOf");
                break;
            }
            case QUERY_EXPRESSION: {
                buffer.append("QueryExpression");
                break;
            }
            default: {
                buffer.append(this.m_variableType.ordinal());
            }
        }
        return buffer.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum VariableType {
        RESULT_SET_COLUMN,
        INSTANCE_OF,
        QUERY_EXPRESSION;

    }
}

