/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.ui;

import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.dialogs.SelectionDialog;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.wst.jsdt.core.IIncludePathEntry;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.IJavaScriptProject;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.core.IPackageFragmentRoot;
import org.eclipse.wst.jsdt.core.ISourceReference;
import org.eclipse.wst.jsdt.core.JavaScriptCore;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.core.search.IJavaScriptSearchScope;
import org.eclipse.wst.jsdt.core.search.SearchEngine;
import org.eclipse.wst.jsdt.internal.corext.javadoc.JavaDocLocations;
import org.eclipse.wst.jsdt.internal.corext.refactoring.reorg.JavaElementTransfer;
import org.eclipse.wst.jsdt.internal.ui.JavaScriptPlugin;
import org.eclipse.wst.jsdt.internal.ui.JavaUIMessages;
import org.eclipse.wst.jsdt.internal.ui.SharedImages;
import org.eclipse.wst.jsdt.internal.ui.dialogs.FilteredTypesSelectionDialog;
import org.eclipse.wst.jsdt.internal.ui.dialogs.PackageSelectionDialog;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.EditorUtility;
import org.eclipse.wst.jsdt.internal.ui.util.BusyIndicatorRunnableContext;
import org.eclipse.wst.jsdt.ui.ISharedImages;
import org.eclipse.wst.jsdt.ui.IWorkingCopyManager;
import org.eclipse.wst.jsdt.ui.dialogs.TypeSelectionExtension;
import org.eclipse.wst.jsdt.ui.text.IColorManager;

public final class JavaScriptUI {
    private static ISharedImages fgSharedImages = null;
    public static final String ID_PLUGIN = "org.eclipse.wst.jsdt.ui";
    public static final String ID_PERSPECTIVE = "org.eclipse.wst.jsdt.ui.JavaPerspective";
    public static final String ID_HIERARCHYPERSPECTIVE = "org.eclipse.wst.jsdt.ui.JavaHierarchyPerspective";
    public static final String ID_ACTION_SET = "org.eclipse.wst.jsdt.ui.JavaActionSet";
    public static final String ID_ELEMENT_CREATION_ACTION_SET = "org.eclipse.wst.jsdt.ui.JavaElementCreationActionSet";
    public static final String ID_CODING_ACTION_SET = "org.eclipse.wst.jsdt.ui.CodingActionSet";
    public static final String ID_OPEN_ACTION_SET = "org.eclipse.wst.jsdt.ui.A_OpenActionSet";
    public static final String ID_SEARCH_ACTION_SET = "org.eclipse.wst.jsdt.ui.SearchActionSet";
    public static final String ID_CU_EDITOR = "org.eclipse.wst.jsdt.ui.CompilationUnitEditor";
    public static final String ID_CF_EDITOR = "org.eclipse.wst.jsdt.ui.ClassFileEditor";
    public static final String ID_SNIPPET_EDITOR = "org.eclipse.wst.jsdt.ui.SnippetEditor";
    public static final String ID_PACKAGES = "org.eclipse.wst.jsdt.ui.PackageExplorer";
    public static final String ID_TYPE_HIERARCHY = "org.eclipse.wst.jsdt.ui.TypeHierarchy";
    public static final String ID_SOURCE_VIEW = "org.eclipse.wst.jsdt.ui.SourceView";
    public static final String ID_JAVADOC_VIEW = "org.eclipse.wst.jsdt.ui.JavadocView";
    public static String ID_BROWSING_PERSPECTIVE = "org.eclipse.wst.jsdt.ui.JavaBrowsingPerspective";
    public static String ID_PROJECTS_VIEW = "org.eclipse.wst.jsdt.ui.ProjectsView";
    public static String ID_PACKAGES_VIEW = "org.eclipse.wst.jsdt.ui.PackagesView";
    public static String ID_TYPES_VIEW = "org.eclipse.wst.jsdt.ui.TypesView";
    public static String ID_MEMBERS_VIEW = "org.eclipse.wst.jsdt.ui.MembersView";
    static /* synthetic */ Class class$0;

    private JavaScriptUI() {
    }

    public static ISharedImages getSharedImages() {
        if (fgSharedImages == null) {
            fgSharedImages = new SharedImages();
        }
        return fgSharedImages;
    }

    public static SelectionDialog createPackageDialog(Shell parent, IJavaScriptProject project, int style, String filter) throws JavaScriptModelException {
        Assert.isTrue(((style | 8 | 0x20) == 40 ? 1 : 0) != 0);
        IPackageFragmentRoot[] roots = null;
        roots = (style & 0x20) != 0 ? project.getAllPackageFragmentRoots() : project.getPackageFragmentRoots();
        List<IPackageFragmentRoot> consideredRoots = null;
        if ((style & 8) != 0) {
            consideredRoots = Arrays.asList(roots);
        } else {
            consideredRoots = new ArrayList<IPackageFragmentRoot>(roots.length);
            int i = 0;
            while (i < roots.length) {
                IPackageFragmentRoot root = roots[i];
                if (root.getKind() != 2) {
                    consideredRoots.add(root);
                }
                ++i;
            }
        }
        IJavaScriptSearchScope searchScope = SearchEngine.createJavaSearchScope((IJavaScriptElement[])consideredRoots.toArray(new IJavaScriptElement[consideredRoots.size()]));
        BusyIndicatorRunnableContext context = new BusyIndicatorRunnableContext();
        if (style == 0 || style == 32) {
            return JavaScriptUI.createPackageDialog(parent, context, searchScope, false, true, filter);
        }
        return JavaScriptUI.createPackageDialog(parent, context, searchScope, false, false, filter);
    }

    public static SelectionDialog createPackageDialog(Shell parent, IRunnableContext context, IJavaScriptSearchScope scope, boolean multipleSelection, boolean removeDuplicates, String filter) {
        int flag = removeDuplicates ? 1 : 0;
        PackageSelectionDialog dialog = new PackageSelectionDialog(parent, context, flag, scope);
        dialog.setFilter(filter);
        dialog.setIgnoreCase(false);
        dialog.setMultipleSelection(multipleSelection);
        return dialog;
    }

    public static SelectionDialog createPackageDialog(Shell parent, IJavaScriptProject project, int style) throws JavaScriptModelException {
        return JavaScriptUI.createPackageDialog(parent, project, style, "");
    }

    public static SelectionDialog createPackageDialog(Shell parent, IPackageFragmentRoot root, String filter) throws JavaScriptModelException {
        IJavaScriptSearchScope scope = SearchEngine.createJavaSearchScope((IJavaScriptElement[])new IJavaScriptElement[]{root});
        BusyIndicatorRunnableContext context = new BusyIndicatorRunnableContext();
        return JavaScriptUI.createPackageDialog(parent, context, scope, false, true, filter);
    }

    public static SelectionDialog createPackageDialog(Shell parent, IPackageFragmentRoot root) throws JavaScriptModelException {
        return JavaScriptUI.createPackageDialog(parent, root, "");
    }

    public static SelectionDialog createTypeDialog(Shell parent, IRunnableContext context, IProject project, int style, boolean multipleSelection) throws JavaScriptModelException {
        IJavaScriptSearchScope scope = SearchEngine.createJavaSearchScope((IJavaScriptElement[])new IJavaScriptProject[]{JavaScriptCore.create((IProject)project)});
        return JavaScriptUI.createTypeDialog(parent, context, scope, style, multipleSelection);
    }

    public static SelectionDialog createTypeDialog(Shell parent, IRunnableContext context, IJavaScriptSearchScope scope, int style, boolean multipleSelection) throws JavaScriptModelException {
        return JavaScriptUI.createTypeDialog(parent, context, scope, style, multipleSelection, "");
    }

    public static SelectionDialog createTypeDialog(Shell parent, IRunnableContext context, IJavaScriptSearchScope scope, int style, boolean multipleSelection, String filter) throws JavaScriptModelException {
        return JavaScriptUI.createTypeDialog(parent, context, scope, style, multipleSelection, filter, null);
    }

    public static SelectionDialog createTypeDialog(Shell parent, IRunnableContext context, IJavaScriptSearchScope scope, int style, boolean multipleSelection, String filter, TypeSelectionExtension extension) throws JavaScriptModelException {
        int elementKinds = 0;
        if (style == 256) {
            elementKinds = 0;
        } else if (style == 4) {
            elementKinds = 6;
        } else if (style == 2) {
            elementKinds = 5;
        } else if (style == 64) {
            elementKinds = 8;
        } else if (style == 128) {
            elementKinds = 7;
        } else if (style == 512) {
            elementKinds = 10;
        } else if (style == 1024) {
            elementKinds = 9;
        } else {
            throw new IllegalArgumentException("Invalid style constant.");
        }
        FilteredTypesSelectionDialog dialog = new FilteredTypesSelectionDialog(parent, multipleSelection, context, scope, elementKinds, extension);
        dialog.setMessage(JavaUIMessages.JavaUI_defaultDialogMessage);
        dialog.setInitialPattern(filter);
        return dialog;
    }

    public static IEditorPart openInEditor(IJavaScriptElement element) throws JavaScriptModelException, PartInitException {
        return JavaScriptUI.openInEditor(element, true, true);
    }

    public static IEditorPart openInEditor(IJavaScriptElement element, boolean activate, boolean reveal) throws JavaScriptModelException, PartInitException {
        if (!(element instanceof ISourceReference)) {
            return null;
        }
        IEditorPart part = EditorUtility.openInEditor(element, activate);
        if (reveal && part != null) {
            EditorUtility.revealInEditor(part, element);
        }
        return part;
    }

    public static void revealInEditor(IEditorPart part, IJavaScriptElement element) {
        EditorUtility.revealInEditor(part, element);
    }

    public static IWorkingCopyManager getWorkingCopyManager() {
        return JavaScriptPlugin.getDefault().getWorkingCopyManager();
    }

    public static IJavaScriptElement getEditorInputJavaElement(IEditorInput editorInput) {
        IJavaScriptUnit je = JavaScriptPlugin.getDefault().getWorkingCopyManager().getWorkingCopy(editorInput);
        if (je != null) {
            return je;
        }
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.wst.jsdt.core.IJavaScriptElement");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (IJavaScriptElement)editorInput.getAdapter((Class)clazz);
    }

    public static IDocumentProvider getDocumentProvider() {
        return JavaScriptPlugin.getDefault().getCompilationUnitDocumentProvider();
    }

    public static URL getLibraryJSdocLocation(IIncludePathEntry entry) {
        return JavaDocLocations.getLibraryJavadocLocation(entry);
    }

    public static void setProjectJSdocLocation(IJavaScriptProject project, URL url) {
        JavaDocLocations.setProjectJavadocLocation(project, url);
    }

    public static URL getProjectJSdocLocation(IJavaScriptProject project) {
        return JavaDocLocations.getProjectJavadocLocation(project);
    }

    public static URL getJSdocBaseLocation(IJavaScriptElement element) throws JavaScriptModelException {
        return JavaDocLocations.getJavadocBaseLocation(element);
    }

    public static URL getJSdocLocation(IJavaScriptElement element, boolean includeAnchor) throws JavaScriptModelException {
        return JavaDocLocations.getJavadocLocation(element, includeAnchor);
    }

    public static Transfer getJavaElementClipboardTransfer() {
        return JavaElementTransfer.getInstance();
    }

    public static IColorManager getColorManager() {
        return JavaScriptPlugin.getDefault().getJavaTextTools().getColorManager();
    }
}

