/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.fix;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.core.compiler.IProblem;
import org.eclipse.wst.jsdt.core.dom.JavaScriptUnit;
import org.eclipse.wst.jsdt.internal.corext.fix.CodeStyleFix;
import org.eclipse.wst.jsdt.internal.corext.fix.IFix;
import org.eclipse.wst.jsdt.internal.ui.fix.AbstractCleanUp;
import org.eclipse.wst.jsdt.internal.ui.fix.MultiFixMessages;
import org.eclipse.wst.jsdt.ui.text.java.IProblemLocation;

public class CodeStyleCleanUp
extends AbstractCleanUp {
    public CodeStyleCleanUp() {
        this(null);
    }

    public CodeStyleCleanUp(Map options) {
        super(options);
    }

    public boolean requireAST(IJavaScriptUnit unit) throws CoreException {
        boolean nonStaticFields = this.isEnabled("cleanup.use_this_for_non_static_field_access");
        boolean nonStaticMethods = this.isEnabled("cleanup.use_this_for_non_static_method_access");
        boolean qualifyStatic = this.isEnabled("cleanup.qualify_static_member_accesses_with_declaring_class");
        return nonStaticFields && this.isEnabled("cleanup.always_use_this_for_non_static_field_access") || qualifyStatic && this.isEnabled("cleanup.qualify_static_member_accesses_through_instances_with_declaring_class") || qualifyStatic && this.isEnabled("cleanup.qualify_static_field_accesses_with_declaring_class") || qualifyStatic && this.isEnabled("cleanup.qualify_static_member_accesses_through_subtypes_with_declaring_class") || nonStaticMethods && this.isEnabled("cleanup.always_use_this_for_non_static_method_access") || qualifyStatic && this.isEnabled("cleanup.qualify_static_method_accesses_with_declaring_class") || nonStaticFields && this.isEnabled("cleanup.use_this_for_non_static_field_access_only_if_necessary") || nonStaticMethods && this.isEnabled("cleanup.use_this_for_non_static_method_access_only_if_necessary");
    }

    public IFix createFix(JavaScriptUnit compilationUnit) throws CoreException {
        if (compilationUnit == null) {
            return null;
        }
        boolean nonStaticFields = this.isEnabled("cleanup.use_this_for_non_static_field_access");
        boolean nonStaticMethods = this.isEnabled("cleanup.use_this_for_non_static_method_access");
        boolean qualifyStatic = this.isEnabled("cleanup.qualify_static_member_accesses_with_declaring_class");
        return CodeStyleFix.createCleanUp(compilationUnit, nonStaticFields && this.isEnabled("cleanup.always_use_this_for_non_static_field_access"), qualifyStatic && this.isEnabled("cleanup.qualify_static_member_accesses_through_instances_with_declaring_class"), qualifyStatic && this.isEnabled("cleanup.qualify_static_field_accesses_with_declaring_class"), qualifyStatic && this.isEnabled("cleanup.qualify_static_member_accesses_through_subtypes_with_declaring_class"), nonStaticMethods && this.isEnabled("cleanup.always_use_this_for_non_static_method_access"), qualifyStatic && this.isEnabled("cleanup.qualify_static_method_accesses_with_declaring_class"), nonStaticFields && this.isEnabled("cleanup.use_this_for_non_static_field_access_only_if_necessary"), nonStaticMethods && this.isEnabled("cleanup.use_this_for_non_static_method_access_only_if_necessary"));
    }

    public IFix createFix(JavaScriptUnit compilationUnit, IProblemLocation[] problems) throws CoreException {
        if (compilationUnit == null) {
            return null;
        }
        return CodeStyleFix.createCleanUp(compilationUnit, problems, this.isEnabled("cleanup.use_this_for_non_static_field_access") && this.isEnabled("cleanup.always_use_this_for_non_static_field_access"), this.isEnabled("cleanup.qualify_static_member_accesses_with_declaring_class") && this.isEnabled("cleanup.qualify_static_member_accesses_through_instances_with_declaring_class"), this.isEnabled("cleanup.qualify_static_member_accesses_with_declaring_class") && this.isEnabled("cleanup.qualify_static_member_accesses_through_subtypes_with_declaring_class"));
    }

    public Map getRequiredOptions() {
        Hashtable<String, String> options = new Hashtable<String, String>();
        if (this.isEnabled("cleanup.qualify_static_member_accesses_with_declaring_class") && this.isEnabled("cleanup.qualify_static_member_accesses_through_instances_with_declaring_class")) {
            options.put("org.eclipse.wst.jsdt.core.compiler.problem.staticAccessReceiver", "warning");
        }
        if (this.isEnabled("cleanup.qualify_static_member_accesses_with_declaring_class") && this.isEnabled("cleanup.qualify_static_member_accesses_through_subtypes_with_declaring_class")) {
            options.put("org.eclipse.wst.jsdt.core.compiler.problem.indirectStaticAccess", "warning");
        }
        return options;
    }

    public String[] getDescriptions() {
        ArrayList<String> result = new ArrayList<String>();
        if (this.isEnabled("cleanup.use_this_for_non_static_field_access") && this.isEnabled("cleanup.always_use_this_for_non_static_field_access")) {
            result.add(MultiFixMessages.CodeStyleMultiFix_AddThisQualifier_description);
        }
        if (this.isEnabled("cleanup.use_this_for_non_static_method_access") && this.isEnabled("cleanup.always_use_this_for_non_static_method_access")) {
            result.add(MultiFixMessages.CodeStyleCleanUp_QualifyNonStaticMethod_description);
        }
        if (this.isEnabled("cleanup.use_this_for_non_static_field_access") && this.isEnabled("cleanup.use_this_for_non_static_field_access_only_if_necessary")) {
            result.add(MultiFixMessages.CodeStyleCleanUp_removeFieldThis_description);
        }
        if (this.isEnabled("cleanup.use_this_for_non_static_method_access") && this.isEnabled("cleanup.use_this_for_non_static_method_access_only_if_necessary")) {
            result.add(MultiFixMessages.CodeStyleCleanUp_removeMethodThis_description);
        }
        if (this.isEnabled("cleanup.qualify_static_member_accesses_with_declaring_class") && this.isEnabled("cleanup.qualify_static_field_accesses_with_declaring_class")) {
            result.add(MultiFixMessages.CodeStyleMultiFix_QualifyAccessToStaticField);
        }
        if (this.isEnabled("cleanup.qualify_static_member_accesses_with_declaring_class") && this.isEnabled("cleanup.qualify_static_method_accesses_with_declaring_class")) {
            result.add(MultiFixMessages.CodeStyleCleanUp_QualifyStaticMethod_description);
        }
        if (this.isEnabled("cleanup.qualify_static_member_accesses_with_declaring_class") && this.isEnabled("cleanup.qualify_static_member_accesses_through_instances_with_declaring_class")) {
            result.add(MultiFixMessages.CodeStyleMultiFix_ChangeNonStaticAccess_description);
        }
        if (this.isEnabled("cleanup.qualify_static_member_accesses_with_declaring_class") && this.isEnabled("cleanup.qualify_static_member_accesses_through_subtypes_with_declaring_class")) {
            result.add(MultiFixMessages.CodeStyleMultiFix_ChangeIndirectAccessToStaticToDirect);
        }
        return result.toArray(new String[result.size()]);
    }

    public String getPreview() {
        StringBuffer buf = new StringBuffer();
        buf.append("private int value;\n");
        buf.append("public int get() {\n");
        if (this.isEnabled("cleanup.use_this_for_non_static_field_access") && this.isEnabled("cleanup.always_use_this_for_non_static_field_access")) {
            buf.append("    return this.value + this.value;\n");
        } else if (this.isEnabled("cleanup.use_this_for_non_static_field_access") && this.isEnabled("cleanup.use_this_for_non_static_field_access_only_if_necessary")) {
            buf.append("    return value + value;\n");
        } else {
            buf.append("    return this.value + value;\n");
        }
        buf.append("}\n");
        buf.append("\n");
        buf.append("public int getZero() {\n");
        if (this.isEnabled("cleanup.use_this_for_non_static_method_access") && this.isEnabled("cleanup.always_use_this_for_non_static_method_access")) {
            buf.append("    return this.get() - this.get();\n");
        } else if (this.isEnabled("cleanup.use_this_for_non_static_method_access") && this.isEnabled("cleanup.use_this_for_non_static_method_access_only_if_necessary")) {
            buf.append("    return get() - get();\n");
        } else {
            buf.append("    return this.get() - get();\n");
        }
        buf.append("}\n");
        buf.append("\n");
        buf.append("class E {\n");
        buf.append("    public static int NUMBER;\n");
        buf.append("    public static void set(int i) {\n");
        if (this.isEnabled("cleanup.qualify_static_member_accesses_with_declaring_class") && this.isEnabled("cleanup.qualify_static_field_accesses_with_declaring_class")) {
            buf.append("        E.NUMBER= i;\n");
        } else {
            buf.append("        NUMBER= i;\n");
        }
        buf.append("    }\n");
        buf.append("\n");
        buf.append("    public void reset() {\n");
        if (this.isEnabled("cleanup.qualify_static_member_accesses_with_declaring_class") && this.isEnabled("cleanup.qualify_static_method_accesses_with_declaring_class")) {
            buf.append("        E.set(0);\n");
        } else {
            buf.append("        set(0);\n");
        }
        buf.append("    }\n");
        buf.append("}\n");
        buf.append("\n");
        buf.append("class ESub extends E {\n");
        buf.append("    public void reset() {\n");
        if (this.isEnabled("cleanup.qualify_static_member_accesses_with_declaring_class") && this.isEnabled("cleanup.qualify_static_member_accesses_through_subtypes_with_declaring_class")) {
            buf.append("        E.NUMBER= 0;\n");
        } else {
            buf.append("        ESub.NUMBER= 0;\n");
        }
        buf.append("    }\n");
        buf.append("}\n");
        buf.append("\n");
        buf.append("public void dec() {\n");
        if (this.isEnabled("cleanup.qualify_static_member_accesses_with_declaring_class") && this.isEnabled("cleanup.qualify_static_member_accesses_through_instances_with_declaring_class")) {
            buf.append("    E.NUMBER--;\n");
        } else {
            buf.append("    (new E()).NUMBER--;\n");
        }
        buf.append("}\n");
        return buf.toString();
    }

    public boolean canFix(JavaScriptUnit compilationUnit, IProblemLocation problem) throws CoreException {
        CodeStyleFix[] fixes;
        CodeStyleFix fix;
        if (this.isEnabled("cleanup.qualify_static_member_accesses_with_declaring_class") && this.isEnabled("cleanup.qualify_static_member_accesses_through_subtypes_with_declaring_class") && (fix = CodeStyleFix.createIndirectAccessToStaticFix(compilationUnit, problem)) != null) {
            return true;
        }
        return this.isEnabled("cleanup.qualify_static_member_accesses_with_declaring_class") && this.isEnabled("cleanup.qualify_static_member_accesses_through_instances_with_declaring_class") && (fixes = CodeStyleFix.createNonStaticAccessFixes(compilationUnit, problem)) != null && fixes.length > 0;
    }

    public int maximalNumberOfFixes(JavaScriptUnit compilationUnit) {
        int id;
        int i;
        int result = 0;
        IProblem[] problems = compilationUnit.getProblems();
        if (this.isEnabled("cleanup.use_this_for_non_static_field_access") && this.isEnabled("cleanup.always_use_this_for_non_static_field_access")) {
            result += this.getNumberOfProblems(problems, 570425423);
        }
        if (this.isEnabled("cleanup.qualify_static_member_accesses_with_declaring_class") && this.isEnabled("cleanup.qualify_static_member_accesses_through_subtypes_with_declaring_class")) {
            i = 0;
            while (i < problems.length) {
                id = problems[i].getID();
                if (id == 570425422 || id == 603979895) {
                    ++result;
                }
                ++i;
            }
        }
        if (this.isEnabled("cleanup.qualify_static_member_accesses_with_declaring_class") && this.isEnabled("cleanup.qualify_static_member_accesses_through_instances_with_declaring_class")) {
            i = 0;
            while (i < problems.length) {
                id = problems[i].getID();
                if (id == 570425420 || id == 603979893) {
                    ++result;
                }
                ++i;
            }
        }
        return result;
    }
}

